/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ManagedChannel;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.ManagedChannelBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.netty.NettyChannelBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel.SocketAddressFactory;

public abstract class ManagedChannelFactory {
    public static ManagedChannelFactory createDefault() {
        return new Default();
    }

    public static ManagedChannelFactory createEpoll() {
        io.netty.channel.epoll.Epoll.ensureAvailability();
        return new Epoll();
    }

    public abstract ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor var1);

    private static class Default
    extends ManagedChannelFactory {
        private Default() {
        }

        @Override
        public ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
            return ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(apiServiceDescriptor.getUrl()).usePlaintext(true)).maxInboundMessageSize(Integer.MAX_VALUE)).build();
        }
    }

    private static class Epoll
    extends ManagedChannelFactory {
        private Epoll() {
        }

        @Override
        public ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
            SocketAddress address = SocketAddressFactory.createFrom(apiServiceDescriptor.getUrl());
            return ((NettyChannelBuilder)NettyChannelBuilder.forAddress(address).channelType(address instanceof DomainSocketAddress ? EpollDomainSocketChannel.class : EpollSocketChannel.class).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).usePlaintext(true).maxInboundMessageSize(Integer.MAX_VALUE)).build();
        }
    }
}

