/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.StreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.StreamObserverFactory;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataGrpcMultiplexer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataGrpcMultiplexer.class);
    @Nullable
    private final Endpoints.ApiServiceDescriptor apiServiceDescriptor;
    private final StreamObserver<BeamFnApi.Elements> inboundObserver;
    private final StreamObserver<BeamFnApi.Elements> outboundObserver;
    private final ConcurrentMap<LogicalEndpoint, CompletableFuture<Consumer<BeamFnApi.Elements.Data>>> consumers;

    public BeamFnDataGrpcMultiplexer(@Nullable Endpoints.ApiServiceDescriptor apiServiceDescriptor, StreamObserverFactory.StreamObserverClientFactory<BeamFnApi.Elements, BeamFnApi.Elements> outboundObserverFactory) {
        this.apiServiceDescriptor = apiServiceDescriptor;
        this.consumers = new ConcurrentHashMap<LogicalEndpoint, CompletableFuture<Consumer<BeamFnApi.Elements.Data>>>();
        this.inboundObserver = new InboundObserver();
        this.outboundObserver = outboundObserverFactory.outboundObserverFor(this.inboundObserver);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("apiServiceDescriptor", this.apiServiceDescriptor).add("consumers", this.consumers).toString();
    }

    public StreamObserver<BeamFnApi.Elements> getInboundObserver() {
        return this.inboundObserver;
    }

    public StreamObserver<BeamFnApi.Elements> getOutboundObserver() {
        return this.outboundObserver;
    }

    private CompletableFuture<Consumer<BeamFnApi.Elements.Data>> receiverFuture(LogicalEndpoint endpoint) {
        return this.consumers.computeIfAbsent(endpoint, unused -> new CompletableFuture());
    }

    public void registerConsumer(LogicalEndpoint inputLocation, Consumer<BeamFnApi.Elements.Data> dataBytesReceiver) {
        this.receiverFuture(inputLocation).complete(dataBytesReceiver);
    }

    @VisibleForTesting
    boolean hasConsumer(LogicalEndpoint outputLocation) {
        return this.consumers.containsKey(outputLocation);
    }

    @Override
    public void close() {
        for (CompletableFuture receiver : ImmutableList.copyOf(this.consumers.values())) {
            receiver.cancel(true);
        }
        this.outboundObserver.onError(Status.CANCELLED.withDescription("Multiplexer hanging up").asException());
        this.inboundObserver.onCompleted();
    }

    private final class InboundObserver
    implements StreamObserver<BeamFnApi.Elements> {
        private InboundObserver() {
        }

        @Override
        public void onNext(BeamFnApi.Elements value) {
            for (BeamFnApi.Elements.Data data : value.getDataList()) {
                try {
                    LogicalEndpoint key = LogicalEndpoint.of(data.getInstructionReference(), data.getTarget());
                    CompletableFuture consumer = BeamFnDataGrpcMultiplexer.this.receiverFuture(key);
                    if (!consumer.isDone()) {
                        LOG.debug("Received data for key {} without consumer ready. Waiting for consumer to be registered.", (Object)key);
                    }
                    ((Consumer)consumer.get()).accept(data);
                    if (!data.getData().isEmpty()) continue;
                    BeamFnDataGrpcMultiplexer.this.consumers.remove(key);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Client interrupted during handling of data for instruction {} and target {}", new Object[]{data.getInstructionReference(), data.getTarget(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError(e);
                }
                catch (RuntimeException e) {
                    LOG.error("Client failed to handle data for instruction {} and target {}", new Object[]{data.getInstructionReference(), data.getTarget(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError(e);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            LOG.error("Failed to handle for {}", BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor, (Object)t);
        }

        @Override
        public void onCompleted() {
            LOG.warn("Hanged up for {}.", BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor);
        }
    }
}

