/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.CallStreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.StreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.AdvancingPhaser;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.DirectStreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.ForwardingClientResponseObserver;

public abstract class StreamObserverFactory {
    public static StreamObserverFactory buffered(ExecutorService executorService) {
        return new Buffered(executorService, 64);
    }

    public static StreamObserverFactory buffered(ExecutorService executorService, int bufferSize) {
        return new Buffered(executorService, bufferSize);
    }

    public static StreamObserverFactory direct() {
        return new Direct();
    }

    public abstract <ReqT, RespT> StreamObserver<RespT> from(StreamObserverClientFactory<ReqT, RespT> var1, StreamObserver<ReqT> var2);

    private static Runnable arriveAtPhaserHandler(AdvancingPhaser phaser) {
        return phaser::arrive;
    }

    public static interface StreamObserverClientFactory<RequestT, ResponseT> {
        public StreamObserver<ResponseT> outboundObserverFor(StreamObserver<RequestT> var1);
    }

    private static class Buffered
    extends StreamObserverFactory {
        private static final int DEFAULT_BUFFER_SIZE = 64;
        private final ExecutorService executorService;
        private final int bufferSize;

        private Buffered(ExecutorService executorService, int bufferSize) {
            this.executorService = executorService;
            this.bufferSize = bufferSize;
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> from(StreamObserverClientFactory<ReqT, RespT> clientFactory, StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            CallStreamObserver outboundObserver = (CallStreamObserver)clientFactory.outboundObserverFor(ForwardingClientResponseObserver.create(inboundObserver, StreamObserverFactory.arriveAtPhaserHandler(phaser)));
            return new BufferingStreamObserver(phaser, outboundObserver, this.executorService, this.bufferSize);
        }
    }

    private static class Direct
    extends StreamObserverFactory {
        private Direct() {
        }

        @Override
        public <ReqT, RespT> StreamObserver<RespT> from(StreamObserverClientFactory<ReqT, RespT> clientFactory, StreamObserver<ReqT> inboundObserver) {
            AdvancingPhaser phaser = new AdvancingPhaser(1);
            CallStreamObserver outboundObserver = (CallStreamObserver)clientFactory.outboundObserverFor(ForwardingClientResponseObserver.create(inboundObserver, StreamObserverFactory.arriveAtPhaserHandler(phaser)));
            return new DirectStreamObserver(phaser, outboundObserver);
        }
    }
}

