/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.ListMultimap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformInputs;
import org.apache.beam.runners.direct.ExecutableGraph;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;

class DirectGraph
implements ExecutableGraph<AppliedPTransform<?, ?, ?>, PValue> {
    private final Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers;
    private final Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters;
    private final ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers;
    private final Set<AppliedPTransform<?, ?, ?>> rootTransforms;
    private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;

    public static DirectGraph create(Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers, Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        return new DirectGraph(producers, viewWriters, perElementConsumers, rootTransforms, stepNames);
    }

    private DirectGraph(Map<PCollection<?>, AppliedPTransform<?, ?, ?>> producers, Map<PCollectionView<?>, AppliedPTransform<?, ?, ?>> viewWriters, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> perElementConsumers, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        this.producers = producers;
        this.viewWriters = viewWriters;
        this.perElementConsumers = perElementConsumers;
        this.rootTransforms = rootTransforms;
        this.stepNames = stepNames;
    }

    @Override
    public AppliedPTransform<?, ?, ?> getProducer(PValue produced) {
        if (produced instanceof PCollection) {
            return this.producers.get(produced);
        }
        if (produced instanceof PCollectionView) {
            return this.getWriter((PCollectionView)produced);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %s. Known types: %s and %s", PValue.class.getSimpleName(), produced.getClass().getName(), PCollection.class.getSimpleName(), PCollectionView.class.getSimpleName()));
    }

    @Override
    public Collection<PValue> getProduced(AppliedPTransform<?, ?, ?> producer) {
        return producer.getOutputs().values();
    }

    @Override
    public Collection<PValue> getPerElementInputs(AppliedPTransform<?, ?, ?> transform) {
        return TransformInputs.nonAdditionalInputs(transform);
    }

    private AppliedPTransform<?, ?, ?> getWriter(PCollectionView<?> view) {
        return this.viewWriters.get(view);
    }

    @Override
    public List<AppliedPTransform<?, ?, ?>> getPerElementConsumers(PValue consumed) {
        return this.perElementConsumers.get((PInput)consumed);
    }

    @Override
    public Set<AppliedPTransform<?, ?, ?>> getRootTransforms() {
        return this.rootTransforms;
    }

    @Override
    public Collection<AppliedPTransform<?, ?, ?>> getExecutables() {
        return this.stepNames.keySet();
    }

    Set<PCollectionView<?>> getViews() {
        return this.viewWriters.keySet();
    }

    String getStepName(AppliedPTransform<?, ?, ?> step) {
        return this.stepNames.get(step);
    }
}

