/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.TimerInternals;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DoFnLifecycleManagerRemovingTransformEvaluator<InputT>
implements TransformEvaluator<InputT> {
    private static final Logger LOG = LoggerFactory.getLogger(DoFnLifecycleManagerRemovingTransformEvaluator.class);
    private final ParDoEvaluator<InputT> underlying;
    private final DoFnLifecycleManager lifecycleManager;

    public static <InputT> DoFnLifecycleManagerRemovingTransformEvaluator<InputT> wrapping(ParDoEvaluator<InputT> underlying, DoFnLifecycleManager lifecycleManager) {
        return new DoFnLifecycleManagerRemovingTransformEvaluator<InputT>(underlying, lifecycleManager);
    }

    private DoFnLifecycleManagerRemovingTransformEvaluator(ParDoEvaluator<InputT> underlying, DoFnLifecycleManager lifecycleManager) {
        this.underlying = underlying;
        this.lifecycleManager = lifecycleManager;
    }

    public ParDoEvaluator<InputT> getParDoEvaluator() {
        return this.underlying;
    }

    @Override
    public void processElement(WindowedValue<InputT> element) throws Exception {
        try {
            this.underlying.processElement(element);
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after processing an element");
            throw e;
        }
    }

    public void onTimer(TimerInternals.TimerData timer, BoundedWindow window) throws Exception {
        try {
            this.underlying.onTimer(timer, window);
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after processing a timer");
            throw e;
        }
    }

    @Override
    public TransformResult<InputT> finishBundle() throws Exception {
        try {
            return this.underlying.finishBundle();
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after finishing a bundle");
            throw e;
        }
    }

    private void onException(Exception e, String msg) {
        try {
            this.lifecycleManager.remove();
        }
        catch (Exception removalException) {
            if (removalException instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error(msg, (Throwable)removalException);
            e.addSuppressed(removalException);
        }
    }
}

