/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_direct_java.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.runners.direct.ExecutableGraph;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.FlattenEvaluatorFactory;
import org.apache.beam.runners.direct.portable.GroupAlsoByWindowEvaluatorFactory;
import org.apache.beam.runners.direct.portable.GroupByKeyOnlyEvaluatorFactory;
import org.apache.beam.runners.direct.portable.ImpulseEvaluatorFactory;
import org.apache.beam.runners.direct.portable.RemoteStageEvaluatorFactory;
import org.apache.beam.runners.direct.portable.StepStateAndTimers;
import org.apache.beam.runners.direct.portable.TransformEvaluator;
import org.apache.beam.runners.direct.portable.TransformEvaluatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformEvaluatorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TransformEvaluatorRegistry.class);
    private final Map<String, TransformEvaluatorFactory> factories;
    private final AtomicBoolean finished = new AtomicBoolean(false);

    static TransformEvaluatorRegistry portableRegistry(ExecutableGraph<PipelineNode.PTransformNode, PipelineNode.PCollectionNode> graph, RunnerApi.Components components, BundleFactory bundleFactory, JobBundleFactory jobBundleFactory, StepStateAndTimers.Provider stepStateAndTimers) {
        return new TransformEvaluatorRegistry(ImmutableMap.builder().put(PTransformTranslation.IMPULSE_TRANSFORM_URN, new ImpulseEvaluatorFactory(graph, bundleFactory)).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, (ImpulseEvaluatorFactory)((Object)new FlattenEvaluatorFactory(graph, bundleFactory))).put("urn:beam:directrunner:transforms:gbko:v1", (ImpulseEvaluatorFactory)((Object)new GroupByKeyOnlyEvaluatorFactory(graph, components, bundleFactory))).put("urn:beam:directrunner:transforms:gabw:v1", (ImpulseEvaluatorFactory)((Object)new GroupAlsoByWindowEvaluatorFactory(graph, components, bundleFactory, stepStateAndTimers))).put("beam:runner:executable_stage:v1", (ImpulseEvaluatorFactory)((Object)new RemoteStageEvaluatorFactory(bundleFactory, jobBundleFactory))).build());
    }

    private TransformEvaluatorRegistry(Map<String, TransformEvaluatorFactory> factories) {
        this.factories = factories;
    }

    public <InputT> TransformEvaluator<InputT> forApplication(PipelineNode.PTransformNode application, CommittedBundle<?> inputBundle) throws Exception {
        Preconditions.checkState(!this.finished.get(), "Tried to get an evaluator for a finished TransformEvaluatorRegistry");
        String urn = PTransformTranslation.urnForTransformOrNull(application.getTransform());
        TransformEvaluatorFactory factory = Preconditions.checkNotNull(this.factories.get(urn), "No evaluator for PTransform \"%s\"", (Object)urn);
        return factory.forApplication(application, inputBundle);
    }

    public void cleanup() throws Exception {
        ArrayList<Exception> thrownInCleanup = new ArrayList<Exception>();
        for (TransformEvaluatorFactory factory : this.factories.values()) {
            try {
                factory.cleanup();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                thrownInCleanup.add(e);
            }
        }
        this.finished.set(true);
        if (!thrownInCleanup.isEmpty()) {
            LOG.error("Exceptions {} thrown while cleaning up evaluators", thrownInCleanup);
            Exception toThrow = null;
            for (Exception e : thrownInCleanup) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }
}

