/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.job;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.Status;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.StatusRuntimeException;
import org.apache.beam.repackaged.beam_runners_direct_java.io.grpc.stub.StreamObserver;
import org.apache.beam.repackaged.beam_runners_direct_java.model.jobmanagement.v1.JobApi;
import org.apache.beam.repackaged.beam_runners_direct_java.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.FnService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.runners.direct.portable.ReferenceRunner;
import org.apache.beam.runners.direct.portable.artifact.LocalFileSystemArtifactStagerService;
import org.apache.beam.runners.direct.portable.job.PreparingJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceRunnerJobService
extends JobServiceGrpc.JobServiceImplBase
implements FnService {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceRunnerJobService.class);
    private final ServerFactory serverFactory;
    private final Callable<Path> stagingPathCallable;
    private final ConcurrentMap<String, PreparingJob> unpreparedJobs;
    private final ConcurrentMap<String, ReferenceRunner> runningJobs;
    private final ExecutorService executor;

    public static ReferenceRunnerJobService create(ServerFactory serverFactory) {
        return new ReferenceRunnerJobService(serverFactory, () -> Files.createTempDirectory("reference-runner-staging", new FileAttribute[0]));
    }

    private ReferenceRunnerJobService(ServerFactory serverFactory, Callable<Path> stagingPathCallable) {
        this.serverFactory = serverFactory;
        this.stagingPathCallable = stagingPathCallable;
        this.unpreparedJobs = new ConcurrentHashMap<String, PreparingJob>();
        this.runningJobs = new ConcurrentHashMap<String, ReferenceRunner>();
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("reference-runner-pipeline-%s").build());
    }

    public ReferenceRunnerJobService withStagingPathSupplier(Callable<Path> supplier) {
        return new ReferenceRunnerJobService(this.serverFactory, supplier);
    }

    public void prepare(JobApi.PrepareJobRequest request, StreamObserver<JobApi.PrepareJobResponse> responseObserver) {
        try {
            LOG.trace("{} {}", (Object)JobApi.PrepareJobResponse.class.getSimpleName(), (Object)request);
            String preparationId = request.getJobName() + ThreadLocalRandom.current().nextInt();
            Path tempDir = this.stagingPathCallable.call();
            GrpcFnServer<LocalFileSystemArtifactStagerService> artifactStagingService = this.createArtifactStagingService(tempDir);
            PreparingJob previous = this.unpreparedJobs.putIfAbsent(preparationId, PreparingJob.builder().setArtifactStagingServer(artifactStagingService).setPipeline(request.getPipeline()).setOptions(request.getPipelineOptions()).setStagingLocation(tempDir).build());
            Preconditions.checkArgument(previous == null, "Unexpected existing job with preparation ID %s", (Object)preparationId);
            responseObserver.onNext(JobApi.PrepareJobResponse.newBuilder().setPreparationId(preparationId).setArtifactStagingEndpoint(artifactStagingService.getApiServiceDescriptor()).setStagingSessionToken(tempDir.toFile().getAbsolutePath()).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Could not prepare job with name {}", (Object)request.getJobName(), (Object)e);
            responseObserver.onError(Status.INTERNAL.withCause(e).asException());
        }
    }

    private GrpcFnServer<LocalFileSystemArtifactStagerService> createArtifactStagingService(Path stagingPath) throws Exception {
        LocalFileSystemArtifactStagerService service = LocalFileSystemArtifactStagerService.forRootDirectory(stagingPath.toFile());
        return GrpcFnServer.allocatePortAndCreateFor(service, this.serverFactory);
    }

    public void run(JobApi.RunJobRequest request, StreamObserver<JobApi.RunJobResponse> responseObserver) {
        try {
            LOG.trace("{} {}", (Object)JobApi.RunJobRequest.class.getSimpleName(), (Object)request);
            String preparationId = request.getPreparationId();
            PreparingJob preparingJob = (PreparingJob)this.unpreparedJobs.get(preparationId);
            if (preparingJob == null) {
                responseObserver.onError(Status.INVALID_ARGUMENT.withDescription(String.format("Unknown Preparation Id %s", preparationId)).asException());
                return;
            }
            try {
                preparingJob.close();
            }
            catch (Exception e) {
                responseObserver.onError(e);
            }
            ReferenceRunner runner = ReferenceRunner.forPipeline(preparingJob.getPipeline(), preparingJob.getOptions(), preparingJob.getStagingLocation().toFile());
            String jobId = preparingJob + Integer.toString(ThreadLocalRandom.current().nextInt());
            responseObserver.onNext(JobApi.RunJobResponse.newBuilder().setJobId(jobId).build());
            responseObserver.onCompleted();
            this.runningJobs.put(jobId, runner);
            this.executor.submit(() -> {
                runner.execute();
                return null;
            });
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
        }
        catch (Exception e) {
            responseObserver.onError(Status.INTERNAL.withCause(e).asException());
        }
    }

    public void getState(JobApi.GetJobStateRequest request, StreamObserver<JobApi.GetJobStateResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.GetJobStateRequest.class.getSimpleName(), (Object)request);
        responseObserver.onError(Status.NOT_FOUND.withDescription(String.format("Unknown Job ID %s", request.getJobId())).asException());
    }

    public void cancel(JobApi.CancelJobRequest request, StreamObserver<JobApi.CancelJobResponse> responseObserver) {
        LOG.trace("{} {}", (Object)JobApi.CancelJobRequest.class.getSimpleName(), (Object)request);
        responseObserver.onError(Status.NOT_FOUND.withDescription(String.format("Unknown Job ID %s", request.getJobId())).asException());
    }

    @Override
    public void close() throws Exception {
        for (PreparingJob preparingJob : ImmutableList.copyOf(this.unpreparedJobs.values())) {
            try {
                preparingJob.close();
            }
            catch (Exception e) {
                LOG.warn("Exception while closing preparing job {}", (Object)preparingJob);
            }
        }
    }
}

