/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.NoSuchElementException;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public final class PeekingReiterator<@UnknownKeyFor T>
implements Reiterator<T> {
    private @Nullable T nextElement;
    private @UnknownKeyFor @NonNull @Initialized boolean nextElementComputed;
    private final @UnknownKeyFor @NonNull @Initialized Reiterator<T> iterator;

    public PeekingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> iterator) {
        this.iterator = (Reiterator)Preconditions.checkNotNull(iterator);
    }

    PeekingReiterator(@UnknownKeyFor @NonNull @Initialized PeekingReiterator<T> it) {
        this.iterator = (Reiterator)Preconditions.checkNotNull((Object)((PeekingReiterator)Preconditions.checkNotNull(it)).iterator.copy());
        this.nextElement = it.nextElement;
        this.nextElementComputed = it.nextElementComputed;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
        this.computeNext();
        return this.nextElementComputed;
    }

    public T next() {
        T result = this.peek();
        this.nextElementComputed = false;
        return result;
    }

    public void remove() {
        Preconditions.checkState((!this.nextElementComputed ? 1 : 0) != 0, (Object)"After peek(), remove() is disallowed until next() is called");
        this.iterator.remove();
    }

    public @UnknownKeyFor @NonNull @Initialized PeekingReiterator<T> copy() {
        return new PeekingReiterator<T>(this);
    }

    public T peek() {
        this.computeNext();
        if (!this.nextElementComputed) {
            throw new NoSuchElementException();
        }
        return this.nextElement;
    }

    private void computeNext() {
        if (this.nextElementComputed) {
            return;
        }
        if (!this.iterator.hasNext()) {
            return;
        }
        this.nextElement = this.iterator.next();
        this.nextElementComputed = true;
    }
}

