/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.OrFinallyStateMachine;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public abstract class TriggerStateMachine
implements Serializable {
    protected final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> subTriggers;

    protected TriggerStateMachine(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> subTriggers) {
        this.subTriggers = subTriggers;
    }

    public abstract void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized PrefetchContext var1);

    public abstract void onElement(@UnknownKeyFor @NonNull @Initialized OnElementContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingPrefetchContext var1);

    public abstract void onMerge(@UnknownKeyFor @NonNull @Initialized OnMergeContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized PrefetchContext var1);

    public abstract @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract void onFire(@UnknownKeyFor @NonNull @Initialized TriggerContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public void clear(@UnknownKeyFor @NonNull @Initialized TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.subTriggers != null) {
            for (ExecutableTriggerStateMachine trigger : c.trigger().subTriggers()) {
                trigger.invokeClear(c);
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> subTriggers() {
        return this.subTriggers;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.subTriggers == null) {
            return other.subTriggers == null;
        }
        if (other.subTriggers == null) {
            return false;
        }
        if (this.subTriggers.size() != other.subTriggers.size()) {
            return false;
        }
        for (int i = 0; i < this.subTriggers.size(); ++i) {
            if (this.subTriggers.get(i).isCompatible(other.subTriggers.get(i))) continue;
            return false;
        }
        return true;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.getClass().getEnclosingClass() != null) {
            simpleName = this.getClass().getEnclosingClass().getSimpleName() + "." + simpleName;
        }
        if (this.subTriggers == null || this.subTriggers.isEmpty()) {
            return simpleName;
        }
        return simpleName + "(" + Joiner.on((String)", ").join(this.subTriggers) + ")";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TriggerStateMachine)) {
            return false;
        }
        TriggerStateMachine that = (TriggerStateMachine)obj;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.subTriggers, that.subTriggers);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getClass(), this.subTriggers);
    }

    public @UnknownKeyFor @NonNull @Initialized TriggerStateMachine orFinally(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine until) {
        return new OrFinallyStateMachine(this, until);
    }

    public static abstract class MergingPrefetchContext
    extends PrefetchContext {
        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized MergingPrefetchContext forTrigger(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine var1);

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> state();
    }

    public static abstract class PrefetchContext {
        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state();

        public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow window();

        public abstract @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine trigger();

        public abstract @UnknownKeyFor @NonNull @Initialized PrefetchContext forTrigger(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine var1);
    }

    public static abstract class OnMergeContext
    extends TriggerContext {
        public abstract void setTimer(@UnknownKeyFor @NonNull @Initialized Instant var1, @UnknownKeyFor @NonNull @Initialized TimeDomain var2);

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized OnMergeContext forTrigger(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine var1);

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> state();

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized MergingTriggerInfo trigger();
    }

    public static abstract class OnElementContext
    extends TriggerContext {
        public abstract @UnknownKeyFor @NonNull @Initialized Instant eventTimestamp();

        public abstract void setTimer(@UnknownKeyFor @NonNull @Initialized Instant var1, @UnknownKeyFor @NonNull @Initialized TimeDomain var2);

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized OnElementContext forTrigger(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine var1);
    }

    public static abstract class TriggerContext {
        public abstract @UnknownKeyFor @NonNull @Initialized TriggerInfo trigger();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state();

        public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow window();

        public abstract @UnknownKeyFor @NonNull @Initialized TriggerContext forTrigger(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine var1);

        public abstract void deleteTimer(@UnknownKeyFor @NonNull @Initialized Instant var1, @UnknownKeyFor @NonNull @Initialized TimeDomain var2);

        public abstract @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime();

        public abstract @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime();

        public abstract @Nullable @UnknownKeyFor @Initialized Instant currentEventTime();
    }

    public static interface MergingTriggerInfo
    extends TriggerInfo {
        public @UnknownKeyFor @NonNull @Initialized boolean finishedInAnyMergingWindow();

        public @UnknownKeyFor @NonNull @Initialized boolean finishedInAllMergingWindows();
    }

    public static interface TriggerInfo {
        public @UnknownKeyFor @NonNull @Initialized boolean isMerging();

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine> subTriggers();

        public @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine subTrigger(@UnknownKeyFor @NonNull @Initialized int var1);

        public @UnknownKeyFor @NonNull @Initialized boolean isFinished();

        public @UnknownKeyFor @NonNull @Initialized boolean isFinished(@UnknownKeyFor @NonNull @Initialized int var1);

        public @UnknownKeyFor @NonNull @Initialized boolean areAllSubtriggersFinished();

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine> unfinishedSubTriggers();

        public @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine firstUnfinishedSubTrigger();

        public void resetTree() throws @UnknownKeyFor @NonNull @Initialized Exception;

        public void setFinished(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public void setFinished(@UnknownKeyFor @NonNull @Initialized boolean var1, @UnknownKeyFor @NonNull @Initialized int var2);
    }
}

