/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.direct_java.runners.local.Bundle;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.AutoValue_WatermarkManager_PendingWatermarkUpdate;
import org.apache.beam.runners.direct.AutoValue_WatermarkManager_TimerKey;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.ExecutableGraph;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ComparisonChain;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Queues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.SortedMultiset;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.TreeMultiset;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class WatermarkManager<@UnknownKeyFor ExecutableT, @UnknownKeyFor CollectionT> {
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_INCREMENTAL_UPDATES = 10;
    private static final @UnknownKeyFor @NonNull @Initialized Watermark THE_END_OF_TIME = new Watermark(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return "THE_END_OF_TIME";
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            return WatermarkUpdate.NO_CHANGE;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant get() {
            return BoundedWindow.TIMESTAMP_MAX_VALUE;
        }
    };
    private static final @UnknownKeyFor @NonNull @Initialized Ordering<@UnknownKeyFor @NonNull @Initialized Instant> INSTANT_ORDERING = Ordering.natural();
    private final @UnknownKeyFor @NonNull @Initialized Clock clock;
    private final @UnknownKeyFor @NonNull @Initialized ExecutableGraph<ExecutableT, CollectionT> graph;
    private final @UnknownKeyFor @NonNull @Initialized Function<ExecutableT, @UnknownKeyFor @NonNull @Initialized String> getName;
    private final @UnknownKeyFor @NonNull @Initialized Map<ExecutableT, @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks> transformToWatermarks;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized PendingWatermarkUpdate<ExecutableT, CollectionT>> pendingUpdates;
    private final @UnknownKeyFor @NonNull @Initialized Lock refreshLock;
    @GuardedBy(value="refreshLock")
    private final @UnknownKeyFor @NonNull @Initialized Set<ExecutableT> pendingRefreshes;
    private final @UnknownKeyFor @NonNull @Initialized Map<ExecutableT, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> transformsWithAlreadyExtractedTimers = Maps.newHashMap();

    private static @UnknownKeyFor @NonNull @Initialized WatermarkUpdate updateAndTrace(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Instant oldTime, @UnknownKeyFor @NonNull @Initialized Instant currentTime) {
        WatermarkUpdate res = WatermarkUpdate.fromTimestamps(oldTime, currentTime);
        if (res.isAdvanced()) {
            WindowTracing.debug((String)"Watermark {} advanced from {} to {}", (Object[])new Object[]{name, oldTime, currentTime});
        }
        return res;
    }

    private static synchronized /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> extractFiredTimers(@UnknownKeyFor @NonNull @Initialized Instant latestTime, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> objectTimers) {
        HashMap result = new HashMap();
        HashSet emptyKeys = new HashSet();
        for (Map.Entry<StructuralKey<?>, NavigableSet<TimerInternals.TimerData>> pendingTimers : objectTimers.entrySet()) {
            NavigableSet<TimerInternals.TimerData> timers = pendingTimers.getValue();
            if (!timers.isEmpty() && ((TimerInternals.TimerData)timers.first()).getTimestamp().isBefore((ReadableInstant)latestTime)) {
                ArrayList<TimerInternals.TimerData> keyFiredTimers = new ArrayList<TimerInternals.TimerData>();
                result.put(pendingTimers.getKey(), keyFiredTimers);
                while (!timers.isEmpty() && ((TimerInternals.TimerData)timers.first()).getTimestamp().isBefore((ReadableInstant)latestTime)) {
                    keyFiredTimers.add((TimerInternals.TimerData)timers.first());
                    timers.remove(timers.first());
                }
            }
            if (!timers.isEmpty()) continue;
            emptyKeys.add(pendingTimers.getKey());
        }
        objectTimers.keySet().removeAll(emptyKeys);
        return result;
    }

    public static <ExecutableT, CollectionT> @UnknownKeyFor @NonNull @Initialized WatermarkManager<ExecutableT, @UnknownKeyFor @Nullable @Initialized ? super CollectionT> create(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized ExecutableGraph<ExecutableT, @UnknownKeyFor @Nullable @Initialized ? super CollectionT> graph, @UnknownKeyFor @NonNull @Initialized Function<ExecutableT, @UnknownKeyFor @NonNull @Initialized String> getName) {
        return new WatermarkManager<ExecutableT, CollectionT>(clock, graph, getName);
    }

    private WatermarkManager(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized ExecutableGraph<ExecutableT, CollectionT> graph, @UnknownKeyFor @NonNull @Initialized Function<ExecutableT, @UnknownKeyFor @NonNull @Initialized String> getName) {
        this.clock = clock;
        this.graph = graph;
        this.getName = getName;
        this.pendingUpdates = Queues.newArrayDeque();
        this.refreshLock = new ReentrantLock();
        this.pendingRefreshes = new HashSet<ExecutableT>();
        this.transformToWatermarks = new HashMap<ExecutableT, TransformWatermarks>();
        for (ExecutableT rootTransform : graph.getRootTransforms()) {
            this.getTransformWatermark(rootTransform);
        }
        for (ExecutableT primitiveTransform : graph.getExecutables()) {
            this.getTransformWatermark(primitiveTransform);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks getValueWatermark(CollectionT value) {
        return this.getTransformWatermark(this.graph.getProducer(value));
    }

    private @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks getTransformWatermark(ExecutableT executable) {
        String name = this.getName.apply(executable);
        TransformWatermarks wms = this.transformToWatermarks.get(executable);
        if (wms == null) {
            List<Watermark> inputCollectionWatermarks = this.getInputWatermarks(executable);
            AppliedPTransformInputWatermark inputWatermark = new AppliedPTransformInputWatermark(name + ".in", inputCollectionWatermarks, WatermarkManager.timerUpdateConsumer(this.transformsWithAlreadyExtractedTimers, executable));
            AppliedPTransformOutputWatermark outputWatermark = new AppliedPTransformOutputWatermark(name + ".out", inputWatermark);
            SynchronizedProcessingTimeInputWatermark inputProcessingWatermark = new SynchronizedProcessingTimeInputWatermark(name + ".inProcessing", this.getInputProcessingWatermarks(executable), WatermarkManager.timerUpdateConsumer(this.transformsWithAlreadyExtractedTimers, executable));
            SynchronizedProcessingTimeOutputWatermark outputProcessingWatermark = new SynchronizedProcessingTimeOutputWatermark(name + ".outProcessing", inputProcessingWatermark);
            wms = new TransformWatermarks(executable, inputWatermark, outputWatermark, inputProcessingWatermark, outputProcessingWatermark);
            this.transformToWatermarks.put(executable, wms);
        }
        return wms;
    }

    private static <ExecutableT> @UnknownKeyFor @NonNull @Initialized Consumer< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerUpdateConsumer(@UnknownKeyFor @NonNull @Initialized Map<ExecutableT, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> transformsWithAlreadyExtractedTimers, ExecutableT executable) {
        return update -> {
            String timerIdWithNs = update.stringKey();
            Map map = transformsWithAlreadyExtractedTimers;
            synchronized (map) {
                transformsWithAlreadyExtractedTimers.compute(executable, (k, v) -> {
                    if (v != null) {
                        v.remove(timerIdWithNs);
                        if (v.isEmpty()) {
                            v = null;
                        }
                    }
                    return v;
                });
            }
        };
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Watermark> getInputProcessingWatermarks(ExecutableT executable) {
        ImmutableList.Builder inputWmsBuilder = ImmutableList.builder();
        Collection<CollectionT> inputs = this.graph.getPerElementInputs(executable);
        if (inputs.isEmpty()) {
            inputWmsBuilder.add((Object)THE_END_OF_TIME);
        }
        for (CollectionT input : inputs) {
            SynchronizedProcessingTimeOutputWatermark producerOutputWatermark = this.getValueWatermark(input).synchronizedProcessingOutputWatermark;
            inputWmsBuilder.add((Object)producerOutputWatermark);
        }
        return inputWmsBuilder.build();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Watermark> getInputWatermarks(ExecutableT executable) {
        ImmutableList.Builder inputWatermarksBuilder = ImmutableList.builder();
        Collection<CollectionT> inputs = this.graph.getPerElementInputs(executable);
        if (inputs.isEmpty()) {
            inputWatermarksBuilder.add((Object)THE_END_OF_TIME);
        }
        for (CollectionT input : inputs) {
            AppliedPTransformOutputWatermark producerOutputWatermark = this.getValueWatermark(input).outputWatermark;
            inputWatermarksBuilder.add((Object)producerOutputWatermark);
        }
        return inputWatermarksBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks getWatermarks(ExecutableT executable) {
        return this.transformToWatermarks.get(executable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<ExecutableT, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, CollectionT>>> initialBundles) {
        this.refreshLock.lock();
        try {
            for (Map.Entry<ExecutableT, Iterable<Bundle<?, CollectionT>>> rootEntry : initialBundles.entrySet()) {
                TransformWatermarks rootWms = this.transformToWatermarks.get(rootEntry.getKey());
                for (Bundle<?, CollectionT> initialBundle : rootEntry.getValue()) {
                    rootWms.addPending(initialBundle);
                }
                this.pendingRefreshes.add(rootEntry.getKey());
            }
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWatermarks(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> completed, @UnknownKeyFor @NonNull @Initialized TimerUpdate timerUpdate, ExecutableT executable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> unprocessedInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT>> outputs, @UnknownKeyFor @NonNull @Initialized Instant earliestHold) {
        Queue<PendingWatermarkUpdate<ExecutableT, CollectionT>> queue = this.pendingUpdates;
        synchronized (queue) {
            this.pendingUpdates.offer(PendingWatermarkUpdate.create(executable, completed, timerUpdate, unprocessedInputs, outputs, earliestHold));
        }
        this.tryApplyPendingUpdates();
    }

    private void tryApplyPendingUpdates() {
        if (this.refreshLock.tryLock()) {
            try {
                this.applyNUpdates(10);
            }
            finally {
                this.refreshLock.unlock();
            }
        }
    }

    private void applyAllPendingUpdates() {
        this.refreshLock.lock();
        try {
            this.applyNUpdates(-1);
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="refreshLock")
    private void applyNUpdates(@UnknownKeyFor @NonNull @Initialized int numUpdates) {
        Queue<PendingWatermarkUpdate<ExecutableT, CollectionT>> queue = this.pendingUpdates;
        synchronized (queue) {
            for (int i = 0; !(this.pendingUpdates.isEmpty() || i >= numUpdates && numUpdates > 0); ++i) {
                PendingWatermarkUpdate<ExecutableT, CollectionT> pending = this.pendingUpdates.poll();
                this.applyPendingUpdate(pending);
                this.pendingRefreshes.add(pending.getExecutable());
            }
        }
    }

    private void applyPendingUpdate(@UnknownKeyFor @NonNull @Initialized PendingWatermarkUpdate<ExecutableT, CollectionT> pending) {
        ExecutableT executable = pending.getExecutable();
        Bundle<?, CollectionT> inputBundle = pending.getInputBundle();
        this.updatePending(inputBundle, pending.getTimerUpdate(), executable, pending.getUnprocessedInputs(), pending.getOutputs());
        TransformWatermarks transformWms = this.transformToWatermarks.get(executable);
        transformWms.setEventTimeHold(inputBundle == null ? null : inputBundle.getKey(), pending.getEarliestHold());
        transformWms.setSynchronizedProcessingTimeHold(inputBundle == null ? null : inputBundle.getKey(), pending.getEarliestHold());
    }

    private void updatePending(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> input, @UnknownKeyFor @NonNull @Initialized TimerUpdate timerUpdate, ExecutableT executable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> unprocessedInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT>> outputs) {
        for (Bundle<?, CollectionT> bundle : outputs) {
            for (ExecutableT consumer : this.graph.getPerElementConsumers(bundle.getPCollection())) {
                TransformWatermarks watermarks = this.transformToWatermarks.get(consumer);
                watermarks.addPending(bundle);
            }
        }
        TransformWatermarks completedTransform = this.transformToWatermarks.get(executable);
        if (unprocessedInputs != null) {
            completedTransform.addPending(unprocessedInputs);
        }
        completedTransform.updateTimers(timerUpdate);
        if (input != null) {
            completedTransform.removePending(input);
        }
    }

    public synchronized void refreshAll() {
        this.refreshLock.lock();
        try {
            this.applyAllPendingUpdates();
            Set<ExecutableT> toRefresh = this.pendingRefreshes;
            while (!toRefresh.isEmpty()) {
                toRefresh = this.refreshAllOf(toRefresh);
            }
            this.pendingRefreshes.clear();
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Set<ExecutableT> refreshAllOf(@UnknownKeyFor @NonNull @Initialized Set<ExecutableT> toRefresh) {
        HashSet<ExecutableT> newRefreshes = new HashSet<ExecutableT>();
        for (ExecutableT executable : toRefresh) {
            newRefreshes.addAll(this.refreshWatermarks(executable));
        }
        return newRefreshes;
    }

    private @UnknownKeyFor @NonNull @Initialized Set<ExecutableT> refreshWatermarks(ExecutableT toRefresh) {
        TransformWatermarks myWatermarks = this.transformToWatermarks.get(toRefresh);
        WatermarkUpdate updateResult = myWatermarks.refresh();
        if (updateResult.isAdvanced()) {
            HashSet<ExecutableT> additionalRefreshes = new HashSet<ExecutableT>();
            for (CollectionT outputPValue : this.graph.getProduced(toRefresh)) {
                additionalRefreshes.addAll(this.graph.getPerElementConsumers(outputPValue));
            }
            return additionalRefreshes;
        }
        return Collections.emptySet();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FiredTimers<ExecutableT>> extractFiredTimers() {
        return this.extractFiredTimers(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FiredTimers<ExecutableT>> extractFiredTimers(@UnknownKeyFor @NonNull @Initialized Collection<ExecutableT> ignoredExecutables) {
        ArrayList allTimers = new ArrayList();
        this.refreshLock.lock();
        try {
            for (Map.Entry<ExecutableT, TransformWatermarks> watermarksEntry : this.transformToWatermarks.entrySet()) {
                ExecutableT transform = watermarksEntry.getKey();
                if (ignoredExecutables.contains(transform)) continue;
                Map<ExecutableT, Set<String>> map = this.transformsWithAlreadyExtractedTimers;
                synchronized (map) {
                    TransformWatermarks watermarks;
                    Collection firedTimers;
                    if (!this.transformsWithAlreadyExtractedTimers.containsKey(transform) && !(firedTimers = (watermarks = watermarksEntry.getValue()).extractFiredTimers()).isEmpty()) {
                        List newTimers = firedTimers.stream().flatMap(f -> f.getTimers().stream()).collect(Collectors.toList());
                        this.transformsWithAlreadyExtractedTimers.compute(transform, (k, v) -> {
                            if (v == null) {
                                v = new HashSet();
                            }
                            HashSet toUpdate = v;
                            newTimers.forEach(td -> toUpdate.add(td.stringKey()));
                            return v;
                        });
                        allTimers.addAll(firedTimers);
                    }
                }
            }
            ArrayList arrayList = allTimers;
            return arrayList;
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    @AutoValue
    static abstract class PendingWatermarkUpdate<@UnknownKeyFor ExecutableT, @UnknownKeyFor CollectionT> {
        PendingWatermarkUpdate() {
        }

        abstract ExecutableT getExecutable();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> getInputBundle();

        abstract @UnknownKeyFor @NonNull @Initialized TimerUpdate getTimerUpdate();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> getUnprocessedInputs();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT>> getOutputs();

        abstract @UnknownKeyFor @NonNull @Initialized Instant getEarliestHold();

        public static <ExecutableT, CollectionT> @UnknownKeyFor @NonNull @Initialized PendingWatermarkUpdate<ExecutableT, CollectionT> create(ExecutableT executable, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> inputBundle, @UnknownKeyFor @NonNull @Initialized TimerUpdate timerUpdate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT> unprocessedInputs, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends CollectionT>> outputs, @UnknownKeyFor @NonNull @Initialized Instant earliestHold) {
            return new AutoValue_WatermarkManager_PendingWatermarkUpdate<ExecutableT, CollectionT>(executable, inputBundle, timerUpdate, unprocessedInputs, outputs, earliestHold);
        }
    }

    private static class BundleByElementTimestampComparator
    extends Ordering<Bundle<?, ?>>
    implements Serializable {
        private BundleByElementTimestampComparator() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized int compare(@Nonnull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> o1, @Nonnull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> o2) {
            return ComparisonChain.start().compare((Comparable)o1.getMinimumTimestamp(), (Comparable)o2.getMinimumTimestamp()).result();
        }
    }

    public static class FiredTimers<@UnknownKeyFor ExecutableT> {
        private final ExecutableT executable;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key;
        private final @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers;

        private FiredTimers(ExecutableT executable, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers) {
            this.executable = executable;
            this.key = key;
            this.timers = timers;
        }

        public ExecutableT getExecutable() {
            return this.executable;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getKey() {
            return this.key;
        }

        public @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getTimers() {
            return this.timers;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(FiredTimers.class).add("key", this.key).add("timers", this.timers).toString();
        }
    }

    public static class TimerUpdate {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key;
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> setTimers;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> deletedTimers;

        public static @UnknownKeyFor @NonNull @Initialized TimerUpdate empty() {
            return new TimerUpdate(null, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        }

        public static @UnknownKeyFor @NonNull @Initialized TimerUpdateBuilder builder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
            return new TimerUpdateBuilder(key);
        }

        private TimerUpdate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> setTimers, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> deletedTimers) {
            this.key = key;
            this.completedTimers = completedTimers;
            this.setTimers = setTimers;
            this.deletedTimers = deletedTimers;
        }

        @VisibleForTesting
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getKey() {
            return this.key;
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getCompletedTimers() {
            return this.completedTimers;
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getSetTimers() {
            return this.setTimers.values();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getDeletedTimers() {
            return this.deletedTimers.values();
        }

        @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return Iterables.isEmpty(this.completedTimers) && this.setTimers.isEmpty() && this.deletedTimers.isEmpty();
        }

        public @UnknownKeyFor @NonNull @Initialized TimerUpdate withCompletedTimers(@UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers) {
            ArrayList<TimerInternals.TimerData> timersToComplete = new ArrayList<TimerInternals.TimerData>();
            LinkedHashMap newSetTimers = Maps.newLinkedHashMap();
            newSetTimers.putAll(this.setTimers);
            for (TimerInternals.TimerData td : completedTimers) {
                timersToComplete.add(td);
            }
            return new TimerUpdate(this.key, timersToComplete, newSetTimers, this.deletedTimers);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.key, this.completedTimers, this.setTimers, this.deletedTimers);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null || !(other instanceof TimerUpdate)) {
                return false;
            }
            TimerUpdate that = (TimerUpdate)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.completedTimers, that.completedTimers) && Objects.equals(this.setTimers, that.setTimers) && Objects.equals(this.deletedTimers, that.deletedTimers);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("setTimers", this.setTimers).add("completedTimers", this.completedTimers).add("deletedTimers", this.deletedTimers).toString();
        }

        public static final class TimerUpdateBuilder {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key;
            private final @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers;
            private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey,  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> setTimers;
            private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TimerKey,  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> deletedTimers;

            private TimerUpdateBuilder(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
                this.key = key;
                this.completedTimers = Sets.newLinkedHashSet();
                this.setTimers = Maps.newLinkedHashMap();
                this.deletedTimers = Maps.newLinkedHashMap();
            }

            public @UnknownKeyFor @NonNull @Initialized TimerUpdateBuilder withCompletedTimers(@UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers) {
                Iterables.addAll(this.completedTimers, completedTimers);
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized TimerUpdateBuilder setTimer( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData setTimer) {
                Preconditions.checkArgument((boolean)setTimer.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), (String)"Got a timer for after the end of time (%s), got %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)setTimer.getTimestamp());
                this.deletedTimers.remove(TimerKey.of(setTimer));
                this.setTimers.put(TimerKey.of(setTimer), setTimer);
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized TimerUpdateBuilder deletedTimer( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData deletedTimer) {
                TimerKey key = TimerKey.of(deletedTimer);
                this.deletedTimers.put(key, deletedTimer);
                this.setTimers.remove(key);
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized TimerUpdate build() {
                return new TimerUpdate(this.key, (Iterable)ImmutableList.copyOf(this.completedTimers), (Map)ImmutableMap.copyOf(this.setTimers), (Map)ImmutableMap.copyOf(this.deletedTimers));
            }
        }
    }

    @AutoValue
    public static abstract class TimerKey {
        abstract @UnknownKeyFor @NonNull @Initialized TimeDomain getDomain();

        abstract @UnknownKeyFor @NonNull @Initialized String getId();

        abstract @UnknownKeyFor @NonNull @Initialized String getFamily();

        abstract @UnknownKeyFor @NonNull @Initialized Object getNamespace();

        static @UnknownKeyFor @NonNull @Initialized TimerKey of( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
            return new AutoValue_WatermarkManager_TimerKey(timerData.getDomain(), timerData.getTimerId(), timerData.getTimerFamilyId(), timerData.getNamespace().getCacheKey());
        }
    }

    public class TransformWatermarks {
        private final ExecutableT executable;
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransformInputWatermark inputWatermark;
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransformOutputWatermark outputWatermark;
        private final @UnknownKeyFor @NonNull @Initialized SynchronizedProcessingTimeInputWatermark synchronizedProcessingInputWatermark;
        private final @UnknownKeyFor @NonNull @Initialized SynchronizedProcessingTimeOutputWatermark synchronizedProcessingOutputWatermark;
        private @UnknownKeyFor @NonNull @Initialized Instant latestSynchronizedInputWm;
        private @UnknownKeyFor @NonNull @Initialized Instant latestSynchronizedOutputWm;

        private TransformWatermarks(@UnknownKeyFor @NonNull @Initialized ExecutableT executable, @UnknownKeyFor @NonNull @Initialized AppliedPTransformInputWatermark inputWatermark, @UnknownKeyFor @NonNull @Initialized AppliedPTransformOutputWatermark outputWatermark, @UnknownKeyFor @NonNull @Initialized SynchronizedProcessingTimeInputWatermark inputSynchProcessingWatermark, SynchronizedProcessingTimeOutputWatermark outputSynchProcessingWatermark) {
            this.executable = executable;
            this.inputWatermark = inputWatermark;
            this.outputWatermark = outputWatermark;
            this.synchronizedProcessingInputWatermark = inputSynchProcessingWatermark;
            this.synchronizedProcessingOutputWatermark = outputSynchProcessingWatermark;
            this.latestSynchronizedInputWm = BoundedWindow.TIMESTAMP_MIN_VALUE;
            this.latestSynchronizedOutputWm = BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getInputWatermark() {
            return (Instant)Preconditions.checkNotNull((Object)this.inputWatermark.get());
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getOutputWatermark() {
            return this.outputWatermark.get();
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Instant getSynchronizedProcessingInputTime() {
            this.latestSynchronizedInputWm = (Instant)INSTANT_ORDERING.max((Object)this.latestSynchronizedInputWm, (Object)((Instant)INSTANT_ORDERING.min((Object)WatermarkManager.this.clock.now(), (Object)this.synchronizedProcessingInputWatermark.get())));
            return this.latestSynchronizedInputWm;
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Instant getSynchronizedProcessingOutputTime() {
            this.latestSynchronizedOutputWm = (Instant)INSTANT_ORDERING.max((Object)this.latestSynchronizedOutputWm, (Object)((Instant)INSTANT_ORDERING.min((Object)WatermarkManager.this.clock.now(), (Object)this.synchronizedProcessingOutputWatermark.get())));
            return this.latestSynchronizedOutputWm;
        }

        private @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            this.inputWatermark.refresh();
            this.synchronizedProcessingInputWatermark.refresh();
            WatermarkUpdate eventOutputUpdate = this.outputWatermark.refresh();
            WatermarkUpdate syncOutputUpdate = this.synchronizedProcessingOutputWatermark.refresh();
            return eventOutputUpdate.union(syncOutputUpdate);
        }

        private void setEventTimeHold(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant newHold) {
            this.outputWatermark.updateHold(key, newHold);
        }

        private void setSynchronizedProcessingTimeHold(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant newHold) {
            this.synchronizedProcessingOutputWatermark.updateHold(key, newHold);
        }

        private void removePending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle) {
            this.inputWatermark.removePending(bundle);
            this.synchronizedProcessingInputWatermark.removePending(bundle);
        }

        private void addPending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle) {
            this.inputWatermark.addPending(bundle);
            this.synchronizedProcessingInputWatermark.addPending(bundle);
        }

        private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FiredTimers<ExecutableT>> extractFiredTimers() {
            Map<StructuralKey<?>, List<TimerInternals.TimerData>> eventTimeTimers = this.inputWatermark.extractFiredEventTimeTimers();
            Map processingTimers = this.synchronizedProcessingInputWatermark.extractFiredDomainTimers(TimeDomain.PROCESSING_TIME, WatermarkManager.this.clock.now());
            Map synchronizedTimers = this.synchronizedProcessingInputWatermark.extractFiredDomainTimers(TimeDomain.SYNCHRONIZED_PROCESSING_TIME, this.getSynchronizedProcessingInputTime());
            Map<StructuralKey<?>, List<TimerInternals.TimerData>> timersPerKey = this.groupFiredTimers(eventTimeTimers, processingTimers, synchronizedTimers);
            ArrayList keyFiredTimers = new ArrayList(timersPerKey.size());
            for (Map.Entry<StructuralKey<?>, List<TimerInternals.TimerData>> firedTimers : timersPerKey.entrySet()) {
                keyFiredTimers.add(new FiredTimers(this.executable, firedTimers.getKey(), firedTimers.getValue()));
            }
            return keyFiredTimers;
        }

        @SafeVarargs
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> groupFiredTimers(Map<StructuralKey<?>, List<TimerInternals.TimerData>> ... timersToGroup) {
            HashMap groupedTimers = new HashMap();
            for (Map<StructuralKey<?>, List<TimerInternals.TimerData>> subGroup : timersToGroup) {
                for (Map.Entry<StructuralKey<?>, List<TimerInternals.TimerData>> newTimers : subGroup.entrySet()) {
                    List grouped = groupedTimers.computeIfAbsent(newTimers.getKey(), k -> new ArrayList());
                    grouped.addAll((Collection)newTimers.getValue());
                }
            }
            return groupedTimers;
        }

        private void updateTimers(@UnknownKeyFor @NonNull @Initialized TimerUpdate update) {
            this.inputWatermark.updateTimers(update);
            this.synchronizedProcessingInputWatermark.updateTimers(update);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(TransformWatermarks.class).add("inputWatermark", (Object)this.inputWatermark).add("outputWatermark", (Object)this.outputWatermark).add("inputProcessingTime", (Object)this.synchronizedProcessingInputWatermark).add("outputProcessingTime", (Object)this.synchronizedProcessingOutputWatermark).toString();
        }
    }

    private static class PerKeyHolds {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized KeyedHold> keyedHolds = new HashMap<Object, KeyedHold>();
        private final @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized KeyedHold> allHolds = new TreeSet<KeyedHold>();

        private PerKeyHolds() {
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getMinHold() {
            return this.allHolds.isEmpty() ? THE_END_OF_TIME.get() : ((KeyedHold)this.allHolds.first()).getTimestamp();
        }

        public void updateHold(@Nullable @UnknownKeyFor @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant newHold) {
            this.removeHold(key);
            KeyedHold newKeyedHold = KeyedHold.of(key, newHold);
            this.keyedHolds.put(key, newKeyedHold);
            this.allHolds.add(newKeyedHold);
        }

        public void removeHold(@UnknownKeyFor @NonNull @Initialized Object key) {
            KeyedHold oldHold = this.keyedHolds.remove(key);
            if (oldHold != null) {
                this.allHolds.remove(oldHold);
            }
        }
    }

    private static final class KeyedHold
    implements Comparable<KeyedHold> {
        private static final @UnknownKeyFor @NonNull @Initialized Ordering<@UnknownKeyFor @NonNull @Initialized Object> KEY_ORDERING = Ordering.arbitrary().nullsLast();
        private final @UnknownKeyFor @NonNull @Initialized Object key;
        private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

        public static @UnknownKeyFor @NonNull @Initialized KeyedHold of(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            return new KeyedHold(key, (Instant)MoreObjects.firstNonNull((Object)timestamp, (Object)THE_END_OF_TIME.get()));
        }

        private KeyedHold(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            this.key = key;
            this.timestamp = timestamp;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized KeyedHold that) {
            return ComparisonChain.start().compare((Comparable)this.timestamp, (Comparable)that.timestamp).compare(this.key, that.key, KEY_ORDERING).result();
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.timestamp, this.key);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null || !(other instanceof KeyedHold)) {
                return false;
            }
            KeyedHold that = (KeyedHold)other;
            return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.key, that.key);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.timestamp;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(KeyedHold.class).add("key", this.key).add("hold", (Object)this.timestamp).toString();
        }
    }

    private static class SynchronizedProcessingTimeOutputWatermark
    implements Watermark {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized SynchronizedProcessingTimeInputWatermark inputWm;
        private final @UnknownKeyFor @NonNull @Initialized PerKeyHolds holds;
        private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Instant> latestRefresh;

        public SynchronizedProcessingTimeOutputWatermark(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SynchronizedProcessingTimeInputWatermark inputWm) {
            this.name = name;
            this.inputWm = inputWm;
            this.holds = new PerKeyHolds();
            this.latestRefresh = new AtomicReference<Instant>(BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        public synchronized void updateHold(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant newHold) {
            if (newHold == null) {
                this.holds.removeHold(key);
            } else {
                this.holds.updateHold(key, newHold);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant get() {
            return this.latestRefresh.get();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            Instant oldRefresh = this.latestRefresh.get();
            Instant newTimestamp = (Instant)INSTANT_ORDERING.min((Object)this.inputWm.get(), (Object)this.holds.getMinHold(), (Object)this.inputWm.getEarliestTimerTimestamp(), (Object[])new Instant[0]);
            this.latestRefresh.set(newTimestamp);
            return WatermarkManager.updateAndTrace(this.getName(), oldRefresh, newTimestamp);
        }

        @SideEffectFree
        public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(SynchronizedProcessingTimeOutputWatermark.class).add("holds", (Object)this.holds).add("latestRefresh", this.latestRefresh).toString();
        }
    }

    private static class SynchronizedProcessingTimeInputWatermark
    implements Watermark {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Watermark> inputWms;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pendingBundles;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> processingTimers;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> synchronizedProcessingTimers;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String,  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> existingTimers;
        private final @UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> pendingTimers;
        private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Instant> earliestHold;
        private final @UnknownKeyFor @NonNull @Initialized Consumer< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerUpdateNotification;

        public SynchronizedProcessingTimeInputWatermark(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Watermark> inputWms, @UnknownKeyFor @NonNull @Initialized Consumer< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerUpdateNotification) {
            this.name = name;
            this.inputWms = inputWms;
            this.pendingBundles = new HashSet();
            this.processingTimers = new HashMap();
            this.synchronizedProcessingTimers = new HashMap();
            this.existingTimers = new HashMap();
            this.pendingTimers = new TreeSet<TimerInternals.TimerData>();
            Instant initialHold = BoundedWindow.TIMESTAMP_MAX_VALUE;
            for (Watermark watermark : inputWms) {
                initialHold = (Instant)INSTANT_ORDERING.min((Object)initialHold, (Object)watermark.get());
            }
            this.earliestHold = new AtomicReference<Instant>(initialHold);
            this.timerUpdateNotification = timerUpdateNotification;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant get() {
            return this.earliestHold.get();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            Instant oldHold = this.earliestHold.get();
            Instant minTime = THE_END_OF_TIME.get();
            for (Watermark watermark : this.inputWms) {
                minTime = (Instant)INSTANT_ORDERING.min((Object)minTime, (Object)watermark.get());
            }
            for (Bundle bundle : this.pendingBundles) {
                minTime = (Instant)INSTANT_ORDERING.min((Object)minTime, (Object)bundle.getSynchronizedProcessingOutputWatermark());
            }
            this.earliestHold.set(minTime);
            return WatermarkManager.updateAndTrace(this.getName(), oldHold, minTime);
        }

        public synchronized void addPending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle) {
            this.pendingBundles.add(bundle);
        }

        public synchronized void removePending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> bundle) {
            this.pendingBundles.remove(bundle);
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Instant getEarliestTimerTimestamp() {
            Instant earliest = THE_END_OF_TIME.get();
            for (NavigableSet<TimerInternals.TimerData> timers : this.processingTimers.values()) {
                if (timers.isEmpty()) continue;
                earliest = (Instant)INSTANT_ORDERING.min((Object)this.getMinimumOutputTimestamp(timers), (Object)earliest);
            }
            for (NavigableSet<TimerInternals.TimerData> timers : this.synchronizedProcessingTimers.values()) {
                if (timers.isEmpty()) continue;
                earliest = (Instant)INSTANT_ORDERING.min((Object)this.getMinimumOutputTimestamp(timers), (Object)earliest);
            }
            if (!this.pendingTimers.isEmpty()) {
                earliest = (Instant)INSTANT_ORDERING.min((Object)this.getMinimumOutputTimestamp(this.pendingTimers), (Object)earliest);
            }
            return earliest;
        }

        private @UnknownKeyFor @NonNull @Initialized Instant getMinimumOutputTimestamp(@UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers) {
            Instant minimumOutputTimestamp = ((TimerInternals.TimerData)timers.first()).getOutputTimestamp();
            for (TimerInternals.TimerData timerData : timers) {
                minimumOutputTimestamp = (Instant)INSTANT_ORDERING.min((Object)timerData.getOutputTimestamp(), (Object)minimumOutputTimestamp);
            }
            return minimumOutputTimestamp;
        }

        private synchronized void updateTimers(@UnknownKeyFor @NonNull @Initialized TimerUpdate update) {
            NavigableSet<TimerInternals.TimerData> timerQueue;
            Map existingTimersForKey = this.existingTimers.computeIfAbsent(update.key, k -> Maps.newHashMap());
            HashSet newSetTimers = Sets.newHashSet();
            for (TimerInternals.TimerData addedTimer : update.setTimers.values()) {
                timerQueue = this.processQueueForDomain(update.key, addedTimer.getDomain());
                if (timerQueue == null) continue;
                newSetTimers.add(addedTimer.stringKey());
                 @Nullable TimerInternals.TimerData existingTimer = (TimerInternals.TimerData)existingTimersForKey.get(addedTimer.stringKey());
                if (existingTimer == null) {
                    timerQueue.add(addedTimer);
                } else if (!existingTimer.equals(addedTimer)) {
                    timerQueue.remove(existingTimer);
                    timerQueue.add(addedTimer);
                }
                existingTimersForKey.put(addedTimer.stringKey(), addedTimer);
            }
            for (TimerInternals.TimerData deletedTimer : update.deletedTimers.values()) {
                String timerKey;
                TimerInternals.TimerData existingTimer;
                timerQueue = this.processQueueForDomain(update.key, deletedTimer.getDomain());
                if (timerQueue == null || (existingTimer = (TimerInternals.TimerData)existingTimersForKey.get(timerKey = deletedTimer.stringKey())) == null) continue;
                this.pendingTimers.remove(existingTimer);
                timerQueue.remove(existingTimer);
                existingTimersForKey.remove(timerKey);
            }
            for (TimerInternals.TimerData completedTimer : update.completedTimers) {
                String timerKey = completedTimer.stringKey();
                if (newSetTimers.contains(timerKey)) continue;
                this.pendingTimers.remove(completedTimer);
                existingTimersForKey.remove(timerKey);
            }
            Iterables.concat(update.getCompletedTimers(), update.getDeletedTimers(), update.getSetTimers()).forEach(this.timerUpdateNotification);
        }

        private synchronized /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> extractFiredDomainTimers(@UnknownKeyFor @NonNull @Initialized TimeDomain domain, @UnknownKeyFor @NonNull @Initialized Instant firingTime) {
            Map firedTimers;
            switch (domain) {
                case PROCESSING_TIME: {
                    firedTimers = WatermarkManager.extractFiredTimers(firingTime, this.processingTimers);
                    break;
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    firedTimers = WatermarkManager.extractFiredTimers((Instant)INSTANT_ORDERING.min((Object)firingTime, (Object)this.earliestHold.get()), this.synchronizedProcessingTimers);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Called getFiredTimers on a Synchronized Processing Time watermark and gave a non-processing time domain " + domain);
                }
            }
            for (Map.Entry firedTimer : firedTimers.entrySet()) {
                this.pendingTimers.addAll((Collection)firedTimer.getValue());
            }
            return firedTimers;
        }

        private @Nullable @UnknownKeyFor @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> processQueueForDomain(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            switch (timeDomain) {
                case PROCESSING_TIME: {
                    return this.processingTimers.computeIfAbsent(key, k -> new TreeSet());
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return this.synchronizedProcessingTimers.computeIfAbsent(key, k -> new TreeSet());
                }
            }
            return null;
        }

        @SideEffectFree
        public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(SynchronizedProcessingTimeInputWatermark.class).add("earliestHold", this.earliestHold).toString();
        }
    }

    private static class AppliedPTransformOutputWatermark
    implements Watermark {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransformInputWatermark inputWatermark;
        private final @UnknownKeyFor @NonNull @Initialized PerKeyHolds holds;
        private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Instant> currentWatermark;

        public AppliedPTransformOutputWatermark(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized AppliedPTransformInputWatermark inputWatermark) {
            this.name = name;
            this.inputWatermark = inputWatermark;
            this.holds = new PerKeyHolds();
            this.currentWatermark = new AtomicReference<Instant>(BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        public synchronized void updateHold(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant newHold) {
            if (newHold == null) {
                this.holds.removeHold(key);
            } else {
                this.holds.updateHold(key, newHold);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant get() {
            return this.currentWatermark.get();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            Instant oldWatermark = this.currentWatermark.get();
            Instant newWatermark = (Instant)INSTANT_ORDERING.min((Object)this.inputWatermark.get(), (Object)this.holds.getMinHold(), (Object)this.inputWatermark.getEarliestTimerTimestamp(), (Object[])new Instant[0]);
            newWatermark = (Instant)INSTANT_ORDERING.max((Object)oldWatermark, (Object)newWatermark);
            this.currentWatermark.set(newWatermark);
            return WatermarkManager.updateAndTrace(this.getName(), oldWatermark, newWatermark);
        }

        @SideEffectFree
        public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(AppliedPTransformOutputWatermark.class).add("holds", (Object)this.holds).add("currentWatermark", this.currentWatermark).toString();
        }
    }

    @VisibleForTesting
    static class AppliedPTransformInputWatermark
    implements Watermark {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Watermark> inputWatermarks;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SortedMultiset<@UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pendingElements;
        private final @UnknownKeyFor @NonNull @Initialized SortedMultiset< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> pendingTimers;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String,  @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> existingTimers;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized NavigableSet< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> objectTimers;
        private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Instant> currentWatermark;
        private final @UnknownKeyFor @NonNull @Initialized Consumer< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerUpdateNotification;

        public AppliedPTransformInputWatermark(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Watermark> inputWatermarks, @UnknownKeyFor @NonNull @Initialized Consumer< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerUpdateNotification) {
            this.name = name;
            this.inputWatermarks = inputWatermarks;
            Ordering pendingBundleComparator = new BundleByElementTimestampComparator().compound((Comparator)Ordering.arbitrary());
            this.pendingElements = TreeMultiset.create((Comparator)pendingBundleComparator);
            this.pendingTimers = TreeMultiset.create();
            this.objectTimers = new HashMap();
            this.existingTimers = new HashMap();
            this.currentWatermark = new AtomicReference<Instant>(BoundedWindow.TIMESTAMP_MIN_VALUE);
            this.timerUpdateNotification = timerUpdateNotification;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant get() {
            return this.currentWatermark.get();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh() {
            Instant oldWatermark = this.currentWatermark.get();
            Instant minInputWatermark = BoundedWindow.TIMESTAMP_MAX_VALUE;
            for (Watermark watermark : this.inputWatermarks) {
                minInputWatermark = (Instant)INSTANT_ORDERING.min((Object)minInputWatermark, (Object)watermark.get());
            }
            if (!this.pendingElements.isEmpty()) {
                minInputWatermark = (Instant)INSTANT_ORDERING.min((Object)minInputWatermark, (Object)((Bundle)this.pendingElements.firstEntry().getElement()).getMinimumTimestamp());
            }
            Instant newWatermark = (Instant)INSTANT_ORDERING.max((Object)oldWatermark, (Object)minInputWatermark);
            this.currentWatermark.set(newWatermark);
            return WatermarkManager.updateAndTrace(this.getName(), oldWatermark, newWatermark);
        }

        private synchronized void addPending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> newPending) {
            this.pendingElements.add(newPending);
        }

        private synchronized void removePending(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Bundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> completed) {
            this.pendingElements.remove(completed);
        }

        @VisibleForTesting
        synchronized @UnknownKeyFor @NonNull @Initialized Instant getEarliestTimerTimestamp() {
            if (this.pendingTimers.isEmpty()) {
                return BoundedWindow.TIMESTAMP_MAX_VALUE;
            }
            return this.getMinimumOutputTimestamp(this.pendingTimers);
        }

        private @UnknownKeyFor @NonNull @Initialized Instant getMinimumOutputTimestamp(@UnknownKeyFor @NonNull @Initialized SortedMultiset< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timers) {
            Instant minimumOutputTimestamp = ((TimerInternals.TimerData)timers.firstEntry().getElement()).getOutputTimestamp();
            for (TimerInternals.TimerData timerData : timers) {
                minimumOutputTimestamp = (Instant)INSTANT_ORDERING.min((Object)timerData.getOutputTimestamp(), (Object)minimumOutputTimestamp);
            }
            return minimumOutputTimestamp;
        }

        @VisibleForTesting
        synchronized void updateTimers(@UnknownKeyFor @NonNull @Initialized TimerUpdate update) {
            TimerInternals.TimerData existingTimer;
            NavigableSet keyTimers = this.objectTimers.computeIfAbsent(update.key, k -> new TreeSet());
            Map existingTimersForKey = this.existingTimers.computeIfAbsent(update.key, k -> Maps.newHashMap());
            HashSet newSetTimers = Sets.newHashSet();
            for (TimerInternals.TimerData timerData : update.getSetTimers()) {
                if (!TimeDomain.EVENT_TIME.equals((Object)timerData.getDomain())) continue;
                newSetTimers.add(timerData.stringKey());
                existingTimer = (TimerInternals.TimerData)existingTimersForKey.get(timerData.stringKey());
                if (existingTimer == null) {
                    this.pendingTimers.add((Object)timerData);
                    keyTimers.add(timerData);
                } else {
                    this.pendingTimers.remove((Object)existingTimer);
                    keyTimers.remove(existingTimer);
                    this.pendingTimers.add((Object)timerData);
                    keyTimers.add(timerData);
                }
                existingTimersForKey.put(timerData.stringKey(), timerData);
            }
            for (TimerInternals.TimerData timerData : update.getDeletedTimers()) {
                if (!TimeDomain.EVENT_TIME.equals((Object)timerData.getDomain()) || (existingTimer = (TimerInternals.TimerData)existingTimersForKey.get(timerData.stringKey())) == null) continue;
                this.pendingTimers.remove((Object)existingTimer);
                keyTimers.remove(existingTimer);
                existingTimersForKey.remove(existingTimer.stringKey());
            }
            for (TimerInternals.TimerData timerData : update.getCompletedTimers()) {
                if (!TimeDomain.EVENT_TIME.equals((Object)timerData.getDomain()) || newSetTimers.contains(timerData.stringKey())) continue;
                keyTimers.remove(timerData);
                this.pendingTimers.remove((Object)timerData);
                existingTimersForKey.remove(timerData.stringKey());
            }
            if (!update.isEmpty()) {
                Iterables.concat(update.getCompletedTimers(), update.getDeletedTimers(), update.getSetTimers()).forEach(this.timerUpdateNotification);
            }
        }

        @VisibleForTesting
        synchronized /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> extractFiredEventTimeTimers() {
            return WatermarkManager.extractFiredTimers(this.currentWatermark.get(), this.objectTimers);
        }

        @SideEffectFree
        public synchronized @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(AppliedPTransformInputWatermark.class).add("pendingElements", this.pendingElements).add("currentWatermark", this.currentWatermark).toString();
        }
    }

    private static enum WatermarkUpdate {
        ADVANCED(true),
        NO_CHANGE(false);

        private final @UnknownKeyFor @NonNull @Initialized boolean advanced;

        private WatermarkUpdate(boolean advanced) {
            this.advanced = advanced;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isAdvanced() {
            return this.advanced;
        }

        public @UnknownKeyFor @NonNull @Initialized WatermarkUpdate union(@UnknownKeyFor @NonNull @Initialized WatermarkUpdate that) {
            if (this.advanced) {
                return this;
            }
            return that;
        }

        public static @UnknownKeyFor @NonNull @Initialized WatermarkUpdate fromTimestamps(@UnknownKeyFor @NonNull @Initialized Instant oldTime, @UnknownKeyFor @NonNull @Initialized Instant currentTime) {
            if (currentTime.isAfter((ReadableInstant)oldTime)) {
                return ADVANCED;
            }
            return NO_CHANGE;
        }
    }

    @VisibleForTesting
    static interface Watermark {
        public @UnknownKeyFor @NonNull @Initialized String getName();

        public @UnknownKeyFor @NonNull @Initialized Instant get();

        public @UnknownKeyFor @NonNull @Initialized WatermarkUpdate refresh();
    }
}

