/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.AutoValue_GaugeData;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@AutoValue
public abstract class GaugeData
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized long value();

    public abstract @UnknownKeyFor @NonNull @Initialized Instant timestamp();

    public static @UnknownKeyFor @NonNull @Initialized GaugeData create(@UnknownKeyFor @NonNull @Initialized long value) {
        return GaugeData.create(value, Instant.now());
    }

    public static @UnknownKeyFor @NonNull @Initialized GaugeData create(@UnknownKeyFor @NonNull @Initialized long value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return new AutoValue_GaugeData(value, timestamp);
    }

    public static @UnknownKeyFor @NonNull @Initialized GaugeData empty() {
        return EmptyGaugeData.INSTANCE;
    }

    public @UnknownKeyFor @NonNull @Initialized GaugeData combine(@UnknownKeyFor @NonNull @Initialized GaugeData other) {
        if (this.timestamp().isAfter((ReadableInstant)other.timestamp())) {
            return this;
        }
        return other;
    }

    public @UnknownKeyFor @NonNull @Initialized GaugeResult extractResult() {
        return GaugeResult.create((long)this.value(), (Instant)this.timestamp());
    }

    public static class EmptyGaugeData
    extends GaugeData {
        private static final @UnknownKeyFor @NonNull @Initialized EmptyGaugeData INSTANCE = new EmptyGaugeData();
        private static final @UnknownKeyFor @NonNull @Initialized Instant EPOCH = GlobalWindow.TIMESTAMP_MIN_VALUE;

        private EmptyGaugeData() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long value() {
            return -1L;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
            return EPOCH;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GaugeResult extractResult() {
            return GaugeResult.empty();
        }
    }
}

