/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;

public class GroupIntoBatchesTranslation {
    private static <K, V> RunnerApi.GroupIntoBatchesPayload getPayloadFromParameters(GroupIntoBatches.BatchingParams params) {
        return RunnerApi.GroupIntoBatchesPayload.newBuilder().setBatchSize(params.getBatchSize()).setBatchSizeBytes(params.getBatchSizeBytes()).setMaxBufferingDurationMillis(params.getMaxBufferingDuration().getStandardSeconds() * 1000L).build();
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(GroupIntoBatches.class, (Object)new GroupIntoBatchesTranslator()).put(GroupIntoBatches.WithShardedKey.class, (Object)new ShardedGroupIntoBatchesTranslator()).build();
        }
    }

    static class ShardedGroupIntoBatchesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<GroupIntoBatches.WithShardedKey> {
        ShardedGroupIntoBatchesTranslator() {
        }

        @Override
        public String getUrn() {
            return "beam:transform:group_into_batches_with_sharded_key:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, GroupIntoBatches.WithShardedKey> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((GroupIntoBatches.WithShardedKey)transform.getTransform())).setPayload(GroupIntoBatchesTranslation.getPayloadFromParameters(((GroupIntoBatches.WithShardedKey)transform.getTransform()).getBatchingParams()).toByteString()).build();
        }
    }

    static class GroupIntoBatchesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<GroupIntoBatches<?, ?>> {
        GroupIntoBatchesTranslator() {
        }

        @Override
        public String getUrn() {
            return "beam:transform:group_into_batches:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, GroupIntoBatches<?, ?>> transform, SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((GroupIntoBatches)transform.getTransform())).setPayload(GroupIntoBatchesTranslation.getPayloadFromParameters(((GroupIntoBatches)transform.getTransform()).getBatchingParams()).toByteString()).build();
        }
    }
}

