/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.DefaultExpansionServiceClientFactory;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ExpansionServiceClientFactory;
import org.apache.beam.repackaged.direct_java.runners.core.construction.External;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ExternalTranslationOptions;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transformservice.launcher.TransformServiceLauncher;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolStringList;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformUpgrader
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TransformUpgrader.class);
    private static final @UnknownKeyFor @NonNull @Initialized String UPGRADE_NAMESPACE = "transform:upgrade:";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String UPGRADE_KEY = "upgraded_to_version";
    private @UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory;

    private TransformUpgrader() {
        this.clientFactory = DefaultExpansionServiceClientFactory.create(endPoint -> ManagedChannelBuilder.forTarget((String)endPoint.getUrl()).usePlaintext().build());
    }

    private TransformUpgrader(@UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public static @UnknownKeyFor @NonNull @Initialized TransformUpgrader of() {
        return new TransformUpgrader();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized TransformUpgrader of(@UnknownKeyFor @NonNull @Initialized ExpansionServiceClientFactory clientFactory) {
        return new TransformUpgrader(clientFactory);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline upgradeTransformsViaTransformService(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> urnsToOverride, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        String serviceAddress;
        List transformsToOverride = pipeline.getComponents().getTransformsMap().entrySet().stream().filter(entry -> {
            String urn = ((RunnerApi.PTransform)entry.getValue()).getSpec().getUrn();
            return urn != null && urnsToOverride.contains(urn);
        }).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (!urnsToOverride.isEmpty() && transformsToOverride.isEmpty()) {
            throw new IllegalArgumentException("A list of URNs for overriding transforms was provided but the pipeline did not contain any matching transforms. Either make sure to include at least one matching transform in the pipeline or avoid setting the 'transformsToOverride' PipelineOption. Provided list of URNs: " + urnsToOverride);
        }
        TransformServiceLauncher service = null;
        ExternalTranslationOptions externalTranslationOptions = (ExternalTranslationOptions)options.as(ExternalTranslationOptions.class);
        if (externalTranslationOptions.getTransformServiceAddress() != null) {
            serviceAddress = externalTranslationOptions.getTransformServiceAddress();
        } else if (externalTranslationOptions.getTransformServiceBeamVersion() != null) {
            String projectName = UUID.randomUUID().toString();
            int port = TransformUpgrader.findAvailablePort();
            service = TransformServiceLauncher.forProject((String)projectName, (int)port, null);
            service.setBeamVersion(externalTranslationOptions.getTransformServiceBeamVersion());
            service.start();
            service.waitTillUp(-1);
            serviceAddress = "localhost:" + Integer.toString(port);
        } else {
            throw new IllegalArgumentException("Either option TransformServiceAddress or option TransformServiceBeamVersion should be provided to override a transform using the transform service");
        }
        Endpoints.ApiServiceDescriptor expansionServiceEndpoint = Endpoints.ApiServiceDescriptor.newBuilder().setUrl(serviceAddress).build();
        for (String transformId : transformsToOverride) {
            pipeline = this.updateTransformViaTransformService(pipeline, transformId, expansionServiceEndpoint, options);
        }
        if (service != null) {
            service.shutdown();
        }
        return pipeline;
    }

    private <InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<InputT, OutputT>> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline updateTransformViaTransformService(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline runnerAPIpipeline, @UnknownKeyFor @NonNull @Initialized String transformId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor transformServiceEndpoint, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.PTransform transformToUpgrade = (RunnerApi.PTransform)runnerAPIpipeline.getComponents().getTransformsMap().get(transformId);
        if (transformToUpgrade == null) {
            throw new IllegalArgumentException("Could not find a transform with the ID " + transformId);
        }
        ByteString configRowBytes = transformToUpgrade.getAnnotationsOrThrow("config_row");
        ByteString configRowSchemaBytes = transformToUpgrade.getAnnotationsOrThrow("config_row_schema");
        SchemaApi.Schema configRowSchemaProto = SchemaApi.Schema.parseFrom((byte[])configRowSchemaBytes.toByteArray());
        ExternalTransforms.ExternalConfigurationPayload payload = ExternalTransforms.ExternalConfigurationPayload.newBuilder().setSchema(configRowSchemaProto).setPayload(configRowBytes).build();
        RunnerApi.PTransform.Builder ptransformBuilder = RunnerApi.PTransform.newBuilder().setUniqueName(transformToUpgrade.getUniqueName() + "_external").setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(transformToUpgrade.getSpec().getUrn()).setPayload(ByteString.copyFrom((byte[])payload.toByteArray())).build());
        for (Map.Entry entry2 : transformToUpgrade.getInputsMap().entrySet()) {
            ptransformBuilder.putInputs((String)entry2.getKey(), (String)entry2.getValue());
        }
        for (Map.Entry entry2 : transformToUpgrade.getOutputsMap().entrySet()) {
            ptransformBuilder.putOutputs((String)entry2.getKey(), (String)entry2.getValue());
        }
        ExpansionApi.ExpansionRequest.Builder requestBuilder = ExpansionApi.ExpansionRequest.newBuilder();
        PipelineOptions optionsClone = PipelineOptionsTranslation.fromProto(PipelineOptionsTranslation.toProto(options));
        String updateCompatibilityVersion = ((StreamingOptions)optionsClone.as(StreamingOptions.class)).getUpdateCompatibilityVersion();
        if (updateCompatibilityVersion == null || updateCompatibilityVersion.isEmpty()) {
            ((StreamingOptions)optionsClone.as(StreamingOptions.class)).setUpdateCompatibilityVersion(ReleaseInfo.getReleaseInfo().getSdkVersion());
        }
        ExpansionApi.ExpansionRequest request = requestBuilder.setComponents(runnerAPIpipeline.getComponents()).setTransform(ptransformBuilder.build()).setNamespace(UPGRADE_NAMESPACE).setPipelineOptions(PipelineOptionsTranslation.toProto(optionsClone)).addAllRequirements((Iterable)runnerAPIpipeline.getRequirementsList()).build();
        ExpansionApi.ExpansionResponse response = this.clientFactory.getExpansionServiceClient(transformServiceEndpoint).expand(request);
        if (!Strings.isNullOrEmpty((String)response.getError())) {
            throw new RuntimeException(String.format("expansion service error: %s", response.getError()));
        }
        Map<String, RunnerApi.Environment> newEnvironmentsWithDependencies = response.getComponents().getEnvironmentsMap().entrySet().stream().filter(kv -> !runnerAPIpipeline.getComponents().getEnvironmentsMap().containsKey(kv.getKey()) && ((RunnerApi.Environment)kv.getValue()).getDependenciesCount() != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        RunnerApi.Components expandedComponents = response.getComponents().toBuilder().putAllEnvironments(External.ExpandableTransform.resolveArtifacts(newEnvironmentsWithDependencies, transformServiceEndpoint)).build();
        RunnerApi.PTransform expandedTransform = response.getTransform();
        RunnerApi.PTransform.Builder expandedTransformBuilder = expandedTransform.toBuilder();
        String transformServiceVersion = ((ExternalTranslationOptions)options.as(ExternalTranslationOptions.class)).getTransformServiceBeamVersion();
        if (transformServiceVersion == null || transformServiceVersion.isEmpty()) {
            transformServiceVersion = "unknown";
        }
        expandedTransformBuilder.putAnnotations(UPGRADE_KEY, ByteString.copyFromUtf8((String)transformServiceVersion));
        expandedTransform = expandedTransformBuilder.build();
        ProtocolStringList expandedRequirements = response.getRequirementsList();
        RunnerApi.Components.Builder newComponentsBuilder = expandedComponents.toBuilder();
        Collection oldOutputs = transformToUpgrade.getOutputsMap().values();
        HashMap<String, String> inputReplacements = new HashMap<String, String>();
        if (transformToUpgrade.getOutputsMap().size() == 1) {
            inputReplacements.put((String)oldOutputs.iterator().next(), (String)expandedTransform.getOutputsMap().values().iterator().next());
        } else {
            for (Map.Entry entry3 : transformToUpgrade.getOutputsMap().entrySet()) {
                if (!expandedTransform.getOutputsMap().keySet().contains(entry3.getKey())) {
                    throw new IllegalArgumentException("Original transform had an output with tag " + (String)entry3.getKey() + " but upgraded transform did not.");
                }
                String newOutput = (String)expandedTransform.getOutputsMap().get(entry3.getKey());
                if (newOutput == null) {
                    throw new IllegalArgumentException("Could not find an output with tag " + (String)entry3.getKey() + " for the transform " + expandedTransform);
                }
                inputReplacements.put((String)entry3.getValue(), newOutput);
            }
        }
        ArrayList<String> transformsToRemove = new ArrayList<String>();
        TransformUpgrader.recursivelyFindSubTransforms(transformId, runnerAPIpipeline.getComponents(), transformsToRemove);
        Map<String, RunnerApi.PTransform> updatedExpandedTransformMap = expandedComponents.getTransformsMap().entrySet().stream().filter(entry -> !transformsToRemove.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            Map inputsMap = ((RunnerApi.PTransform)entry.getValue()).getInputsMap();
            RunnerApi.PTransform.Builder transformBuilder = ((RunnerApi.PTransform)entry.getValue()).toBuilder();
            if (!Collections.disjoint(inputsMap.values(), inputReplacements.keySet())) {
                HashMap<String, String> updatedInputsMap = new HashMap<String, String>();
                for (Map.Entry inputEntry : inputsMap.entrySet()) {
                    String updaterValue = inputReplacements.containsKey(inputEntry.getValue()) ? (String)inputReplacements.get(inputEntry.getValue()) : (String)inputEntry.getValue();
                    updatedInputsMap.put((String)inputEntry.getKey(), updaterValue);
                }
                transformBuilder.clearInputs();
                transformBuilder.putAllInputs(updatedInputsMap);
            }
            return transformBuilder.build();
        }));
        newComponentsBuilder.clearTransforms();
        newComponentsBuilder.putAllTransforms(updatedExpandedTransformMap);
        newComponentsBuilder.putTransforms(transformId, expandedTransform);
        RunnerApi.Pipeline.Builder newRunnerAPIPipelineBuilder = runnerAPIpipeline.toBuilder();
        newRunnerAPIPipelineBuilder.clearComponents();
        newRunnerAPIPipelineBuilder.setComponents(newComponentsBuilder.build());
        newRunnerAPIPipelineBuilder.addAllRequirements((Iterable)expandedRequirements);
        return newRunnerAPIPipelineBuilder.build();
    }

    private static void recursivelyFindSubTransforms(@UnknownKeyFor @NonNull @Initialized String transformId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> results) {
        results.add(transformId);
        RunnerApi.PTransform transform = (RunnerApi.PTransform)components.getTransformsMap().get(transformId);
        if (transform == null) {
            throw new IllegalArgumentException("Could not find a transform with id " + transformId);
        }
        ProtocolStringList subTransforms = transform.getSubtransformsList();
        if (subTransforms != null) {
            for (String subTransformId : subTransforms) {
                TransformUpgrader.recursivelyFindSubTransforms(subTransformId, components, results);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized int findAvailablePort() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ServerSocket s = new ServerSocket(0);
        try {
            int n = s.getLocalPort();
            return n;
        }
        finally {
            s.close();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.clientFactory.close();
    }

    public static @Nullable @UnknownKeyFor @Initialized String findUpgradeURN(@UnknownKeyFor @NonNull @Initialized PTransform transform) {
        for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
            for (Map.Entry<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> entry : registrar.getTransformPayloadTranslators().entrySet()) {
                if (!entry.getKey().equals(transform.getClass())) continue;
                return entry.getValue().getUrn();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Object object) {
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                ObjectOutputStream out = new ObjectOutputStream(bos);
                Throwable throwable2 = null;
                try {
                    out.writeObject(object);
                    byArray = bos.toByteArray();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            TransformUpgrader.$closeResource(throwable2, out);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                TransformUpgrader.$closeResource(throwable2, out);
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static @UnknownKeyFor @NonNull @Initialized Object fromByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

