/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineValidator {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformValidator> VALIDATORS = ImmutableMap.builder().put((Object)"beam:transform:pardo:v1", PipelineValidator::validateParDo).put((Object)"beam:transform:window_into:v1", PipelineValidator::validateAssignWindows).put((Object)"beam:transform:teststream:v1", PipelineValidator::validateTestStream).put((Object)"beam:transform:combine_per_key:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_globally:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_precombine:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_merge_accumulators:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_extract_outputs:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_grouped_values:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:sdf_pair_with_restriction:v1", PipelineValidator::validateParDo).put((Object)"beam:transform:sdf_process_keyed_elements:v1", PipelineValidator::validateParDo).put((Object)"beam:runner:executable_stage:v1", PipelineValidator::validateExecutableStage).build();

    public static void validate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline p) {
        RunnerApi.Components components = p.getComponents();
        for (String transformId : p.getRootTransformIdsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(transformId), (String)"Root transform id %s is unknown", (Object)transformId);
        }
        PipelineValidator.validateComponents("pipeline", components, (Set<String>)ImmutableSet.copyOf((Collection)p.getRequirementsList()));
    }

    private static void validateComponents(@UnknownKeyFor @NonNull @Initialized String context, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        String previousId;
        HashMap uniqueNamesById = Maps.newHashMap();
        for (String transformId : components.getTransformsMap().keySet()) {
            RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
            previousId = uniqueNamesById.put(transform.getUniqueName(), transformId);
            Preconditions.checkArgument((previousId == null ? 1 : 0) != 0, (String)"%s: Transforms %s and %s both have unique_name \"%s\"", (Object)context, (Object)transformId, (Object)previousId, (Object)transform.getUniqueName());
            PipelineValidator.validateTransform(transformId, transform, components, requirements);
        }
        uniqueNamesById = Maps.newHashMap();
        for (String pcollectionId : components.getPcollectionsMap().keySet()) {
            RunnerApi.PCollection pc = components.getPcollectionsOrThrow(pcollectionId);
            Preconditions.checkArgument((!pc.getUniqueName().isEmpty() ? 1 : 0) != 0, (String)"%s: PCollection %s does not have a unique_name set", (Object)context, (Object)pcollectionId);
            previousId = uniqueNamesById.put(pc.getUniqueName(), pcollectionId);
            Preconditions.checkArgument((previousId == null ? 1 : 0) != 0, (String)"%s: PCollections %s and %s both have unique_name \"%s\"", (Object)context, (Object)pcollectionId, (Object)previousId, (Object)pc.getUniqueName());
            Preconditions.checkArgument((boolean)components.containsCoders(pc.getCoderId()), (String)"%s: PCollection %s uses unknown coder %s", (Object)context, (Object)pcollectionId, (Object)pc.getCoderId());
            Preconditions.checkArgument((boolean)components.containsWindowingStrategies(pc.getWindowingStrategyId()), (String)"%s: PCollection %s uses unknown windowing strategy %s", (Object)context, (Object)pcollectionId, (Object)pc.getWindowingStrategyId());
        }
        for (String strategyId : components.getWindowingStrategiesMap().keySet()) {
            RunnerApi.WindowingStrategy strategy = components.getWindowingStrategiesOrThrow(strategyId);
            Preconditions.checkArgument((boolean)components.containsCoders(strategy.getWindowCoderId()), (String)"%s: WindowingStrategy %s uses unknown coder %s", (Object)context, (Object)strategyId, (Object)strategy.getWindowCoderId());
        }
        for (String coderId : components.getCodersMap().keySet()) {
            for (String componentCoderId : components.getCodersOrThrow(coderId).getComponentCoderIdsList()) {
                Preconditions.checkArgument((boolean)components.containsCoders(componentCoderId), (String)"%s: Coder %s uses unknown component coder %s", (Object)context, (Object)coderId, (Object)componentCoderId);
            }
        }
    }

    private static void validateTransform(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        String pcollectionId;
        for (String subtransformId : transform.getSubtransformsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(subtransformId), (String)"Transform %s references unknown subtransform %s", (Object)id, (Object)subtransformId);
        }
        for (String inputId : transform.getInputsMap().keySet()) {
            pcollectionId = transform.getInputsOrThrow(inputId);
            Preconditions.checkArgument((boolean)components.containsPcollections(pcollectionId), (String)"Transform %s input %s points to unknown PCollection %s", (Object)id, (Object)inputId, (Object)pcollectionId);
        }
        for (String outputId : transform.getOutputsMap().keySet()) {
            pcollectionId = transform.getOutputsOrThrow(outputId);
            Preconditions.checkArgument((boolean)components.containsPcollections(pcollectionId), (String)"Transform %s output %s points to unknown PCollection %s", (Object)id, (Object)outputId, (Object)pcollectionId);
        }
        String urn = transform.getSpec().getUrn();
        if (PTransformTranslation.RUNNER_IMPLEMENTED_TRANSFORMS.contains((Object)urn)) {
            Preconditions.checkArgument((boolean)transform.getEnvironmentId().isEmpty(), (String)"Transform %s references environment %s when no environment should be specified since it is a required runner implemented transform %s.", (Object)id, (Object)transform.getEnvironmentId(), (Object)urn);
        }
        if (Strings.isNullOrEmpty((String)urn)) {
            Preconditions.checkArgument((boolean)PipelineValidator.isComposite(transform), (String)"Transform %s is not a composite transform but does not have a specified URN. %s", (Object)id, (Object)transform);
        }
        if (VALIDATORS.containsKey((Object)urn)) {
            try {
                ((TransformValidator)VALIDATORS.get((Object)urn)).validate(id, transform, components, requirements);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to validate transform %s", id), e);
            }
        }
    }

    private static void validateParDo(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload());
        for (String sideInputId : payload.getSideInputsMap().keySet()) {
            Preconditions.checkArgument((boolean)transform.containsInputs(sideInputId), (String)"Transform %s side input %s is not listed in the transform's inputs", (Object)id, (Object)sideInputId);
        }
        if (payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0) {
            Preconditions.checkArgument((boolean)requirements.contains("beam:requirement:pardo:stateful:v1"));
        }
        if (!payload.getRestrictionCoderId().isEmpty()) {
            Preconditions.checkArgument((boolean)components.containsCoders(payload.getRestrictionCoderId()));
            Preconditions.checkArgument((boolean)requirements.contains("beam:requirement:pardo:splittable_dofn:v1"));
        }
        if (payload.getRequestsFinalization()) {
            Preconditions.checkArgument((boolean)requirements.contains("beam:requirement:pardo:finalization:v1"));
        }
        if (payload.getRequiresStableInput()) {
            Preconditions.checkArgument((boolean)requirements.contains("beam:requirement:pardo:stable_input:v1"));
        }
        if (payload.getRequiresTimeSortedInput()) {
            Preconditions.checkArgument((boolean)requirements.contains("beam:requirement:pardo:time_sorted_input:v1"));
        }
    }

    private static void validateAssignWindows(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        RunnerApi.WindowIntoPayload.parseFrom((ByteString)transform.getSpec().getPayload());
    }

    private static void validateTestStream(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        RunnerApi.TestStreamPayload.parseFrom((ByteString)transform.getSpec().getPayload());
    }

    private static void validateCombine(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        RunnerApi.CombinePayload payload = RunnerApi.CombinePayload.parseFrom((ByteString)transform.getSpec().getPayload());
        Preconditions.checkArgument((boolean)components.containsCoders(payload.getAccumulatorCoderId()), (String)"Transform %s uses unknown accumulator coder id %s", (Object)id, (Object)payload.getAccumulatorCoderId());
    }

    private static void validateExecutableStage(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components outerComponents, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        RunnerApi.ExecutableStagePayload payload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getSpec().getPayload());
        RunnerApi.Components components = payload.getComponents();
        Preconditions.checkArgument((boolean)transform.getInputsMap().values().contains(payload.getInput()), (String)"ExecutableStage %s uses unknown input %s", (Object)id, (Object)payload.getInput());
        Preconditions.checkArgument((!payload.getTransformsList().isEmpty() ? 1 : 0) != 0, (String)"ExecutableStage %s contains no transforms", (Object)id);
        for (String subtransformId : payload.getTransformsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(subtransformId), (String)"ExecutableStage %s uses unknown transform %s", (Object)id, (Object)subtransformId);
        }
        for (String outputId : payload.getOutputsList()) {
            Preconditions.checkArgument((boolean)components.containsPcollections(outputId), (String)"ExecutableStage %s uses unknown output %s", (Object)id, (Object)outputId);
        }
        PipelineValidator.validateComponents("ExecutableStage " + id, components, requirements);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isComposite(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform) {
        if (!transform.getSubtransformsList().isEmpty()) {
            return true;
        }
        ImmutableSet inputs = ImmutableSet.copyOf(transform.getInputsMap().values());
        for (String output : transform.getOutputsMap().values()) {
            if (inputs.contains(output)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface TransformValidator {
        public void validate(@UnknownKeyFor @NonNull @Initialized String var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform var2, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Components var3, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> var4) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

