/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class MonitoringInfoEncodings {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> VARINT_CODER = VarLongCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> DOUBLE_CODER = DoubleCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Distribution(@UnknownKeyFor @NonNull @Initialized DistributionData data) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode((Object)data.count(), (OutputStream)output);
            VARINT_CODER.encode((Object)data.sum(), (OutputStream)output);
            VARINT_CODER.encode((Object)data.min(), (OutputStream)output);
            VARINT_CODER.encode((Object)data.max(), (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized DistributionData decodeInt64Distribution(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        InputStream input = payload.newInput();
        try {
            long count = (Long)VARINT_CODER.decode(input);
            long sum = (Long)VARINT_CODER.decode(input);
            long min = (Long)VARINT_CODER.decode(input);
            long max = (Long)VARINT_CODER.decode(input);
            return DistributionData.create(sum, count, min, max);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeDoubleDistribution(@UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized double sum, @UnknownKeyFor @NonNull @Initialized double min, @UnknownKeyFor @NonNull @Initialized double max) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode((Object)count, (OutputStream)output);
            DOUBLE_CODER.encode((Object)sum, (OutputStream)output);
            DOUBLE_CODER.encode((Object)min, (OutputStream)output);
            DOUBLE_CODER.encode((Object)max, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Gauge(@UnknownKeyFor @NonNull @Initialized GaugeData data) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode((Object)data.timestamp().getMillis(), (OutputStream)output);
            VARINT_CODER.encode((Object)data.value(), (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized GaugeData decodeInt64Gauge(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        InputStream input = payload.newInput();
        try {
            Instant timestamp = new Instant(VARINT_CODER.decode(input));
            return GaugeData.create((Long)VARINT_CODER.decode(input), timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Counter(@UnknownKeyFor @NonNull @Initialized long value) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode((Object)value, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized long decodeInt64Counter(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        try {
            return VarLongCoder.of().decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeDoubleCounter(@UnknownKeyFor @NonNull @Initialized double value) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            DOUBLE_CODER.encode((Object)value, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized double decodeDoubleCounter(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        try {
            return (Double)DOUBLE_CODER.decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

