/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.Timer;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.SideInputReference;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.TimerReference;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.UserStateReference;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_BagUserStateSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_ExecutableProcessBundleDescriptor;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_OutputEncoding;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_SideInputSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.AutoValue_ProcessBundleDescriptors_TimerSpec;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.data.RemoteInputDestination;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.ByteStringCoder;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.WireCoders;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.RemoteGrpcPortRead;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.RemoteGrpcPortWrite;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableTable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProcessBundleDescriptors {
    public static @UnknownKeyFor @NonNull @Initialized ExecutableProcessBundleDescriptor fromExecutableStage(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor stateEndpoint) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"id must be specified.");
        Preconditions.checkState((stage != null ? 1 : 0) != 0, (Object)"stage must be specified.");
        Preconditions.checkState((dataEndpoint != null ? 1 : 0) != 0, (Object)"dataEndpoint must be specified.");
        Preconditions.checkState((stateEndpoint != null ? 1 : 0) != 0, (Object)"stateEndpoint must be specified.");
        return ProcessBundleDescriptors.fromExecutableStageInternal(id, stage, dataEndpoint, stateEndpoint);
    }

    public static @UnknownKeyFor @NonNull @Initialized ExecutableProcessBundleDescriptor fromExecutableStage(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"id must be specified.");
        Preconditions.checkState((stage != null ? 1 : 0) != 0, (Object)"stage must be specified.");
        Preconditions.checkState((dataEndpoint != null ? 1 : 0) != 0, (Object)"dateEndpoint must be specified.");
        return ProcessBundleDescriptors.fromExecutableStageInternal(id, stage, dataEndpoint, null);
    }

    private static @UnknownKeyFor @NonNull @Initialized ExecutableProcessBundleDescriptor fromExecutableStageInternal(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Endpoints.ApiServiceDescriptor stateEndpoint) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Map<String, RunnerApi.PTransform> stageTransforms = stage.getTransforms().stream().collect(Collectors.toMap(PipelineNode.PTransformNode::getId, PipelineNode.PTransformNode::getTransform));
        RunnerApi.Components.Builder components = stage.getComponents().toBuilder().clearTransforms().putAllTransforms(stageTransforms);
        ImmutableList.Builder inputDestinationsBuilder = ImmutableList.builder();
        ImmutableMap.Builder remoteOutputCodersBuilder = ImmutableMap.builder();
        RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting = stage.getWireCoderSettings().stream().filter(ws -> ws.getInputOrOutputId().equals(stage.getInputPCollection().getId())).findAny().orElse(RunnerApi.ExecutableStagePayload.WireCoderSetting.getDefaultInstance());
        inputDestinationsBuilder.add(ProcessBundleDescriptors.addStageInput(dataEndpoint, stage.getInputPCollection(), components, wireCoderSetting));
        remoteOutputCodersBuilder.putAll(ProcessBundleDescriptors.addStageOutputs(dataEndpoint, stage.getOutputPCollections(), components, stage.getWireCoderSettings()));
        Map<String, Map<String, SideInputSpec>> sideInputSpecs = ProcessBundleDescriptors.addSideInputs(stage, components);
        Map<String, Map<String, BagUserStateSpec>> bagUserStateSpecs = ProcessBundleDescriptors.forBagUserStates(stage, components.build());
        Map<String, Map<String, TimerSpec>> timerSpecs = ProcessBundleDescriptors.forTimerSpecs(stage, components);
        ProcessBundleDescriptors.lengthPrefixAnyInputCoder(stage.getInputPCollection().getId(), components);
        BeamFnApi.ProcessBundleDescriptor.Builder bundleDescriptorBuilder = BeamFnApi.ProcessBundleDescriptor.newBuilder().setId(id);
        if (stateEndpoint != null) {
            bundleDescriptorBuilder.setStateApiServiceDescriptor(stateEndpoint);
        }
        if (timerSpecs.size() > 0) {
            bundleDescriptorBuilder.setTimerApiServiceDescriptor(dataEndpoint);
        }
        bundleDescriptorBuilder.putAllCoders(components.getCodersMap()).putAllEnvironments(components.getEnvironmentsMap()).putAllPcollections(components.getPcollectionsMap()).putAllWindowingStrategies(components.getWindowingStrategiesMap()).putAllTransforms(components.getTransformsMap());
        return ExecutableProcessBundleDescriptor.of(bundleDescriptorBuilder.build(), (List<RemoteInputDestination>)inputDestinationsBuilder.build(), (Map<String, Coder>)remoteOutputCodersBuilder.build(), sideInputSpecs, bagUserStateSpecs, timerSpecs);
    }

    private static void lengthPrefixAnyInputCoder(@UnknownKeyFor @NonNull @Initialized String inputPCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder componentsBuilder) {
        RunnerApi.PCollection pcollection = componentsBuilder.getPcollectionsOrThrow(inputPCollectionId);
        String newInputCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder(pcollection.getCoderId(), componentsBuilder, false);
        componentsBuilder.putPcollections(inputPCollectionId, pcollection.toBuilder().setCoderId(newInputCoderId).build());
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> addStageOutputs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> outputPCollections, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, @UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting> wireCoderSettings) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LinkedHashMap remoteOutputCoders = new LinkedHashMap();
        for (PipelineNode.PCollectionNode outputPCollection : outputPCollections) {
            RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting = wireCoderSettings.stream().filter(ws -> ws.getInputOrOutputId().equals(outputPCollection.getId())).findAny().orElse(RunnerApi.ExecutableStagePayload.WireCoderSetting.getDefaultInstance());
            OutputEncoding outputEncoding = ProcessBundleDescriptors.addStageOutput(dataEndpoint, components, outputPCollection, wireCoderSetting);
            remoteOutputCoders.put(outputEncoding.getPTransformId(), outputEncoding.getCoder());
        }
        return remoteOutputCoders;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RemoteInputDestination<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> addStageInput(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode inputPCollection, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String inputWireCoderId = WireCoders.addSdkWireCoder(inputPCollection, components, wireCoderSetting);
        Coder wireCoder = WireCoders.instantiateRunnerWireCoder(inputPCollection, components.build(), wireCoderSetting);
        BeamFnApi.RemoteGrpcPort inputPort = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(dataEndpoint).setCoderId(inputWireCoderId).build();
        String inputId = SyntheticComponents.uniqueId(String.format("fn/read/%s", inputPCollection.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsTransforms(arg_0));
        RunnerApi.PTransform inputTransform = RemoteGrpcPortRead.readFromPort(inputPort, inputPCollection.getId()).toPTransform();
        components.putTransforms(inputId, inputTransform);
        return RemoteInputDestination.of(wireCoder, inputId);
    }

    private static @UnknownKeyFor @NonNull @Initialized OutputEncoding addStageOutput(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Endpoints.ApiServiceDescriptor dataEndpoint, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode outputPCollection, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String outputWireCoderId = WireCoders.addSdkWireCoder(outputPCollection, components, wireCoderSetting);
        Coder wireCoder = WireCoders.instantiateRunnerWireCoder(outputPCollection, components.build(), wireCoderSetting);
        BeamFnApi.RemoteGrpcPort outputPort = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(dataEndpoint).setCoderId(outputWireCoderId).build();
        RemoteGrpcPortWrite outputWrite = RemoteGrpcPortWrite.writeToPort(outputPCollection.getId(), outputPort);
        String outputId = SyntheticComponents.uniqueId(String.format("fn/write/%s", outputPCollection.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsTransforms(arg_0));
        RunnerApi.PTransform outputTransform = outputWrite.toPTransform();
        components.putTransforms(outputId, outputTransform);
        return new AutoValue_ProcessBundleDescriptors_OutputEncoding(outputId, wireCoder);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SideInputSpec>> getSideInputs(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ProcessBundleDescriptors.addSideInputs(stage, stage.getComponents().toBuilder());
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SideInputSpec>> addSideInputs(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (SideInputReference sideInputReference : stage.getSideInputs()) {
            PipelineNode.PCollectionNode pcNode = sideInputReference.collection();
            RunnerApi.PCollection pc = pcNode.getPCollection();
            String lengthPrefixedCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder(pc.getCoderId(), components, false);
            components.putPcollections(pcNode.getId(), pc.toBuilder().setCoderId(lengthPrefixedCoderId).build());
            WindowedValue.FullWindowedValueCoder coder = (WindowedValue.FullWindowedValueCoder)WireCoders.instantiateRunnerWireCoder(pcNode, components.build());
            idsToSpec.put((Object)sideInputReference.transform().getId(), (Object)sideInputReference.localName(), (Object)SideInputSpec.of(sideInputReference.transform().getId(), sideInputReference.localName(), ProcessBundleDescriptors.getAccessPattern(sideInputReference), coder.getValueCoder(), coder.getWindowCoder()));
        }
        return idsToSpec.build().rowMap();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec getAccessPattern(@UnknownKeyFor @NonNull @Initialized SideInputReference sideInputReference) {
        try {
            return ((RunnerApi.SideInput)RunnerApi.ParDoPayload.parseFrom((ByteString)sideInputReference.transform().getTransform().getSpec().getPayload()).getSideInputsMap().get(sideInputReference.localName())).getAccessPattern();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BagUserStateSpec>> forBagUserStates(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (UserStateReference userStateReference : stage.getUserStates()) {
            WindowedValue.FullWindowedValueCoder coder = (WindowedValue.FullWindowedValueCoder)WireCoders.instantiateRunnerWireCoder(userStateReference.collection(), components);
            idsToSpec.put((Object)userStateReference.transform().getId(), (Object)userStateReference.localName(), BagUserStateSpec.of(userStateReference.transform().getId(), userStateReference.localName(), ByteStringCoder.of(), ByteStringCoder.of(), coder.getWindowCoder()));
        }
        return idsToSpec.build().rowMap();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerSpec>> forTimerSpecs(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableTable.Builder idsToSpec = ImmutableTable.builder();
        for (TimerReference timerReference : stage.getTimers()) {
            org.apache.beam.sdk.state.TimerSpec spec;
            RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)timerReference.transform().getTransform().getSpec().getPayload());
            RunnerApi.TimerFamilySpec timerFamilySpec = payload.getTimerFamilySpecsOrThrow(timerReference.localName());
            switch (timerFamilySpec.getTimeDomain()) {
                case EVENT_TIME: {
                    spec = TimerSpecs.timer((TimeDomain)TimeDomain.EVENT_TIME);
                    break;
                }
                case PROCESSING_TIME: {
                    spec = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown or unsupported time domain %s", timerFamilySpec.getTimeDomain()));
                }
            }
            for (RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting : stage.getWireCoderSettings()) {
                if (!wireCoderSetting.hasTimer() || !wireCoderSetting.getTimer().getTransformId().equals(timerReference.transform().getId()) || !wireCoderSetting.getTimer().getLocalName().equals(timerReference.localName())) continue;
                throw new UnsupportedOperationException("WireCoderSetting for timer is yet to be supported.");
            }
            String originalTimerCoderId = timerFamilySpec.getTimerFamilyCoderId();
            String sdkCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder(originalTimerCoderId, components, false);
            String runnerCoderId = LengthPrefixUnknownCoders.addLengthPrefixedCoder(originalTimerCoderId, components, true);
            Coder<?> timerCoder = RehydratedComponents.forComponents(components.build()).getCoder(runnerCoderId);
            Preconditions.checkArgument((boolean)(timerCoder instanceof Timer.Coder), (String)"Expected a timer coder but received %s.", timerCoder);
            RunnerApi.FunctionSpec.Builder updatedSpec = components.getTransformsOrThrow(timerReference.transform().getId()).toBuilder().getSpecBuilder();
            RunnerApi.ParDoPayload.Builder updatedPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)updatedSpec.getPayload()).toBuilder();
            updatedPayload.putTimerFamilySpecs(timerReference.localName(), updatedPayload.getTimerFamilySpecsOrThrow(timerReference.localName()).toBuilder().setTimerFamilyCoderId(sdkCoderId).build());
            updatedSpec.setPayload(updatedPayload.build().toByteString());
            components.putTransforms(timerReference.transform().getId(), components.getTransformsOrThrow(timerReference.transform().getId()).toBuilder().setSpec(updatedSpec).build());
            idsToSpec.put((Object)timerReference.transform().getId(), (Object)timerReference.localName(), TimerSpec.of(timerReference.transform().getId(), timerReference.localName(), spec, timerCoder));
        }
        return idsToSpec.build().rowMap();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class ExecutableProcessBundleDescriptor {
        public static @UnknownKeyFor @NonNull @Initialized ExecutableProcessBundleDescriptor of(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor descriptor, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RemoteInputDestination> inputDestinations, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder> outputTransformCoders, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SideInputSpec>> sideInputSpecs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BagUserStateSpec>> bagUserStateSpecs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerSpec>> timerSpecs) {
            ImmutableTable.Builder copyOfSideInputSpecs = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, SideInputSpec>> entry : sideInputSpecs.entrySet()) {
                for (Map.Entry<String, SideInputSpec> entry2 : entry.getValue().entrySet()) {
                    copyOfSideInputSpecs.put((Object)entry.getKey(), (Object)entry2.getKey(), (Object)entry2.getValue());
                }
            }
            ImmutableTable.Builder copyOfBagUserStateSpecs = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, BagUserStateSpec>> entry : bagUserStateSpecs.entrySet()) {
                for (Map.Entry<String, BagUserStateSpec> entry3 : entry.getValue().entrySet()) {
                    copyOfBagUserStateSpecs.put((Object)entry.getKey(), (Object)entry3.getKey(), (Object)entry3.getValue());
                }
            }
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (Map.Entry<String, Map<String, TimerSpec>> entry : timerSpecs.entrySet()) {
                for (Map.Entry<String, TimerSpec> inner : entry.getValue().entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)inner.getKey(), (Object)inner.getValue());
                }
            }
            return new AutoValue_ProcessBundleDescriptors_ExecutableProcessBundleDescriptor(descriptor, inputDestinations, Collections.unmodifiableMap(outputTransformCoders), (Map<String, Map<String, SideInputSpec>>)copyOfSideInputSpecs.build().rowMap(), (Map<String, Map<String, BagUserStateSpec>>)copyOfBagUserStateSpecs.build().rowMap(), (Map<String, Map<String, TimerSpec>>)builder.build().rowMap());
        }

        public abstract // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleDescriptor getProcessBundleDescriptor();

        public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RemoteInputDestination> getRemoteInputDestinations();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder> getRemoteOutputCoders();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SideInputSpec>> getSideInputSpecs();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BagUserStateSpec>> getBagUserStateSpecs();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerSpec>> getTimerSpecs();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class TimerSpec<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
        static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TimerSpec<K, V, W> of(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.state.TimerSpec timerSpec, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Timer<K>> coder) {
            return new AutoValue_ProcessBundleDescriptors_TimerSpec(transformId, timerId, timerSpec, coder);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String transformId();

        public abstract @UnknownKeyFor @NonNull @Initialized String timerId();

        public abstract @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.state.TimerSpec getTimerSpec();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<K> coder();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class BagUserStateSpec<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
        static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized BagUserStateSpec<K, V, W> of(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String userStateId, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
            return new AutoValue_ProcessBundleDescriptors_BagUserStateSpec<K, V, W>(transformId, userStateId, keyCoder, valueCoder, windowCoder);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String transformId();

        public abstract @UnknownKeyFor @NonNull @Initialized String userStateId();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class SideInputSpec<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
        public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized SideInputSpec of(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec accessPattern, @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
            return new AutoValue_ProcessBundleDescriptors_SideInputSpec<T, W>(transformId, sideInputId, accessPattern, elementCoder, windowCoder);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String transformId();

        public abstract @UnknownKeyFor @NonNull @Initialized String sideInputId();

        public abstract // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec accessPattern();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder();

        public abstract @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder();
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    static abstract class OutputEncoding {
        OutputEncoding() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized String getPTransformId();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoder();
    }
}

