/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.ByteBuddyUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AutoValueUtils {
    private static final @UnknownKeyFor @NonNull @Initialized ByteBuddy BYTE_BUDDY = new ByteBuddy();

    public static @UnknownKeyFor @NonNull @Initialized Class getBaseAutoValueClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        while (clazz != null && clazz.getName().contains("AutoValue_")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private static @UnknownKeyFor @NonNull @Initialized Class getAutoValueGenerated(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        String generatedClassName = AutoValueUtils.getAutoValueGeneratedName(clazz.getName());
        try {
            return Class.forName(generatedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AutoValue generated class not found: " + generatedClassName);
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized Class getAutoValueGeneratedBuilder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        Class<?> generated;
        try {
            generated = Class.forName(AutoValueUtils.getAutoValueGeneratedName(clazz.getName()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        for (Class<?> base = generated; base != null && base.getName().contains("AutoValue_"); base = base.getSuperclass()) {
            generated = base;
        }
        String builderName = generated.getName() + "$Builder";
        try {
            return Class.forName(builderName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String getAutoValueGeneratedName(@UnknownKeyFor @NonNull @Initialized String baseClass) {
        int lastDot = baseClass.lastIndexOf(46);
        String packageName = baseClass.substring(0, lastDot);
        String baseName = baseClass.substring(lastDot + 1, baseClass.length());
        baseName = baseName.replace('$', '_');
        return packageName + ".AutoValue_" + baseName;
    }

    public static @Nullable @UnknownKeyFor @Initialized SchemaUserTypeCreator getConstructorCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        Class generatedClass = AutoValueUtils.getAutoValueGenerated(clazz);
        List<FieldValueTypeInformation> schemaTypes = fieldValueTypeSupplier.get(clazz, schema);
        Optional<Constructor> constructor = Arrays.stream(generatedClass.getDeclaredConstructors()).filter(c -> !Modifier.isPrivate(c.getModifiers())).filter(c -> AutoValueUtils.matchConstructor(c, schemaTypes)).findAny();
        return constructor.map(c -> JavaBeanUtils.getConstructorCreator(generatedClass, c, schema, fieldValueTypeSupplier, new ByteBuddyUtils.DefaultTypeConversionsFactory())).orElse(null);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean matchConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Constructor<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> constructor, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> getterTypes) {
        if (constructor.getParameters().length != getterTypes.size()) {
            return false;
        }
        Map typeMap = getterTypes.stream().collect(Collectors.toMap(f -> ReflectUtils.stripGetterPrefix(f.getMethod().getName()), Function.identity()));
        boolean valid = true;
        for (Parameter parameter : constructor.getParameters()) {
            FieldValueTypeInformation type = (FieldValueTypeInformation)typeMap.get(parameter.getName());
            if (type != null && type.getRawType() == parameter.getType()) continue;
            valid = false;
            break;
        }
        if (valid) {
            return valid;
        }
        for (Parameter parameter : constructor.getParameters()) {
            String name = parameter.getName();
            if (!name.endsWith("$")) {
                return false;
            }
            FieldValueTypeInformation type = (FieldValueTypeInformation)typeMap.get(name = name.substring(0, name.length() - 1));
            if (type != null && type.getRawType() == parameter.getType()) continue;
            return false;
        }
        return true;
    }

    public static @Nullable @UnknownKeyFor @Initialized SchemaUserTypeCreator getBuilderCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        Class builderClass = AutoValueUtils.getAutoValueGeneratedBuilder(clazz);
        if (builderClass == null) {
            return null;
        }
        Map setterTypes = ReflectUtils.getMethods(builderClass).stream().filter(ReflectUtils::isSetter).map(FieldValueTypeInformation::forSetter).collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        ArrayList setterMethods = Lists.newArrayList();
        List<FieldValueTypeInformation> schemaTypes = fieldValueTypeSupplier.get(clazz, schema);
        for (FieldValueTypeInformation type : schemaTypes) {
            String autoValueFieldName = ReflectUtils.stripGetterPrefix(type.getMethod().getName());
            FieldValueTypeInformation setterType = (FieldValueTypeInformation)setterTypes.get(autoValueFieldName);
            if (setterType == null) {
                throw new RuntimeException("AutoValue builder class " + builderClass + " did not contain a setter for " + autoValueFieldName);
            }
            setterMethods.add(setterType);
        }
        Method buildMethod = ReflectUtils.getMethods(builderClass).stream().filter(m -> m.getName().equals("build")).findAny().orElseThrow(() -> new RuntimeException("No build method in builder"));
        return AutoValueUtils.createBuilderCreator(builderClass, setterMethods, buildMethod, schema, schemaTypes);
    }

    private static @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator createBuilderCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> builderClass, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> setterMethods, @UnknownKeyFor @NonNull @Initialized Method buildMethod, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(builderClass)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new BuilderCreateInstruction(types, setterMethods, builderClass, buildMethod));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(), ByteBuddyUtils.getClassLoadingStrategy(builderClass)).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + builderClass + " with schema " + schema);
        }
    }

    static class BuilderCreateInstruction
    implements Implementation {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> setters;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> builderClass;
        private final @UnknownKeyFor @NonNull @Initialized Method buildMethod;

        BuilderCreateInstruction(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> setters, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> builderClass, @UnknownKeyFor @NonNull @Initialized Method buildMethod) {
            this.setters = setters;
            this.builderClass = builderClass;
            this.buildMethod = buildMethod;
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            ByteBuddyUtils.DefaultTypeConversionsFactory typeConversionsFactory = new ByteBuddyUtils.DefaultTypeConversionsFactory();
            TypeDescription.ForLoadedType loadedBuilder = new TypeDescription.ForLoadedType(this.builderClass);
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)loadedBuilder), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedBuilder.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly()))});
                ByteBuddyUtils.TypeConversion<Type> convertType = typeConversionsFactory.createTypeConversion(true);
                for (int i = 0; i < this.setters.size(); ++i) {
                    Method setterMethod = (Method)Preconditions.checkNotNull((Object)this.setters.get(i).getMethod());
                    Parameter parameter = setterMethod.getParameters()[0];
                    TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(parameter.getParameterizedType())));
                    StackManipulation.Compound readParameter = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue((int)i), ArrayAccess.REFERENCE.load(), TypeCasting.to((TypeDefinition)convertedType)});
                    stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, Duplication.SINGLE, typeConversionsFactory.createSetterConversions((StackManipulation)readParameter).convert(TypeDescriptor.of(parameter.getType())), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(setterMethod)), Removal.SINGLE});
                }
                stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(this.buildMethod)), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

