/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VarInt {
    private static @UnknownKeyFor @NonNull @Initialized long convertIntToLongNoSignExtend(@UnknownKeyFor @NonNull @Initialized int v) {
        return (long)v & 0xFFFFFFFFL;
    }

    public static void encode(@UnknownKeyFor @NonNull @Initialized int v, @UnknownKeyFor @NonNull @Initialized OutputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        VarInt.encode(VarInt.convertIntToLongNoSignExtend(v), stream);
    }

    public static void encode(@UnknownKeyFor @NonNull @Initialized long v, @UnknownKeyFor @NonNull @Initialized OutputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            stream.write((byte)v);
            return;
        }
        stream.write((byte)(v | 0x80L));
        stream.write((byte)(v >>>= 7));
    }

    public static @UnknownKeyFor @NonNull @Initialized int decodeInt(@UnknownKeyFor @NonNull @Initialized InputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long r = VarInt.decodeLong(stream);
        if (r < 0L || r >= 0x100000000L) {
            throw new IOException("varint overflow " + r);
        }
        return (int)r;
    }

    public static @UnknownKeyFor @NonNull @Initialized long decodeLong(@UnknownKeyFor @NonNull @Initialized InputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int b;
        long result = 0L;
        int shift = 0;
        do {
            if ((b = stream.read()) < 0) {
                if (shift == 0) {
                    throw new EOFException();
                }
                throw new IOException("varint not terminated");
            }
            long bits = b & 0x7F;
            if (shift >= 64 || shift == 63 && bits > 1L) {
                throw new IOException("varint too long");
            }
            result |= bits << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized int getLength(@UnknownKeyFor @NonNull @Initialized int v) {
        return VarInt.getLength(VarInt.convertIntToLongNoSignExtend(v));
    }

    public static @UnknownKeyFor @NonNull @Initialized int getLength(@UnknownKeyFor @NonNull @Initialized long v) {
        int result = 0;
        do {
            ++result;
        } while ((v >>>= 7) != 0L);
        return result;
    }
}

