/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.commons.lang3.SystemUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalFileSystem
extends FileSystem<LocalResourceId> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");

    LocalFileSystem() {
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.match(new File(".").getAbsolutePath(), specs);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized String baseDir, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (String spec : specs) {
            ret.add((Object)this.matchOne(baseDir, spec));
        }
        return ret.build();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized LocalResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.debug("creating file {}", (Object)resourceId);
        File absoluteFile = resourceId.getPath().toFile().getAbsoluteFile();
        if (!(absoluteFile.getParentFile() == null || absoluteFile.getParentFile().exists() || absoluteFile.getParentFile().mkdirs() || absoluteFile.getParentFile().exists())) {
            throw new IOException("Unable to create parent directories for '" + resourceId + "'");
        }
        return Channels.newChannel(new BufferedOutputStream(new FileOutputStream(absoluteFile)));
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized LocalResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.debug("opening file {}", (Object)resourceId);
        FileInputStream inputStream = new FileInputStream(resourceId.getPath().toFile());
        return inputStream.getChannel();
    }

    @Override
    protected void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized LocalResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized LocalResourceId> destResourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((srcResourceIds.size() == destResourceIds.size() ? 1 : 0) != 0, (String)"Number of source files %s must equal number of destination files %s", (int)srcResourceIds.size(), (int)destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument((parent.mkdirs() || parent.exists() ? 1 : 0) != 0, (String)"Unable to make output directory %s in order to copy into file %s", (Object)parent, (Object)dst.getPath());
            }
            Files.copy(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    @Override
    protected void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized LocalResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized LocalResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (moveOptions.length > 0) {
            throw new UnsupportedOperationException("Support for move options is not yet implemented.");
        }
        Preconditions.checkArgument((srcResourceIds.size() == destResourceIds.size() ? 1 : 0) != 0, (String)"Number of source files %s must equal number of destination files %s", (int)srcResourceIds.size(), (int)destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Renaming {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument((parent.mkdirs() || parent.exists() ? 1 : 0) != 0, (String)"Unable to make output directory %s in order to move into file %s", (Object)parent, (Object)dst.getPath());
            }
            Files.move(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @Override
    protected void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized LocalResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (LocalResourceId resourceId : resourceIds) {
            try {
                Files.delete(resourceId.getPath());
            }
            catch (NoSuchFileException e) {
                LOG.info("Ignoring failed deletion of file {} which already does not exist.", (Object)resourceId, (Object)e);
            }
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized LocalResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        if (isDirectory) {
            if (!singleResourceSpec.endsWith(File.separator)) {
                singleResourceSpec = singleResourceSpec + File.separator;
            }
        } else {
            Preconditions.checkArgument((!singleResourceSpec.endsWith(File.separator) ? 1 : 0) != 0, (String)"Expected file path but received directory path [%s].", (Object)singleResourceSpec);
        }
        Path path = Paths.get(singleResourceSpec, new String[0]);
        return LocalResourceId.fromPath(path, isDirectory);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return "file";
    }

    private @UnknownKeyFor @NonNull @Initialized MatchResult matchOne(@UnknownKeyFor @NonNull @Initialized String baseDir, @UnknownKeyFor @NonNull @Initialized String spec) {
        File specAsFile;
        File absoluteFile;
        if (spec.toLowerCase().startsWith("file:")) {
            spec = spec.substring("file:".length());
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            List<String> prefixes = Arrays.asList("///", "/");
            for (String prefix : prefixes) {
                if (!spec.toLowerCase().startsWith(prefix)) continue;
                spec = spec.substring(prefix.length());
            }
        }
        File file = absoluteFile = (specAsFile = new File(spec)).isAbsolute() ? specAsFile : new File(baseDir, spec);
        if (absoluteFile.exists()) {
            return MatchResult.create(MatchResult.Status.OK, (List<MatchResult.Metadata>)ImmutableList.of((Object)this.toMetadata(absoluteFile)));
        }
        File parent = this.getSpecNonGlobPrefixParentFile(absoluteFile.getAbsolutePath());
        if (!parent.exists()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, Collections.emptyList());
        }
        String pathToMatch = absoluteFile.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\"));
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathToMatch);
        Iterable files = org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files.fileTraverser().depthFirstPreOrder((Object)parent);
        Iterable matchedFiles = StreamSupport.stream(files.spliterator(), false).filter(arg_0 -> ((Predicate)Predicates.and((Predicate)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files.isFile(), input -> matcher.matches(input.toPath()))).apply(arg_0)).collect(Collectors.toList());
        LinkedList result = Lists.newLinkedList();
        for (File match : matchedFiles) {
            result.add(this.toMetadata(match));
        }
        if (result.isEmpty()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException(String.format("No files found for spec: %s in working directory %s", spec, baseDir)));
        }
        return MatchResult.create(MatchResult.Status.OK, result);
    }

    private @UnknownKeyFor @NonNull @Initialized File getSpecNonGlobPrefixParentFile(@UnknownKeyFor @NonNull @Initialized String spec) {
        String specNonWildcardPrefix = LocalFileSystem.getNonWildcardPrefix(spec);
        File file = new File(specNonWildcardPrefix);
        return specNonWildcardPrefix.endsWith(File.separator) ? file.getAbsoluteFile() : file.getAbsoluteFile().getParentFile();
    }

    private @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata toMetadata(@UnknownKeyFor @NonNull @Initialized File file) {
        return MatchResult.Metadata.builder().setResourceId(LocalResourceId.fromPath(file.toPath(), file.isDirectory())).setIsReadSeekEfficient(true).setSizeBytes(file.length()).setLastModifiedMillis(file.lastModified()).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized String getNonWildcardPrefix(@UnknownKeyFor @NonNull @Initialized String globExp) {
        Matcher m = GLOB_PREFIX.matcher(globExp);
        return !m.matches() ? globExp : m.group("PREFIX");
    }
}

