/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_JavaMapToFieldsTransformProvider_Configuration;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.sdk.schemas.transforms.providers.JavaRowUdf;
import org.apache.beam.sdk.schemas.transforms.providers.StringCompiler;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JavaMapToFieldsTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    protected static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        return new JavaMapToFieldsTransform(configuration);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:map_to_fields-java:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    protected static class JavaMapToFieldsTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> mappedValues = new TupleTag<Row>(){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> errorValues = new TupleTag<Row>(){};

        JavaMapToFieldsTransform(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Schema inputSchema = input.get(JavaMapToFieldsTransformProvider.INPUT_ROWS_TAG).getSchema();
            Schema.Builder outputSchemaBuilder = new Schema.Builder();
            boolean append = this.configuration.getAppend() != null && this.configuration.getAppend() != false;
            List toDrop = this.configuration.getDrop() == null ? Collections.emptyList() : this.configuration.getDrop();
            ArrayList<JavaRowUdf> udfs = new ArrayList<JavaRowUdf>();
            if (append) {
                for (Schema.Field field : inputSchema.getFields()) {
                    if (toDrop.contains(field.getName())) continue;
                    try {
                        udfs.add(new JavaRowUdf(JavaRowUdf.Configuration.builder().setExpression(field.getName()).build(), inputSchema));
                    }
                    catch (ReflectiveOperationException | MalformedURLException | StringCompiler.CompileException exn) {
                        throw new RuntimeException(exn);
                    }
                    outputSchemaBuilder = outputSchemaBuilder.addField(field);
                }
            }
            for (Map.Entry entry : this.configuration.getFields().entrySet()) {
                String expr;
                if (!("java".equals(this.configuration.getLanguage()) || (expr = ((JavaRowUdf.Configuration)entry.getValue()).getExpression()) != null && inputSchema.hasField(expr))) {
                    throw new IllegalArgumentException("Unknown field or missing language specification for '" + (String)entry.getKey() + "'");
                }
                try {
                    JavaRowUdf udf = new JavaRowUdf((JavaRowUdf.Configuration)entry.getValue(), inputSchema);
                    udfs.add(udf);
                    outputSchemaBuilder = outputSchemaBuilder.addField((String)entry.getKey(), udf.getOutputType());
                }
                catch (ReflectiveOperationException | MalformedURLException | StringCompiler.CompileException exn) {
                    throw new RuntimeException(exn);
                }
            }
            Schema outputSchema = outputSchemaBuilder.build();
            boolean bl = ErrorHandling.hasOutput(this.configuration.getErrorHandling());
            Schema errorSchema = ErrorHandling.errorSchema(inputSchema);
            PCollectionTuple pcolls = (PCollectionTuple)((Object)input.get(JavaMapToFieldsTransformProvider.INPUT_ROWS_TAG).apply("MapToFields", ParDo.of(JavaMapToFieldsTransform.createDoFn(udfs, outputSchema, errorSchema, bl)).withOutputTags(mappedValues, TupleTagList.of(errorValues))));
            pcolls.get(mappedValues).setRowSchema(outputSchema);
            pcolls.get(errorValues).setRowSchema(errorSchema);
            PCollectionRowTuple result = PCollectionRowTuple.of(JavaMapToFieldsTransformProvider.OUTPUT_ROWS_TAG, pcolls.get(mappedValues));
            if (bl) {
                result = result.and(this.configuration.getErrorHandling().getOutput(), pcolls.get(errorValues));
            }
            return result;
        }

        private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> createDoFn(final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized JavaRowUdf> udfs, final @UnknownKeyFor @NonNull @Initialized Schema outputSchema, final @UnknownKeyFor @NonNull @Initialized Schema errorSchema, final @UnknownKeyFor @NonNull @Initialized boolean handleErrors) {
            return new DoFn<Row, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver out) {
                    Row outputRow;
                    try {
                        Row.Builder builder = Row.withSchema(outputSchema);
                        for (JavaRowUdf udf : udfs) {
                            builder.addValue(udf.getFunction().apply(inputRow));
                        }
                        outputRow = builder.build();
                    }
                    catch (Exception exn) {
                        if (handleErrors) {
                            out.get(errorValues).output(ErrorHandling.errorRecord(errorSchema, inputRow, (Throwable)exn));
                            outputRow = null;
                        }
                        throw new RuntimeException(exn);
                    }
                    if (outputRow != null) {
                        out.get(mappedValues).output(outputRow);
                    }
                }
            };
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getLanguage();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Boolean getAppend();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDrop();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JavaRowUdf.Configuration> getFields();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized ErrorHandling getErrorHandling();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JavaMapToFieldsTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLanguage(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setAppend(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDrop(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFields(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JavaRowUdf.Configuration> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

