/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSourceTransform;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadAllViaFileBasedSourceWithFilename<@UnknownKeyFor T>
extends ReadAllViaFileBasedSourceTransform<T, KV<String, T>> {
    public ReadAllViaFileBasedSourceWithFilename(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, T>> coder) {
        super(desiredBundleSizeBytes, createSource, coder);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV< @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile, @UnknownKeyFor @NonNull @Initialized OffsetRange>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, T>> readRangesFn() {
        return new ReadFileRangesFn(this.createSource, this.exceptionHandler);
    }

    private static class ReadFileRangesFn<@UnknownKeyFor T>
    extends ReadAllViaFileBasedSourceTransform.AbstractReadFileRangesFn<T, KV<String, T>> {
        public ReadFileRangesFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource,  @UnknownKeyFor @NonNull @Initialized ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler exceptionHandler) {
            super(createSource, exceptionHandler);
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, T> makeOutput( @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> fileBasedSource,  @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> reader) {
            return KV.of(file.getMetadata().resourceId().toString(), reader.getCurrent());
        }
    }
}

