/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.core.metrics.AutoValue_StringSetData;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class StringSetData
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> stringSet();

    public static @UnknownKeyFor @NonNull @Initialized StringSetData create(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> set) {
        return new AutoValue_StringSetData((Set<String>)ImmutableSet.copyOf(set));
    }

    public static @UnknownKeyFor @NonNull @Initialized StringSetData empty() {
        return EmptyStringSetData.INSTANCE;
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetData combine(@UnknownKeyFor @NonNull @Initialized StringSetData other) {
        if (this.stringSet().isEmpty()) {
            return other;
        }
        if (other.stringSet().isEmpty()) {
            return this;
        }
        ImmutableSet.Builder combined = ImmutableSet.builder();
        combined.addAll(this.stringSet());
        combined.addAll(other.stringSet());
        return StringSetData.create((Set<String>)combined.build());
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetData combine(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StringSetData> others) {
        Set<String> combined = StreamSupport.stream(others.spliterator(), true).flatMap(other -> other.stringSet().stream()).collect(Collectors.toSet());
        combined.addAll(this.stringSet());
        return StringSetData.create(combined);
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetResult extractResult() {
        return StringSetResult.create(this.stringSet());
    }

    public static class EmptyStringSetData
    extends StringSetData {
        private static final @UnknownKeyFor @NonNull @Initialized EmptyStringSetData INSTANCE = new EmptyStringSetData();

        private EmptyStringSetData() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> stringSet() {
            return ImmutableSet.of();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StringSetResult extractResult() {
            return StringSetResult.empty();
        }
    }
}

