/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public abstract class PValueBase
implements PValue {
    private final transient @Nullable @UnknownKeyFor @Initialized Pipeline pipeline;
    private @Nullable @UnknownKeyFor @Initialized String name;
    private @UnknownKeyFor @NonNull @Initialized boolean finishedSpecifying = false;

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        if (this.name == null) {
            throw new IllegalStateException("name not set");
        }
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized PValueBase setName(@UnknownKeyFor @NonNull @Initialized String name) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!this.finishedSpecifying ? 1 : 0) != 0, (String)"cannot change the name of %s once it's been used", (Object)this);
        this.name = name;
        return this;
    }

    protected PValueBase(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected PValueBase() {
        this.pipeline = null;
    }

    @UnknownKeyFor @NonNull @Initialized boolean isFinishedSpecifying() {
        return this.finishedSpecifying;
    }

    @Override
    public void finishSpecifying(@UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        this.finishedSpecifying = true;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return (this.name == null ? "<unnamed>" : this.getName()) + " [" + this.getKindString() + "@" + this.hashCode() + "]";
    }

    protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
        return NameUtils.approximateSimpleName(this.getClass());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return Preconditions.checkStateNotNull(this.pipeline, "Pipeline was null for %s. this probably means it was used as a %s after being deserialized, which not unsupported.", (Object)this.getClass().getCanonicalName(), (Object)PValue.class.getSimpleName());
    }

    @Override
    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        if (this.name == null) {
            this.setName(PValueBase.defaultName(transformName));
        }
    }

    static @UnknownKeyFor @NonNull @Initialized String defaultName(@UnknownKeyFor @NonNull @Initialized String transformName) {
        return String.format("%s.%s", transformName, "out");
    }
}

