/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DelegatingGauge
implements Metric,
Gauge,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;
    private final @UnknownKeyFor @NonNull @Initialized boolean processWideContainer;
    private final @UnknownKeyFor @NonNull @Initialized boolean perWorkerGauge;

    public DelegatingGauge(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this(name, false, false);
    }

    public DelegatingGauge(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer) {
        this(name, processWideContainer, false);
    }

    public DelegatingGauge(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer, @UnknownKeyFor @NonNull @Initialized boolean perWorkerGauge) {
        this.name = name;
        this.processWideContainer = processWideContainer;
        this.perWorkerGauge = perWorkerGauge;
    }

    @Override
    public void set(@UnknownKeyFor @NonNull @Initialized long n) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container == null) {
            return;
        }
        if (this.perWorkerGauge) {
            container.getPerWorkerGauge(this.name).set(n);
        } else {
            container.getGauge(this.name).set(n);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }
}

