/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSourceTransform;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadAllViaFileBasedSource<@UnknownKeyFor T>
extends ReadAllViaFileBasedSourceTransform<T, T> {
    public ReadAllViaFileBasedSource(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        super(desiredBundleSizeBytes, createSource, coder, true, new ReadFileRangesFnExceptionHandler());
    }

    public ReadAllViaFileBasedSource(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized boolean usesReshuffle, @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler) {
        super(desiredBundleSizeBytes, createSource, coder, usesReshuffle, exceptionHandler);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV< @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile, @UnknownKeyFor @NonNull @Initialized OffsetRange>, T> readRangesFn() {
        return new ReadFileRangesFn(this.createSource, this.exceptionHandler);
    }

    public static class ReadFileRangesFnExceptionHandler
    implements Serializable {
        public @UnknownKeyFor @NonNull @Initialized boolean apply( @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized Exception e) {
            return true;
        }
    }

    private static class ReadFileRangesFn<@UnknownKeyFor T>
    extends ReadAllViaFileBasedSourceTransform.AbstractReadFileRangesFn<T, T> {
        public ReadFileRangesFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> createSource, @UnknownKeyFor @NonNull @Initialized ReadFileRangesFnExceptionHandler exceptionHandler) {
            super(createSource, exceptionHandler);
        }

        @Override
        protected T makeOutput( @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile file, @UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> fileBasedSource,  @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> reader) {
            return reader.getCurrent();
        }
    }
}

