/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.Instant;
import org.apache.beam.sdk.schemas.logicaltypes.NanosType;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NanosInstant
extends NanosType<Instant> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:logical_type:nanos_instant:v1";

    public NanosInstant() {
        super(IDENTIFIER);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized Instant input) {
        return Row.withSchema(this.schema).addValues(input.getEpochSecond(), input.getNano()).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant toInputType(@UnknownKeyFor @NonNull @Initialized Row row) {
        return Instant.ofEpochSecond(Preconditions.checkArgumentNotNull(row.getInt64(0), "While trying to convert to Instant: Row missing seconds field"), Preconditions.checkArgumentNotNull(row.getInt32(1), "While traying to convert to Instant: Row missing nanos field").intValue());
    }
}

