/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnOutputReceivers;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.OutputBuilderSupplier;
import org.apache.beam.sdk.util.OutputBuilderSuppliers;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DoFnTester<InputT, OutputT>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DoFnTester.class);
    private final PipelineOptions options = PipelineOptionsFactory.create();
    private final DoFn<InputT, OutputT> origFn;
    private CloningBehavior cloningBehavior = CloningBehavior.CLONE_ONCE;
    private Map<PCollectionView<?>, Map<BoundedWindow, ?>> sideInputs = new HashMap();
    private TupleTag<OutputT> mainOutputTag = new TupleTag();
    private @Nullable DoFn<InputT, OutputT> fn;
    private @Nullable DoFnInvoker<InputT, OutputT> fnInvoker;
    @CheckForNull
    private Map<TupleTag<?>, List<ValueInSingleWindow<?>>> outputs;
    private State state = State.UNINITIALIZED;

    @Deprecated
    public static <InputT, OutputT> DoFnTester<InputT, OutputT> of(DoFn<InputT, OutputT> fn) {
        Preconditions.checkNotNull(fn, (Object)"fn can't be null");
        LOG.warn("Your tests use DoFnTester, which may not exercise DoFns correctly. Please use TestPipeline instead.");
        return new DoFnTester<InputT, OutputT>(fn);
    }

    @Deprecated
    public void setSideInputs(Map<PCollectionView<?>, Map<BoundedWindow, ?>> sideInputs) {
        Preconditions.checkState((this.state == State.UNINITIALIZED ? 1 : 0) != 0, (String)"Can't add side inputs: DoFnTester is already initialized, in state %s", (Object)((Object)this.state));
        this.sideInputs = sideInputs;
    }

    @Deprecated
    public <T> void setSideInput(PCollectionView<T> sideInput, BoundedWindow window, T value) {
        Preconditions.checkState((this.state == State.UNINITIALIZED ? 1 : 0) != 0, (String)"Can't add side inputs: DoFnTester is already initialized, in state %s", (Object)((Object)this.state));
        Map<BoundedWindow, ?> windowValues = this.sideInputs.get(sideInput);
        if (windowValues == null) {
            windowValues = new HashMap();
            this.sideInputs.put(sideInput, windowValues);
        }
        windowValues.put(window, value);
    }

    @Deprecated
    public PipelineOptions getPipelineOptions() {
        return this.options;
    }

    @Deprecated
    public void setCloningBehavior(CloningBehavior newValue) {
        Preconditions.checkState((this.state == State.UNINITIALIZED ? 1 : 0) != 0, (String)"Wrong state: %s", (Object)((Object)this.state));
        this.cloningBehavior = newValue;
    }

    @Deprecated
    public CloningBehavior getCloningBehavior() {
        return this.cloningBehavior;
    }

    @Deprecated
    public List<OutputT> processBundle(Iterable<? extends InputT> inputElements) throws Exception {
        this.startBundle();
        for (InputT inputElement : inputElements) {
            this.processElement(inputElement);
        }
        this.finishBundle();
        return this.takeOutputElements();
    }

    @Deprecated
    @SafeVarargs
    public final List<OutputT> processBundle(InputT ... inputElements) throws Exception {
        return this.processBundle((Iterable<? extends InputT>)Arrays.asList(inputElements));
    }

    @Deprecated
    public void startBundle() throws Exception {
        Preconditions.checkState((this.state == State.UNINITIALIZED || this.state == State.BUNDLE_FINISHED ? 1 : 0) != 0, (String)"Wrong state during startBundle: %s", (Object)((Object)this.state));
        if (this.state == State.UNINITIALIZED) {
            this.initializeState();
        }
        try {
            this.fnInvoker.invokeStartBundle(new TestStartBundleContext());
        }
        catch (UserCodeException e) {
            DoFnTester.unwrapUserCodeException(e);
        }
        this.state = State.BUNDLE_STARTED;
    }

    private static void unwrapUserCodeException(UserCodeException e) throws Exception {
        if (e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        throw e;
    }

    @Deprecated
    public void processElement(InputT element) throws Exception {
        this.processTimestampedElement(TimestampedValue.atMinimumTimestamp(element));
    }

    @Deprecated
    public void processTimestampedElement(TimestampedValue<InputT> element) throws Exception {
        Preconditions.checkNotNull(element, (Object)"Timestamped element cannot be null");
        this.processWindowedElement(element.getValue(), element.getTimestamp(), GlobalWindow.INSTANCE);
    }

    @Deprecated
    public void processWindowedElement(InputT element, Instant timestamp, final BoundedWindow window) throws Exception {
        if (this.state != State.BUNDLE_STARTED) {
            this.startBundle();
        }
        try {
            ValueInSingleWindow<InputT> templateElement = ValueInSingleWindow.of(element, timestamp, window, PaneInfo.NO_FIRING);
            WindowedValue<InputT> templateWv = WindowedValues.of(element, timestamp, window, PaneInfo.NO_FIRING);
            final DoFn.ProcessContext processContext = this.createProcessContext(templateElement);
            final OutputBuilderSupplier builderSupplier = OutputBuilderSuppliers.supplierForElement(templateWv);
            this.fnInvoker.invokeProcessElement(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public String getErrorContext() {
                    return "DoFnTester";
                }

                @Override
                public BoundedWindow window() {
                    return window;
                }

                @Override
                public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                    return processContext.pane();
                }

                @Override
                public PipelineOptions pipelineOptions() {
                    return DoFnTester.this.getPipelineOptions();
                }

                @Override
                public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                    throw new UnsupportedOperationException("Not expected to access DoFn.StartBundleContext from @ProcessElement");
                }

                @Override
                public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                    throw new UnsupportedOperationException("Not expected to access DoFn.FinishBundleContext from @ProcessElement");
                }

                @Override
                public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
                    return processContext;
                }

                @Override
                public InputT element(DoFn<InputT, OutputT> doFn) {
                    return processContext.element();
                }

                @Override
                public Object key() {
                    throw new UnsupportedOperationException("Cannot access key as parameter outside of @OnTimer method.");
                }

                @Override
                public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                    return processContext.timestamp();
                }

                @Override
                public String timerId(DoFn<InputT, OutputT> doFn) {
                    throw new UnsupportedOperationException("Cannot access timerId as parameter outside of @OnTimer method.");
                }

                @Override
                public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
                    throw new UnsupportedOperationException("Not expected to access TimeDomain from @ProcessElement");
                }

                @Override
                public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
                    return DoFnOutputReceivers.windowedReceiver(processContext, builderSupplier, null);
                }

                @Override
                public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
                    return DoFnOutputReceivers.windowedMultiReceiver(processContext, builderSupplier, null);
                }

                @Override
                public Object restriction() {
                    throw new UnsupportedOperationException("Not expected to access Restriction from a regular DoFn in DoFnTester");
                }

                @Override
                public RestrictionTracker<?, ?> restrictionTracker() {
                    throw new UnsupportedOperationException("Not expected to access RestrictionTracker from a regular DoFn in DoFnTester");
                }
            });
        }
        catch (UserCodeException e) {
            DoFnTester.unwrapUserCodeException(e);
        }
    }

    @Deprecated
    public void finishBundle() throws Exception {
        Preconditions.checkState((this.state == State.BUNDLE_STARTED ? 1 : 0) != 0, (String)"Must be inside bundle to call finishBundle, but was: %s", (Object)((Object)this.state));
        try {
            this.fnInvoker.invokeFinishBundle(new TestFinishBundleContext());
        }
        catch (UserCodeException e) {
            DoFnTester.unwrapUserCodeException(e);
        }
        if (this.cloningBehavior == CloningBehavior.CLONE_PER_BUNDLE) {
            this.fnInvoker.invokeTeardown();
            this.fn = null;
            this.fnInvoker = null;
            this.state = State.UNINITIALIZED;
        } else {
            this.state = State.BUNDLE_FINISHED;
        }
    }

    @Deprecated
    public List<OutputT> peekOutputElements() {
        return this.peekOutputElementsWithTimestamp().stream().map(TimestampedValue::getValue).collect(Collectors.toList());
    }

    @Deprecated
    public List<TimestampedValue<OutputT>> peekOutputElementsWithTimestamp() {
        return this.getImmutableOutput(this.mainOutputTag).stream().map(input -> TimestampedValue.of(input.getValue(), input.getTimestamp())).collect(Collectors.toList());
    }

    @Deprecated
    public List<TimestampedValue<OutputT>> peekOutputElementsInWindow(BoundedWindow window) {
        return this.peekOutputElementsInWindow(this.mainOutputTag, window);
    }

    @Deprecated
    public List<TimestampedValue<OutputT>> peekOutputElementsInWindow(TupleTag<OutputT> tag, BoundedWindow window) {
        ImmutableList.Builder valuesBuilder = ImmutableList.builder();
        for (ValueInSingleWindow<OutputT> value : this.getImmutableOutput(tag)) {
            if (!value.getWindow().equals(window)) continue;
            valuesBuilder.add(TimestampedValue.of(value.getValue(), value.getTimestamp()));
        }
        return valuesBuilder.build();
    }

    @Deprecated
    public void clearOutputElements() {
        this.getMutableOutput(this.mainOutputTag).clear();
    }

    @Deprecated
    public List<OutputT> takeOutputElements() {
        ArrayList<OutputT> resultElems = new ArrayList<OutputT>(this.peekOutputElements());
        this.clearOutputElements();
        return resultElems;
    }

    @Deprecated
    public List<TimestampedValue<OutputT>> takeOutputElementsWithTimestamp() {
        ArrayList<TimestampedValue<OutputT>> resultElems = new ArrayList<TimestampedValue<OutputT>>(this.peekOutputElementsWithTimestamp());
        this.clearOutputElements();
        return resultElems;
    }

    @Deprecated
    public <T> List<T> peekOutputElements(TupleTag<T> tag) {
        return this.getImmutableOutput(tag).stream().map(ValueInSingleWindow::getValue).collect(Collectors.toList());
    }

    @Deprecated
    public <T> void clearOutputElements(TupleTag<T> tag) {
        this.getMutableOutput(tag).clear();
    }

    @Deprecated
    public <T> List<T> takeOutputElements(TupleTag<T> tag) {
        ArrayList<T> resultElems = new ArrayList<T>(this.peekOutputElements(tag));
        this.clearOutputElements(tag);
        return resultElems;
    }

    private <T> List<ValueInSingleWindow<T>> getImmutableOutput(TupleTag<T> tag) {
        List elems = (List)this.getOutputs().get(tag);
        return ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)elems, Collections.emptyList())));
    }

    @Deprecated
    public <T> List<ValueInSingleWindow<T>> getMutableOutput(TupleTag<T> tag) {
        ArrayList outputList = (ArrayList)this.getOutputs().get(tag);
        if (outputList == null) {
            outputList = new ArrayList();
            this.getOutputs().put(tag, outputList);
        }
        return outputList;
    }

    @Deprecated
    public TupleTag<OutputT> getMainOutputTag() {
        return this.mainOutputTag;
    }

    @Deprecated
    public DoFn.ProcessContext createProcessContext(ValueInSingleWindow<InputT> element) {
        return new TestProcessContext(element);
    }

    @Override
    @Deprecated
    public void close() throws Exception {
        if (this.state == State.BUNDLE_STARTED) {
            this.finishBundle();
        }
        if (this.state == State.BUNDLE_FINISHED) {
            this.fnInvoker.invokeTeardown();
            this.fn = null;
            this.fnInvoker = null;
        }
        this.state = State.TORN_DOWN;
    }

    private DoFnTester(DoFn<InputT, OutputT> origFn) {
        this.origFn = origFn;
        DoFnSignature signature = DoFnSignatures.signatureForDoFn(origFn);
        for (DoFnSignature.Parameter param : signature.processElement().extraParameters()) {
            param.match(new DoFnSignature.Parameter.Cases.WithDefault<Void>(){

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.ProcessContextParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.WindowParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.ElementParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.TimestampParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.TimeDomainParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.OutputReceiverParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.TaggedOutputReceiverParameter p) {
                    return null;
                }

                @Override
                public @Nullable Void dispatch(DoFnSignature.Parameter.PaneInfoParameter p) {
                    return null;
                }

                @Override
                public Void dispatch(DoFnSignature.Parameter.TimerIdParameter p) {
                    return null;
                }

                @Override
                protected Void dispatchDefault(DoFnSignature.Parameter p) {
                    throw new UnsupportedOperationException("Parameter " + p + " not supported by DoFnTester");
                }
            });
        }
    }

    private void initializeState() throws Exception {
        Preconditions.checkState((this.state == State.UNINITIALIZED ? 1 : 0) != 0, (Object)"Already initialized");
        Preconditions.checkState((this.fn == null ? 1 : 0) != 0, (Object)"Uninitialized but fn != null");
        this.fn = this.cloningBehavior.equals((Object)CloningBehavior.DO_NOT_CLONE) ? this.origFn : (DoFn)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(this.origFn), this.origFn.toString());
        this.fnInvoker = DoFnInvokers.invokerFor(this.fn);
        this.fnInvoker.invokeSetup(new TestSetupArgumentProvider());
    }

    private Map getOutputs() {
        if (this.outputs == null) {
            this.outputs = new HashMap();
        }
        return this.outputs;
    }

    private class TestSetupArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private TestSetupArgumentProvider() {
        }

        @Override
        public PipelineOptions pipelineOptions() {
            return DoFnTester.this.options;
        }

        @Override
        public String getErrorContext() {
            return "DoFnTester/Setup";
        }
    }

    private static enum State {
        UNINITIALIZED,
        BUNDLE_STARTED,
        BUNDLE_FINISHED,
        TORN_DOWN;

    }

    private class TestProcessContext
    extends DoFn.ProcessContext {
        private final ValueInSingleWindow<InputT> element;

        private TestProcessContext(ValueInSingleWindow<InputT> element) {
            this.element = element;
        }

        @Override
        public InputT element() {
            return this.element.getValue();
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            Object sideInputWindow;
            Object windowValue;
            Map viewValues = (Map)DoFnTester.this.sideInputs.get(view);
            if (viewValues != null && (windowValue = viewValues.get(sideInputWindow = view.getWindowMappingFn().getSideInputWindow(this.element.getWindow()))) != null) {
                return (T)windowValue;
            }
            switch (view.getViewFn().getMaterialization().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    return view.getViewFn().apply(() -> Collections.emptyList());
                }
                case "beam:side_input:multimap:v1": {
                    return view.getViewFn().apply(new Materializations.MultimapView(){

                        public Iterable get() {
                            return Collections.emptyList();
                        }

                        public Iterable get(@Nullable Object o) {
                            return Collections.emptyList();
                        }
                    });
                }
            }
            throw new IllegalStateException(String.format("Only materializations of type %s supported, received %s", Arrays.asList("beam:side_input:iterable:v1", "beam:side_input:multimap:v1"), view.getViewFn().getMaterialization().getUrn()));
        }

        @Override
        public Instant timestamp() {
            return this.element.getTimestamp();
        }

        @Override
        public PaneInfo pane() {
            return this.element.getPaneInfo();
        }

        @Override
        public String currentRecordId() {
            return this.element.getCurrentRecordId();
        }

        @Override
        public Long currentRecordOffset() {
            return this.element.getCurrentRecordOffset();
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            return DoFnTester.this.options;
        }

        @Override
        public void output(OutputT output) {
            this.output(DoFnTester.this.mainOutputTag, output);
        }

        @Override
        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.outputWithTimestamp(DoFnTester.this.mainOutputTag, output, timestamp);
        }

        @Override
        public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            this.outputWindowedValue(DoFnTester.this.mainOutputTag, output, timestamp, windows, paneInfo);
        }

        @Override
        public <T> void output(TupleTag<T> tag, T output) {
            this.outputWithTimestamp(tag, output, this.element.getTimestamp());
        }

        @Override
        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            DoFnTester.this.getMutableOutput(tag).add(ValueInSingleWindow.of(output, timestamp, this.element.getWindow(), this.element.getPaneInfo(), null, null));
        }

        @Override
        public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            for (BoundedWindow boundedWindow : windows) {
                DoFnTester.this.getMutableOutput(tag).add(ValueInSingleWindow.of(output, timestamp, boundedWindow, paneInfo, null, null));
            }
        }
    }

    private class TestFinishBundleContext
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private TestFinishBundleContext() {
        }

        @Override
        public DoFn.FinishBundleContext finishBundleContext(DoFn doFn) {
            return new DoFn.FinishBundleContext(DoFnTester.this.fn){

                @Override
                public PipelineOptions getPipelineOptions() {
                    return DoFnTester.this.options;
                }

                @Override
                public void output(OutputT output, Instant timestamp, BoundedWindow window) {
                    this.output(DoFnTester.this.mainOutputTag, output, timestamp, window);
                }

                @Override
                public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
                    DoFnTester.this.getMutableOutput(tag).add(ValueInSingleWindow.of(output, timestamp, window, PaneInfo.NO_FIRING, null, null));
                }
            };
        }

        @Override
        public PipelineOptions pipelineOptions() {
            return DoFnTester.this.options;
        }

        @Override
        public String getErrorContext() {
            return "DoFnTester/FinishBundle";
        }
    }

    private class TestStartBundleContext
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private TestStartBundleContext() {
        }

        @Override
        public DoFn.StartBundleContext startBundleContext(DoFn doFn) {
            return new DoFn.StartBundleContext(DoFnTester.this.fn){

                @Override
                public PipelineOptions getPipelineOptions() {
                    return DoFnTester.this.options;
                }
            };
        }

        @Override
        public PipelineOptions pipelineOptions() {
            return DoFnTester.this.options;
        }

        @Override
        public String getErrorContext() {
            return "DoFnTester/StartBundle";
        }
    }

    @Deprecated
    public static enum CloningBehavior {
        CLONE_PER_BUNDLE,
        CLONE_ONCE,
        DO_NOT_CLONE;

    }
}

