/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformInputs;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1_13_1.com.google.protobuf.ByteString;

public class CombineTranslation {
    public static final String JAVA_SERIALIZED_COMBINE_FN_URN = "urn:beam:combinefn:javasdk:v1";

    static <K, InputT, OutputT> RunnerApi.CombinePayload payloadForCombine(AppliedPTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>, Combine.PerKey<K, InputT, OutputT>> combine, SdkComponents components) throws IOException {
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(components.registerCoder(CombineTranslation.extractAccumulatorCoder(combineFn, combine))).setCombineFn(RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)((Combine.PerKey)combine.getTransform()).getFn()))).build()).build()).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static RunnerApi.CombinePayload toProto(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> combine, SdkComponents sdkComponents) throws IOException {
        Preconditions.checkArgument(((Combine.PerKey)combine.getTransform()).getSideInputs().isEmpty(), "CombineTranslation.toProto cannot translate Combines with side inputs.");
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            Coder accumulatorCoder = CombineTranslation.extractAccumulatorCoder(combineFn, combine);
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(sdkComponents.registerCoder(accumulatorCoder)).setCombineFn(CombineTranslation.toProto(combineFn, sdkComponents)).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws CannotProvideCoderException {
        PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
        KvCoder inputCoder = (KvCoder)mainInput.getCoder();
        return AppliedCombineFn.withInputCoder(combineFn, (CoderRegistry)transform.getPipeline().getCoderRegistry(), (KvCoder)inputCoder, (Iterable)((Combine.PerKey)transform.getTransform()).getSideInputs(), (WindowingStrategy)((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getWindowingStrategy()).getAccumulatorCoder();
    }

    public static RunnerApi.SdkFunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(combineFn))).build()).build();
    }

    public static class CombinePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        private CombinePayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.PerKey<?, ?, ?> transform) {
            return PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> transform, SdkComponents components) throws IOException {
            if (((Combine.PerKey)transform.getTransform()).getSideInputs().isEmpty()) {
                return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN).setPayload(CombineTranslation.payloadForCombine(transform, components).toByteString()).build();
            }
            return null;
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(Combine.PerKey.class, new CombinePayloadTranslator());
            }
        }
    }
}

