/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.grpc.v1_13_1.com.google.protobuf.ByteString;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TestStreamTranslation {
    private static TestStream<?> testStreamFromProtoPayload(RunnerApi.TestStreamPayload testStreamPayload, RehydratedComponents components) throws IOException {
        Coder<?> coder = components.getCoder(testStreamPayload.getCoderId());
        ArrayList events = new ArrayList();
        for (RunnerApi.TestStreamPayload.Event event : testStreamPayload.getEventsList()) {
            events.add(TestStreamTranslation.eventFromProto(event, coder));
        }
        return TestStream.fromRawEvents(coder, events);
    }

    public static <T> TestStream<T> getTestStream(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> application) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform transformProto = PTransformTranslation.toProto(application, sdkComponents);
        Preconditions.checkArgument(PTransformTranslation.TEST_STREAM_TRANSFORM_URN.equals(transformProto.getSpec().getUrn()), "Attempt to get %s from a transform with wrong URN %s", (Object)TestStream.class.getSimpleName(), (Object)transformProto.getSpec().getUrn());
        RunnerApi.TestStreamPayload testStreamPayload = RunnerApi.TestStreamPayload.parseFrom((ByteString)transformProto.getSpec().getPayload());
        return TestStreamTranslation.testStreamFromProtoPayload(testStreamPayload, RehydratedComponents.forComponents(sdkComponents.toComponents()));
    }

    static <T> RunnerApi.TestStreamPayload.Event eventToProto(TestStream.Event<T> event, Coder<T> coder) throws IOException {
        switch (event.getType()) {
            case WATERMARK: {
                return RunnerApi.TestStreamPayload.Event.newBuilder().setWatermarkEvent(RunnerApi.TestStreamPayload.Event.AdvanceWatermark.newBuilder().setNewWatermark(((TestStream.WatermarkEvent)event).getWatermark().getMillis())).build();
            }
            case PROCESSING_TIME: {
                return RunnerApi.TestStreamPayload.Event.newBuilder().setProcessingTimeEvent(RunnerApi.TestStreamPayload.Event.AdvanceProcessingTime.newBuilder().setAdvanceDuration(((TestStream.ProcessingTimeEvent)event).getProcessingTimeAdvance().getMillis())).build();
            }
            case ELEMENT: {
                RunnerApi.TestStreamPayload.Event.AddElements.Builder builder = RunnerApi.TestStreamPayload.Event.AddElements.newBuilder();
                for (TimestampedValue element : ((TestStream.ElementEvent)event).getElements()) {
                    builder.addElements(RunnerApi.TestStreamPayload.TimestampedElement.newBuilder().setTimestamp(element.getTimestamp().getMillis()).setEncodedElement(ByteString.copyFrom((byte[])CoderUtils.encodeToByteArray(coder, (Object)element.getValue()))));
                }
                return RunnerApi.TestStreamPayload.Event.newBuilder().setElementEvent(builder).build();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type of %s: %s", TestStream.Event.class.getCanonicalName(), event.getType()));
    }

    static <T> TestStream.Event<T> eventFromProto(RunnerApi.TestStreamPayload.Event protoEvent, Coder<T> coder) throws IOException {
        switch (protoEvent.getEventCase()) {
            case WATERMARK_EVENT: {
                return TestStream.WatermarkEvent.advanceTo((Instant)new Instant(protoEvent.getWatermarkEvent().getNewWatermark()));
            }
            case PROCESSING_TIME_EVENT: {
                return TestStream.ProcessingTimeEvent.advanceBy((Duration)Duration.millis((long)protoEvent.getProcessingTimeEvent().getAdvanceDuration()));
            }
            case ELEMENT_EVENT: {
                ArrayList<TimestampedValue> decodedElements = new ArrayList<TimestampedValue>();
                for (RunnerApi.TestStreamPayload.TimestampedElement element : protoEvent.getElementEvent().getElementsList()) {
                    decodedElements.add(TimestampedValue.of((Object)CoderUtils.decodeFromByteArray(coder, (byte[])element.getEncodedElement().toByteArray()), (Instant)new Instant(element.getTimestamp())));
                }
                return TestStream.ElementEvent.add(decodedElements);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type of %s: %s", RunnerApi.TestStreamPayload.Event.class.getCanonicalName(), protoEvent.getEventCase()));
    }

    static <T> RunnerApi.TestStreamPayload payloadForTestStream(TestStream<T> transform, SdkComponents components) throws IOException {
        ArrayList<RunnerApi.TestStreamPayload.Event> protoEvents = new ArrayList<RunnerApi.TestStreamPayload.Event>();
        try {
            for (TestStream.Event event : transform.getEvents()) {
                protoEvents.add(TestStreamTranslation.eventToProto(event, transform.getValueCoder()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return RunnerApi.TestStreamPayload.newBuilder().setCoderId(components.registerCoder(transform.getValueCoder())).addAllEvents(protoEvents).build();
    }

    static class TestStreamTranslator
    implements PTransformTranslation.TransformPayloadTranslator<TestStream<?>> {
        TestStreamTranslator() {
        }

        @Override
        public String getUrn(TestStream<?> transform) {
            return PTransformTranslation.TEST_STREAM_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, TestStream<?>> transform, SdkComponents components) throws IOException {
            return this.translateTyped((TestStream)transform.getTransform(), components);
        }

        private <T> RunnerApi.FunctionSpec translateTyped(TestStream<T> testStream, SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.TEST_STREAM_TRANSFORM_URN).setPayload(TestStreamTranslation.payloadForTestStream(testStream, components).toByteString()).build();
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(TestStream.class, new TestStreamTranslator());
            }
        }
    }
}

