/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.GreedyPCollectionFusers;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.ImmutableExecutableStage;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.SideInputReference;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.TimerReference;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.UserStateReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyStageFuser {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyStageFuser.class);

    private GreedyStageFuser() {
    }

    public static ExecutableStage forGrpcPortRead(QueryablePipeline pipeline, PipelineNode.PCollectionNode inputPCollection, Set<PipelineNode.PTransformNode> initialNodes) {
        Preconditions.checkArgument(!initialNodes.isEmpty(), "%s must contain at least one %s.", (Object)GreedyStageFuser.class.getSimpleName(), (Object)PipelineNode.PTransformNode.class.getSimpleName());
        RunnerApi.Environment environment = GreedyStageFuser.getStageEnvironment(pipeline, initialNodes);
        ImmutableSet.Builder fusedTransforms = ImmutableSet.builder();
        fusedTransforms.addAll(initialNodes);
        LinkedHashSet<SideInputReference> sideInputs = new LinkedHashSet<SideInputReference>();
        LinkedHashSet<UserStateReference> userStates = new LinkedHashSet<UserStateReference>();
        LinkedHashSet<TimerReference> timers = new LinkedHashSet<TimerReference>();
        LinkedHashSet<PipelineNode.PCollectionNode> fusedCollections = new LinkedHashSet<PipelineNode.PCollectionNode>();
        LinkedHashSet<PipelineNode.PCollectionNode> materializedPCollections = new LinkedHashSet<PipelineNode.PCollectionNode>();
        ArrayDeque<PipelineNode.PCollectionNode> fusionCandidates = new ArrayDeque<PipelineNode.PCollectionNode>();
        for (PipelineNode.PTransformNode initialConsumer : initialNodes) {
            fusionCandidates.addAll(pipeline.getOutputPCollections(initialConsumer));
            sideInputs.addAll(pipeline.getSideInputs(initialConsumer));
            userStates.addAll(pipeline.getUserStates(initialConsumer));
            timers.addAll(pipeline.getTimers(initialConsumer));
        }
        block5: while (!fusionCandidates.isEmpty()) {
            PipelineNode.PCollectionNode candidate = (PipelineNode.PCollectionNode)fusionCandidates.poll();
            if (fusedCollections.contains(candidate) || materializedPCollections.contains(candidate)) {
                LOG.debug("Skipping fusion candidate {} because it is {} in this {}", new Object[]{candidate, fusedCollections.contains(candidate) ? "fused" : "materialized", ExecutableStage.class.getSimpleName()});
                continue;
            }
            PCollectionFusibility fusibility = GreedyStageFuser.canFuse(pipeline, candidate, environment, fusedCollections);
            switch (fusibility) {
                case MATERIALIZE: {
                    materializedPCollections.add(candidate);
                    break;
                }
                case FUSE: {
                    fusedCollections.add(candidate);
                    fusedTransforms.addAll(pipeline.getPerElementConsumers(candidate));
                    for (PipelineNode.PTransformNode consumer : pipeline.getPerElementConsumers(candidate)) {
                        fusionCandidates.addAll(pipeline.getOutputPCollections(consumer));
                        sideInputs.addAll(pipeline.getSideInputs(consumer));
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown type of %s %s", new Object[]{PCollectionFusibility.class.getSimpleName(), fusibility}));
                }
            }
        }
        return ImmutableExecutableStage.ofFullComponents(pipeline.getComponents(), environment, inputPCollection, sideInputs, userStates, timers, fusedTransforms.build(), materializedPCollections);
    }

    private static RunnerApi.Environment getStageEnvironment(QueryablePipeline pipeline, Set<PipelineNode.PTransformNode> initialNodes) {
        Supplier<IllegalArgumentException> missingEnv = () -> new IllegalArgumentException(String.format("%s must be populated on all %s in a %s", RunnerApi.Environment.class.getSimpleName(), PipelineNode.PTransformNode.class.getSimpleName(), GreedyStageFuser.class.getSimpleName()));
        RunnerApi.Environment env = pipeline.getEnvironment(initialNodes.iterator().next()).orElseThrow(missingEnv);
        initialNodes.forEach(transformNode -> Preconditions.checkArgument(env.equals((Object)pipeline.getEnvironment((PipelineNode.PTransformNode)transformNode).orElseThrow(missingEnv)), "All %s in a %s must be the same. Got %s and %s", (Object)RunnerApi.Environment.class.getSimpleName(), (Object)ExecutableStage.class.getSimpleName(), (Object)env, (Object)pipeline.getEnvironment((PipelineNode.PTransformNode)transformNode).get()));
        return env;
    }

    private static PCollectionFusibility canFuse(QueryablePipeline pipeline, PipelineNode.PCollectionNode candidate, RunnerApi.Environment environment, Set<PipelineNode.PCollectionNode> fusedPCollections) {
        for (PipelineNode.PTransformNode node : pipeline.getPerElementConsumers(candidate)) {
            if (GreedyPCollectionFusers.canFuse(node, environment, candidate, fusedPCollections, pipeline)) continue;
            return PCollectionFusibility.MATERIALIZE;
        }
        if (!pipeline.getSingletonConsumers(candidate).isEmpty()) {
            return PCollectionFusibility.MATERIALIZE;
        }
        return PCollectionFusibility.FUSE;
    }

    private static enum PCollectionFusibility {
        MATERIALIZE,
        FUSE;

    }
}

