/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.splittabledofn;

import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;

public class RestrictionTrackers {
    public static <RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> observe(RestrictionTracker<RestrictionT, PositionT> restrictionTracker, ClaimObserver<PositionT> claimObserver) {
        return new RestrictionTrackerObserver(restrictionTracker, claimObserver);
    }

    private static class RestrictionTrackerObserver<RestrictionT, PositionT>
    extends ForwardingRestrictionTracker<RestrictionT, PositionT> {
        private final ClaimObserver<PositionT> claimObserver;

        private RestrictionTrackerObserver(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            super(delegate);
            this.claimObserver = claimObserver;
        }

        @Override
        public boolean tryClaim(PositionT position) {
            if (super.tryClaim(position)) {
                this.claimObserver.onClaimed(position);
                return true;
            }
            this.claimObserver.onClaimFailed(position);
            return false;
        }
    }

    private static class ForwardingRestrictionTracker<RestrictionT, PositionT>
    extends RestrictionTracker<RestrictionT, PositionT> {
        private final RestrictionTracker<RestrictionT, PositionT> delegate;

        protected ForwardingRestrictionTracker(RestrictionTracker<RestrictionT, PositionT> delegate) {
            this.delegate = delegate;
        }

        public boolean tryClaim(PositionT position) {
            return this.delegate.tryClaim(position);
        }

        public RestrictionT currentRestriction() {
            return (RestrictionT)this.delegate.currentRestriction();
        }

        public RestrictionT checkpoint() {
            return (RestrictionT)this.delegate.checkpoint();
        }

        public void checkDone() throws IllegalStateException {
            this.delegate.checkDone();
        }
    }

    public static interface ClaimObserver<PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

