/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.ExecutableGraph;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.StepTransformResult;
import org.apache.beam.runners.direct.portable.TransformEvaluator;
import org.apache.beam.runners.direct.portable.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.portable.TransformResult;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.util.WindowedValue;

class FlattenEvaluatorFactory
implements TransformEvaluatorFactory {
    private final BundleFactory bundleFactory;
    private final ExecutableGraph<PipelineNode.PTransformNode, PipelineNode.PCollectionNode> graph;

    FlattenEvaluatorFactory(ExecutableGraph<PipelineNode.PTransformNode, PipelineNode.PCollectionNode> graph, BundleFactory bundleFactory) {
        this.bundleFactory = bundleFactory;
        this.graph = graph;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(PipelineNode.PTransformNode application, CommittedBundle<?> inputBundle) {
        TransformEvaluator<InputT> evaluator = this.createInMemoryEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() {
    }

    private <InputT> TransformEvaluator<InputT> createInMemoryEvaluator(PipelineNode.PTransformNode transform) {
        return new FlattenEvaluator(transform);
    }

    private class FlattenEvaluator<InputT>
    implements TransformEvaluator<InputT> {
        private final PipelineNode.PTransformNode transform;
        private final UncommittedBundle<InputT> bundle;

        FlattenEvaluator(PipelineNode.PTransformNode transform) {
            this.transform = transform;
            PipelineNode.PCollectionNode output = (PipelineNode.PCollectionNode)Iterables.getOnlyElement(FlattenEvaluatorFactory.this.graph.getProduced(transform));
            this.bundle = FlattenEvaluatorFactory.this.bundleFactory.createBundle(output);
        }

        @Override
        public void processElement(WindowedValue<InputT> element) {
            this.bundle.add(element);
        }

        @Override
        public TransformResult<InputT> finishBundle() {
            return StepTransformResult.withoutHold(this.transform).addOutput(this.bundle, new UncommittedBundle[0]).build();
        }
    }
}

