// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * This statement creates a user-defined table-valued function:
 *   CREATE [TEMP] TABLE FUNCTION [IF NOT EXISTS]
 *     &lt;name_path&gt; (&lt;argument_name_list&gt;)
 *     [RETURNS &lt;return_type&gt;]
 *     [OPTIONS (&lt;option_list&gt;)]
 *     [LANGUAGE &lt;language&gt;]
 *     [AS &lt;code&gt; | AS ( &lt;query&gt; )]
 *   &lt;argument_name_list&gt; contains the names of the function arguments.
 *   &lt;signature&gt; is the FunctionSignature of the created function, with all
 *          options.  This can be used to create a Function to load into a
 *          Catalog for future queries.
 *   &lt;option_list&gt; has engine-specific directives for modifying functions.
 *   &lt;language&gt; is the programming language used by the function. This field
 *          is set to 'SQL' for SQL functions, to the language name specified
 *          in the LANGUAGE clause if present, and to 'UNDECLARED' if both
 *          the LANGUAGE clause and query are not present.
 *   &lt;code&gt; is an optional string literal that contains the function
 *          definition.  Some engines may allow this argument to be omitted
 *          for certain types of external functions.  This will always be set
 *          for SQL functions.
 *   &lt;query&gt; is the SQL query invoked for the function.  This will be unset
 *          for external language functions. For non-templated SQL functions,
 *          this is a resolved representation of the query in &lt;code&gt;.
 *   &lt;output_column_list&gt; is the list of resolved output
 *          columns returned by the table-valued function.
 *   &lt;is_value_table&gt; If true, this function returns a value table.
 *          Rather than producing rows with named columns, it produces
 *          rows with a single unnamed value type. &lt;output_column_list&gt; will
 *          have exactly one anonymous column (with no name).
 *          See (broken link).
 *   &lt;sql_security&gt; is the declared security mode for the function. Values
 *          include 'INVOKER', 'DEFINER'.
 * ----------------------
 * Table-Valued Functions
 * ----------------------
 * This is a statement to create a new table-valued function. Each
 * table-valued function returns an entire table as output instead of a
 * single scalar value. Table-valued functions can only be created if
 * LanguageOptions has FEATURE_CREATE_TABLE_FUNCTION enabled.
 * For SQL table-valued functions that include a defined SQL body, the
 * &lt;query&gt; is non-NULL and contains the resolved SQL body.
 * In this case, &lt;output_column_list&gt; contains a list of the
 * output columns of the SQL body. The &lt;query&gt; uses
 * ResolvedArgumentRefs to refer to scalar arguments and
 * ResolvedRelationArgumentScans to refer to relation arguments.
 * The table-valued function may include RETURNS TABLE&lt;...&gt; to explicitly
 * specify a schema for the output table returned by the function. If the
 * function declaration includes a SQL body, then the names and types of the
 * output columns of the corresponding &lt;query&gt; will have been
 * coerced to exactly match 1:1 with the names and types of the columns
 * specified in the RETURNS TABLE&lt;...&gt; section.
 * When resolving a query that calls a table-valued function, the query will
 * have a ResolvedTVFScan that invokes the function.
 * Value tables: If the function declaration includes a value-table
 * parameter, this is written as an argument of type "TABLE" where the table
 * contains a single anonymous column with a type but no name. In this case,
 * calls to the function may pass a (regular or value) table with a single
 * (named or unnamed) column for any of these parameters, and ZetaSQL
 * accepts these arguments as long as the column type matches.
 * Similarly, if the CREATE TABLE FUNCTION statement includes a "RETURNS
 * TABLE" section with a single column with no name, then this defines a
 * value-table return type. The function then returns a value table as long
 * as the SQL body returns a single column whose type matches (independent of
 * whether the SQL body result is a value table or not, and whether the
 * returned column is named or unnamed).
 * --------------------------------
 * Templated Table-Valued Functions
 * --------------------------------
 * ZetaSQL supports table-valued function declarations with parameters of
 * type ANY TABLE. This type indicates that any schema is valid for tables
 * passed for this parameter. In this case:
 * * the IsTemplated() method of the &lt;signature&gt; field returns true,
 * * the &lt;output_column_list&gt; field is empty,
 * * the &lt;is_value_table&gt; field is set to a default value of false (since
 *   ZetaSQL cannot analyze the function body in the presence of templated
 *   parameters, it is not possible to detect this property yet),
 * TODO: Update this description once ZetaSQL supports more types
 * of templated function parameters. Currently only ANY TABLE is supported.
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedCreateTableFunctionStmtProto}
 */
public  final class ResolvedCreateTableFunctionStmtProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedCreateTableFunctionStmtProto)
    ResolvedCreateTableFunctionStmtProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedCreateTableFunctionStmtProto.newBuilder() to construct.
  private ResolvedCreateTableFunctionStmtProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedCreateTableFunctionStmtProto() {
    argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    optionList_ = java.util.Collections.emptyList();
    language_ = "";
    code_ = "";
    outputColumnList_ = java.util.Collections.emptyList();
    isValueTable_ = false;
    sqlSecurity_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateTableFunctionStmtProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateTableFunctionStmtProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedCreateTableFunctionStmtProto.class, com.google.zetasql.ResolvedCreateTableFunctionStmtProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedCreateStatementProto parent_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) == 0x00000001);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedCreateStatementProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
  }

  public static final int ARGUMENT_NAME_LIST_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList argumentNameList_;
  /**
   * <code>repeated string argument_name_list = 2;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getArgumentNameListList() {
    return argumentNameList_;
  }
  /**
   * <code>repeated string argument_name_list = 2;</code>
   */
  public int getArgumentNameListCount() {
    return argumentNameList_.size();
  }
  /**
   * <code>repeated string argument_name_list = 2;</code>
   */
  public java.lang.String getArgumentNameList(int index) {
    return argumentNameList_.get(index);
  }
  /**
   * <code>repeated string argument_name_list = 2;</code>
   */
  public com.google.protobuf.ByteString
      getArgumentNameListBytes(int index) {
    return argumentNameList_.getByteString(index);
  }

  public static final int SIGNATURE_FIELD_NUMBER = 3;
  private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_;
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
   */
  public boolean hasSignature() {
    return ((bitField0_ & 0x00000002) == 0x00000002);
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
   */
  public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }
  /**
   * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
   */
  public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
    return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
  }

  public static final int OPTION_LIST_FIELD_NUMBER = 4;
  private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_;
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
      getOptionListOrBuilderList() {
    return optionList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
   */
  public int getOptionListCount() {
    return optionList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
   */
  public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
    return optionList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
   */
  public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
      int index) {
    return optionList_.get(index);
  }

  public static final int LANGUAGE_FIELD_NUMBER = 5;
  private volatile java.lang.Object language_;
  /**
   * <code>optional string language = 5;</code>
   */
  public boolean hasLanguage() {
    return ((bitField0_ & 0x00000004) == 0x00000004);
  }
  /**
   * <code>optional string language = 5;</code>
   */
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        language_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string language = 5;</code>
   */
  public com.google.protobuf.ByteString
      getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_FIELD_NUMBER = 6;
  private volatile java.lang.Object code_;
  /**
   * <code>optional string code = 6;</code>
   */
  public boolean hasCode() {
    return ((bitField0_ & 0x00000008) == 0x00000008);
  }
  /**
   * <code>optional string code = 6;</code>
   */
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        code_ = s;
      }
      return s;
    }
  }
  /**
   * <code>optional string code = 6;</code>
   */
  public com.google.protobuf.ByteString
      getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 7;
  private com.google.zetasql.AnyResolvedScanProto query_;
  /**
   * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
   */
  public boolean hasQuery() {
    return ((bitField0_ & 0x00000010) == 0x00000010);
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
   */
  public com.google.zetasql.AnyResolvedScanProto getQuery() {
    return query_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : query_;
  }
  /**
   * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
   */
  public com.google.zetasql.AnyResolvedScanProtoOrBuilder getQueryOrBuilder() {
    return query_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : query_;
  }

  public static final int OUTPUT_COLUMN_LIST_FIELD_NUMBER = 8;
  private java.util.List<com.google.zetasql.ResolvedOutputColumnProto> outputColumnList_;
  /**
   * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedOutputColumnProto> getOutputColumnListList() {
    return outputColumnList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedOutputColumnProtoOrBuilder> 
      getOutputColumnListOrBuilderList() {
    return outputColumnList_;
  }
  /**
   * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
   */
  public int getOutputColumnListCount() {
    return outputColumnList_.size();
  }
  /**
   * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
   */
  public com.google.zetasql.ResolvedOutputColumnProto getOutputColumnList(int index) {
    return outputColumnList_.get(index);
  }
  /**
   * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
   */
  public com.google.zetasql.ResolvedOutputColumnProtoOrBuilder getOutputColumnListOrBuilder(
      int index) {
    return outputColumnList_.get(index);
  }

  public static final int IS_VALUE_TABLE_FIELD_NUMBER = 9;
  private boolean isValueTable_;
  /**
   * <code>optional bool is_value_table = 9;</code>
   */
  public boolean hasIsValueTable() {
    return ((bitField0_ & 0x00000020) == 0x00000020);
  }
  /**
   * <code>optional bool is_value_table = 9;</code>
   */
  public boolean getIsValueTable() {
    return isValueTable_;
  }

  public static final int SQL_SECURITY_FIELD_NUMBER = 10;
  private int sqlSecurity_;
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
   */
  public boolean hasSqlSecurity() {
    return ((bitField0_ & 0x00000040) == 0x00000040);
  }
  /**
   * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
   */
  public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
    @SuppressWarnings("deprecation")
    com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
    return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
  }

  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedCreateTableFunctionStmtProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This statement creates a user-defined table-valued function:
   *   CREATE [TEMP] TABLE FUNCTION [IF NOT EXISTS]
   *     &lt;name_path&gt; (&lt;argument_name_list&gt;)
   *     [RETURNS &lt;return_type&gt;]
   *     [OPTIONS (&lt;option_list&gt;)]
   *     [LANGUAGE &lt;language&gt;]
   *     [AS &lt;code&gt; | AS ( &lt;query&gt; )]
   *   &lt;argument_name_list&gt; contains the names of the function arguments.
   *   &lt;signature&gt; is the FunctionSignature of the created function, with all
   *          options.  This can be used to create a Function to load into a
   *          Catalog for future queries.
   *   &lt;option_list&gt; has engine-specific directives for modifying functions.
   *   &lt;language&gt; is the programming language used by the function. This field
   *          is set to 'SQL' for SQL functions, to the language name specified
   *          in the LANGUAGE clause if present, and to 'UNDECLARED' if both
   *          the LANGUAGE clause and query are not present.
   *   &lt;code&gt; is an optional string literal that contains the function
   *          definition.  Some engines may allow this argument to be omitted
   *          for certain types of external functions.  This will always be set
   *          for SQL functions.
   *   &lt;query&gt; is the SQL query invoked for the function.  This will be unset
   *          for external language functions. For non-templated SQL functions,
   *          this is a resolved representation of the query in &lt;code&gt;.
   *   &lt;output_column_list&gt; is the list of resolved output
   *          columns returned by the table-valued function.
   *   &lt;is_value_table&gt; If true, this function returns a value table.
   *          Rather than producing rows with named columns, it produces
   *          rows with a single unnamed value type. &lt;output_column_list&gt; will
   *          have exactly one anonymous column (with no name).
   *          See (broken link).
   *   &lt;sql_security&gt; is the declared security mode for the function. Values
   *          include 'INVOKER', 'DEFINER'.
   * ----------------------
   * Table-Valued Functions
   * ----------------------
   * This is a statement to create a new table-valued function. Each
   * table-valued function returns an entire table as output instead of a
   * single scalar value. Table-valued functions can only be created if
   * LanguageOptions has FEATURE_CREATE_TABLE_FUNCTION enabled.
   * For SQL table-valued functions that include a defined SQL body, the
   * &lt;query&gt; is non-NULL and contains the resolved SQL body.
   * In this case, &lt;output_column_list&gt; contains a list of the
   * output columns of the SQL body. The &lt;query&gt; uses
   * ResolvedArgumentRefs to refer to scalar arguments and
   * ResolvedRelationArgumentScans to refer to relation arguments.
   * The table-valued function may include RETURNS TABLE&lt;...&gt; to explicitly
   * specify a schema for the output table returned by the function. If the
   * function declaration includes a SQL body, then the names and types of the
   * output columns of the corresponding &lt;query&gt; will have been
   * coerced to exactly match 1:1 with the names and types of the columns
   * specified in the RETURNS TABLE&lt;...&gt; section.
   * When resolving a query that calls a table-valued function, the query will
   * have a ResolvedTVFScan that invokes the function.
   * Value tables: If the function declaration includes a value-table
   * parameter, this is written as an argument of type "TABLE" where the table
   * contains a single anonymous column with a type but no name. In this case,
   * calls to the function may pass a (regular or value) table with a single
   * (named or unnamed) column for any of these parameters, and ZetaSQL
   * accepts these arguments as long as the column type matches.
   * Similarly, if the CREATE TABLE FUNCTION statement includes a "RETURNS
   * TABLE" section with a single column with no name, then this defines a
   * value-table return type. The function then returns a value table as long
   * as the SQL body returns a single column whose type matches (independent of
   * whether the SQL body result is a value table or not, and whether the
   * returned column is named or unnamed).
   * --------------------------------
   * Templated Table-Valued Functions
   * --------------------------------
   * ZetaSQL supports table-valued function declarations with parameters of
   * type ANY TABLE. This type indicates that any schema is valid for tables
   * passed for this parameter. In this case:
   * * the IsTemplated() method of the &lt;signature&gt; field returns true,
   * * the &lt;output_column_list&gt; field is empty,
   * * the &lt;is_value_table&gt; field is set to a default value of false (since
   *   ZetaSQL cannot analyze the function body in the presence of templated
   *   parameters, it is not possible to detect this property yet),
   * TODO: Update this description once ZetaSQL supports more types
   * of templated function parameters. Currently only ANY TABLE is supported.
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedCreateTableFunctionStmtProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedCreateTableFunctionStmtProto)
      com.google.zetasql.ResolvedCreateTableFunctionStmtProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateTableFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateTableFunctionStmtProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedCreateTableFunctionStmtProto.class, com.google.zetasql.ResolvedCreateTableFunctionStmtProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedCreateTableFunctionStmtProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getSignatureFieldBuilder();
        getOptionListFieldBuilder();
        getQueryFieldBuilder();
        getOutputColumnListFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (signatureBuilder_ == null) {
        signature_ = null;
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        optionListBuilder_.clear();
      }
      language_ = "";
      bitField0_ = (bitField0_ & ~0x00000010);
      code_ = "";
      bitField0_ = (bitField0_ & ~0x00000020);
      if (queryBuilder_ == null) {
        query_ = null;
      } else {
        queryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (outputColumnListBuilder_ == null) {
        outputColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
      } else {
        outputColumnListBuilder_.clear();
      }
      isValueTable_ = false;
      bitField0_ = (bitField0_ & ~0x00000100);
      sqlSecurity_ = 0;
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedCreateTableFunctionStmtProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateTableFunctionStmtProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedCreateTableFunctionStmtProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateTableFunctionStmtProto build() {
      com.google.zetasql.ResolvedCreateTableFunctionStmtProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedCreateTableFunctionStmtProto buildPartial() {
      com.google.zetasql.ResolvedCreateTableFunctionStmtProto result = new com.google.zetasql.ResolvedCreateTableFunctionStmtProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
        to_bitField0_ |= 0x00000001;
      }
      if (parentBuilder_ == null) {
        result.parent_ = parent_;
      } else {
        result.parent_ = parentBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        argumentNameList_ = argumentNameList_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.argumentNameList_ = argumentNameList_;
      if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
        to_bitField0_ |= 0x00000002;
      }
      if (signatureBuilder_ == null) {
        result.signature_ = signature_;
      } else {
        result.signature_ = signatureBuilder_.build();
      }
      if (optionListBuilder_ == null) {
        if (((bitField0_ & 0x00000008) == 0x00000008)) {
          optionList_ = java.util.Collections.unmodifiableList(optionList_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.optionList_ = optionList_;
      } else {
        result.optionList_ = optionListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
        to_bitField0_ |= 0x00000004;
      }
      result.language_ = language_;
      if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
        to_bitField0_ |= 0x00000008;
      }
      result.code_ = code_;
      if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
        to_bitField0_ |= 0x00000010;
      }
      if (queryBuilder_ == null) {
        result.query_ = query_;
      } else {
        result.query_ = queryBuilder_.build();
      }
      if (outputColumnListBuilder_ == null) {
        if (((bitField0_ & 0x00000080) == 0x00000080)) {
          outputColumnList_ = java.util.Collections.unmodifiableList(outputColumnList_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.outputColumnList_ = outputColumnList_;
      } else {
        result.outputColumnList_ = outputColumnListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
        to_bitField0_ |= 0x00000020;
      }
      result.isValueTable_ = isValueTable_;
      if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
        to_bitField0_ |= 0x00000040;
      }
      result.sqlSecurity_ = sqlSecurity_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedCreateStatementProto parent_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedCreateStatementProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedCreateStatementProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) == 0x00000001) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedCreateStatementProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedCreateStatementProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedCreateStatementProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedCreateStatementProto, com.google.zetasql.ResolvedCreateStatementProto.Builder, com.google.zetasql.ResolvedCreateStatementProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private com.google.protobuf.LazyStringList argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureArgumentNameListIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        argumentNameList_ = new com.google.protobuf.LazyStringArrayList(argumentNameList_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getArgumentNameListList() {
      return argumentNameList_.getUnmodifiableView();
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public int getArgumentNameListCount() {
      return argumentNameList_.size();
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public java.lang.String getArgumentNameList(int index) {
      return argumentNameList_.get(index);
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public com.google.protobuf.ByteString
        getArgumentNameListBytes(int index) {
      return argumentNameList_.getByteString(index);
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public Builder setArgumentNameList(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public Builder addArgumentNameList(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public Builder addAllArgumentNameList(
        java.lang.Iterable<java.lang.String> values) {
      ensureArgumentNameListIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, argumentNameList_);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public Builder clearArgumentNameList() {
      argumentNameList_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <code>repeated string argument_name_list = 2;</code>
     */
    public Builder addArgumentNameListBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureArgumentNameListIsMutable();
      argumentNameList_.add(value);
      onChanged();
      return this;
    }

    private com.google.zetasql.FunctionProtos.FunctionSignatureProto signature_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> signatureBuilder_;
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public boolean hasSignature() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto getSignature() {
      if (signatureBuilder_ == null) {
        return signature_ == null ? com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      } else {
        return signatureBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public Builder setSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signature_ = value;
        onChanged();
      } else {
        signatureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public Builder setSignature(
        com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder builderForValue) {
      if (signatureBuilder_ == null) {
        signature_ = builderForValue.build();
        onChanged();
      } else {
        signatureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public Builder mergeSignature(com.google.zetasql.FunctionProtos.FunctionSignatureProto value) {
      if (signatureBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004) &&
            signature_ != null &&
            signature_ != com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance()) {
          signature_ =
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.newBuilder(signature_).mergeFrom(value).buildPartial();
        } else {
          signature_ = value;
        }
        onChanged();
      } else {
        signatureBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public Builder clearSignature() {
      if (signatureBuilder_ == null) {
        signature_ = null;
        onChanged();
      } else {
        signatureBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder getSignatureBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSignatureFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    public com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder getSignatureOrBuilder() {
      if (signatureBuilder_ != null) {
        return signatureBuilder_.getMessageOrBuilder();
      } else {
        return signature_ == null ?
            com.google.zetasql.FunctionProtos.FunctionSignatureProto.getDefaultInstance() : signature_;
      }
    }
    /**
     * <code>optional .zetasql.FunctionSignatureProto signature = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder> 
        getSignatureFieldBuilder() {
      if (signatureBuilder_ == null) {
        signatureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.FunctionProtos.FunctionSignatureProto, com.google.zetasql.FunctionProtos.FunctionSignatureProto.Builder, com.google.zetasql.FunctionProtos.FunctionSignatureProtoOrBuilder>(
                getSignature(),
                getParentForChildren(),
                isClean());
        signature_ = null;
      }
      return signatureBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedOptionProto> optionList_ =
      java.util.Collections.emptyList();
    private void ensureOptionListIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        optionList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOptionProto>(optionList_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> optionListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto> getOptionListList() {
      if (optionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(optionList_);
      } else {
        return optionListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public int getOptionListCount() {
      if (optionListBuilder_ == null) {
        return optionList_.size();
      } else {
        return optionListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public com.google.zetasql.ResolvedOptionProto getOptionList(int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);
      } else {
        return optionListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.set(index, value);
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder setOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder addOptionList(com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto value) {
      if (optionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOptionListIsMutable();
        optionList_.add(index, value);
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder addOptionList(
        com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder addOptionList(
        int index, com.google.zetasql.ResolvedOptionProto.Builder builderForValue) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        optionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder addAllOptionList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedOptionProto> values) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, optionList_);
        onChanged();
      } else {
        optionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder clearOptionList() {
      if (optionListBuilder_ == null) {
        optionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        optionListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public Builder removeOptionList(int index) {
      if (optionListBuilder_ == null) {
        ensureOptionListIsMutable();
        optionList_.remove(index);
        onChanged();
      } else {
        optionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder getOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public com.google.zetasql.ResolvedOptionProtoOrBuilder getOptionListOrBuilder(
        int index) {
      if (optionListBuilder_ == null) {
        return optionList_.get(index);  } else {
        return optionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedOptionProtoOrBuilder> 
         getOptionListOrBuilderList() {
      if (optionListBuilder_ != null) {
        return optionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(optionList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder() {
      return getOptionListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public com.google.zetasql.ResolvedOptionProto.Builder addOptionListBuilder(
        int index) {
      return getOptionListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedOptionProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOptionProto option_list = 4;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOptionProto.Builder> 
         getOptionListBuilderList() {
      return getOptionListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder> 
        getOptionListFieldBuilder() {
      if (optionListBuilder_ == null) {
        optionListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedOptionProto, com.google.zetasql.ResolvedOptionProto.Builder, com.google.zetasql.ResolvedOptionProtoOrBuilder>(
                optionList_,
                ((bitField0_ & 0x00000008) == 0x00000008),
                getParentForChildren(),
                isClean());
        optionList_ = null;
      }
      return optionListBuilder_;
    }

    private java.lang.Object language_ = "";
    /**
     * <code>optional string language = 5;</code>
     */
    public boolean hasLanguage() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional string language = 5;</code>
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          language_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string language = 5;</code>
     */
    public com.google.protobuf.ByteString
        getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string language = 5;</code>
     */
    public Builder setLanguage(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
      language_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 5;</code>
     */
    public Builder clearLanguage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      language_ = getDefaultInstance().getLanguage();
      onChanged();
      return this;
    }
    /**
     * <code>optional string language = 5;</code>
     */
    public Builder setLanguageBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
      language_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     * <code>optional string code = 6;</code>
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string code = 6;</code>
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          code_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string code = 6;</code>
     */
    public com.google.protobuf.ByteString
        getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string code = 6;</code>
     */
    public Builder setCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
      code_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 6;</code>
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      code_ = getDefaultInstance().getCode();
      onChanged();
      return this;
    }
    /**
     * <code>optional string code = 6;</code>
     */
    public Builder setCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
      code_ = value;
      onChanged();
      return this;
    }

    private com.google.zetasql.AnyResolvedScanProto query_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> queryBuilder_;
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public com.google.zetasql.AnyResolvedScanProto getQuery() {
      if (queryBuilder_ == null) {
        return query_ == null ? com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : query_;
      } else {
        return queryBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public Builder setQuery(com.google.zetasql.AnyResolvedScanProto value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
        onChanged();
      } else {
        queryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public Builder setQuery(
        com.google.zetasql.AnyResolvedScanProto.Builder builderForValue) {
      if (queryBuilder_ == null) {
        query_ = builderForValue.build();
        onChanged();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public Builder mergeQuery(com.google.zetasql.AnyResolvedScanProto value) {
      if (queryBuilder_ == null) {
        if (((bitField0_ & 0x00000040) == 0x00000040) &&
            query_ != null &&
            query_ != com.google.zetasql.AnyResolvedScanProto.getDefaultInstance()) {
          query_ =
            com.google.zetasql.AnyResolvedScanProto.newBuilder(query_).mergeFrom(value).buildPartial();
        } else {
          query_ = value;
        }
        onChanged();
      } else {
        queryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public Builder clearQuery() {
      if (queryBuilder_ == null) {
        query_ = null;
        onChanged();
      } else {
        queryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public com.google.zetasql.AnyResolvedScanProto.Builder getQueryBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    public com.google.zetasql.AnyResolvedScanProtoOrBuilder getQueryOrBuilder() {
      if (queryBuilder_ != null) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        return query_ == null ?
            com.google.zetasql.AnyResolvedScanProto.getDefaultInstance() : query_;
      }
    }
    /**
     * <code>optional .zetasql.AnyResolvedScanProto query = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder> 
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        queryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedScanProto, com.google.zetasql.AnyResolvedScanProto.Builder, com.google.zetasql.AnyResolvedScanProtoOrBuilder>(
                getQuery(),
                getParentForChildren(),
                isClean());
        query_ = null;
      }
      return queryBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedOutputColumnProto> outputColumnList_ =
      java.util.Collections.emptyList();
    private void ensureOutputColumnListIsMutable() {
      if (!((bitField0_ & 0x00000080) == 0x00000080)) {
        outputColumnList_ = new java.util.ArrayList<com.google.zetasql.ResolvedOutputColumnProto>(outputColumnList_);
        bitField0_ |= 0x00000080;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOutputColumnProto, com.google.zetasql.ResolvedOutputColumnProto.Builder, com.google.zetasql.ResolvedOutputColumnProtoOrBuilder> outputColumnListBuilder_;

    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOutputColumnProto> getOutputColumnListList() {
      if (outputColumnListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(outputColumnList_);
      } else {
        return outputColumnListBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public int getOutputColumnListCount() {
      if (outputColumnListBuilder_ == null) {
        return outputColumnList_.size();
      } else {
        return outputColumnListBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public com.google.zetasql.ResolvedOutputColumnProto getOutputColumnList(int index) {
      if (outputColumnListBuilder_ == null) {
        return outputColumnList_.get(index);
      } else {
        return outputColumnListBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder setOutputColumnList(
        int index, com.google.zetasql.ResolvedOutputColumnProto value) {
      if (outputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputColumnListIsMutable();
        outputColumnList_.set(index, value);
        onChanged();
      } else {
        outputColumnListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder setOutputColumnList(
        int index, com.google.zetasql.ResolvedOutputColumnProto.Builder builderForValue) {
      if (outputColumnListBuilder_ == null) {
        ensureOutputColumnListIsMutable();
        outputColumnList_.set(index, builderForValue.build());
        onChanged();
      } else {
        outputColumnListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder addOutputColumnList(com.google.zetasql.ResolvedOutputColumnProto value) {
      if (outputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputColumnListIsMutable();
        outputColumnList_.add(value);
        onChanged();
      } else {
        outputColumnListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder addOutputColumnList(
        int index, com.google.zetasql.ResolvedOutputColumnProto value) {
      if (outputColumnListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputColumnListIsMutable();
        outputColumnList_.add(index, value);
        onChanged();
      } else {
        outputColumnListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder addOutputColumnList(
        com.google.zetasql.ResolvedOutputColumnProto.Builder builderForValue) {
      if (outputColumnListBuilder_ == null) {
        ensureOutputColumnListIsMutable();
        outputColumnList_.add(builderForValue.build());
        onChanged();
      } else {
        outputColumnListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder addOutputColumnList(
        int index, com.google.zetasql.ResolvedOutputColumnProto.Builder builderForValue) {
      if (outputColumnListBuilder_ == null) {
        ensureOutputColumnListIsMutable();
        outputColumnList_.add(index, builderForValue.build());
        onChanged();
      } else {
        outputColumnListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder addAllOutputColumnList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedOutputColumnProto> values) {
      if (outputColumnListBuilder_ == null) {
        ensureOutputColumnListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, outputColumnList_);
        onChanged();
      } else {
        outputColumnListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder clearOutputColumnList() {
      if (outputColumnListBuilder_ == null) {
        outputColumnList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        outputColumnListBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public Builder removeOutputColumnList(int index) {
      if (outputColumnListBuilder_ == null) {
        ensureOutputColumnListIsMutable();
        outputColumnList_.remove(index);
        onChanged();
      } else {
        outputColumnListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public com.google.zetasql.ResolvedOutputColumnProto.Builder getOutputColumnListBuilder(
        int index) {
      return getOutputColumnListFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public com.google.zetasql.ResolvedOutputColumnProtoOrBuilder getOutputColumnListOrBuilder(
        int index) {
      if (outputColumnListBuilder_ == null) {
        return outputColumnList_.get(index);  } else {
        return outputColumnListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedOutputColumnProtoOrBuilder> 
         getOutputColumnListOrBuilderList() {
      if (outputColumnListBuilder_ != null) {
        return outputColumnListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(outputColumnList_);
      }
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public com.google.zetasql.ResolvedOutputColumnProto.Builder addOutputColumnListBuilder() {
      return getOutputColumnListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedOutputColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public com.google.zetasql.ResolvedOutputColumnProto.Builder addOutputColumnListBuilder(
        int index) {
      return getOutputColumnListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedOutputColumnProto.getDefaultInstance());
    }
    /**
     * <code>repeated .zetasql.ResolvedOutputColumnProto output_column_list = 8;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedOutputColumnProto.Builder> 
         getOutputColumnListBuilderList() {
      return getOutputColumnListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedOutputColumnProto, com.google.zetasql.ResolvedOutputColumnProto.Builder, com.google.zetasql.ResolvedOutputColumnProtoOrBuilder> 
        getOutputColumnListFieldBuilder() {
      if (outputColumnListBuilder_ == null) {
        outputColumnListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedOutputColumnProto, com.google.zetasql.ResolvedOutputColumnProto.Builder, com.google.zetasql.ResolvedOutputColumnProtoOrBuilder>(
                outputColumnList_,
                ((bitField0_ & 0x00000080) == 0x00000080),
                getParentForChildren(),
                isClean());
        outputColumnList_ = null;
      }
      return outputColumnListBuilder_;
    }

    private boolean isValueTable_ ;
    /**
     * <code>optional bool is_value_table = 9;</code>
     */
    public boolean hasIsValueTable() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional bool is_value_table = 9;</code>
     */
    public boolean getIsValueTable() {
      return isValueTable_;
    }
    /**
     * <code>optional bool is_value_table = 9;</code>
     */
    public Builder setIsValueTable(boolean value) {
      bitField0_ |= 0x00000100;
      isValueTable_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool is_value_table = 9;</code>
     */
    public Builder clearIsValueTable() {
      bitField0_ = (bitField0_ & ~0x00000100);
      isValueTable_ = false;
      onChanged();
      return this;
    }

    private int sqlSecurity_ = 0;
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
     */
    public boolean hasSqlSecurity() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
     */
    public com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity getSqlSecurity() {
      @SuppressWarnings("deprecation")
      com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity result = com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.valueOf(sqlSecurity_);
      return result == null ? com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity.SQL_SECURITY_UNSPECIFIED : result;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
     */
    public Builder setSqlSecurity(com.google.zetasql.resolvedast.ResolvedCreateStatementEnums.SqlSecurity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      sqlSecurity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedCreateStatementEnums.SqlSecurity sql_security = 10;</code>
     */
    public Builder clearSqlSecurity() {
      bitField0_ = (bitField0_ & ~0x00000200);
      sqlSecurity_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedCreateTableFunctionStmtProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedCreateTableFunctionStmtProto)
  private static final com.google.zetasql.ResolvedCreateTableFunctionStmtProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedCreateTableFunctionStmtProto();
  }

  public static com.google.zetasql.ResolvedCreateTableFunctionStmtProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedCreateTableFunctionStmtProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedCreateTableFunctionStmtProto>() {
    @java.lang.Override
    public ResolvedCreateTableFunctionStmtProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(
                builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ResolvedCreateTableFunctionStmtProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedCreateTableFunctionStmtProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedCreateTableFunctionStmtProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

