// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: zetasql/resolved_ast/resolved_ast.proto

package com.google.zetasql;

/**
 * <pre>
 * This represents one item inside the SET clause of an UPDATE.
 * The entity being updated is specified by &lt;target&gt;.
 * For a regular
 *   SET {target} = {expression} | DEFAULT
 * clause (not including an array element update like SET a[OFFSET(0)] = 5),
 * &lt;target&gt; and &lt;set_value&gt; will be present, and all other fields will be
 * unset.
 * For an array element update (e.g. SET a.b[&lt;expr&gt;].c = &lt;value&gt;),
 *   - &lt;target&gt; is set to the array,
 *   - &lt;element_column&gt; is a new ResolvedColumn that can be used inside the
 *     update items to refer to the array element.
 *   - &lt;array_update_list&gt; will have a node corresponding to the offset into
 *     that array and the modification to that array element.
 * For example, for SET a.b[&lt;expr&gt;].c = &lt;value&gt;, we have
 *    ResolvedUpdateItem
 *    +-&lt;target&gt; = a.b
 *    +-&lt;element_column&gt; = &lt;x&gt;
 *    +-&lt;array_update_list&gt;
 *      +-ResolvedUpdateArrayItem
 *        +-&lt;offset&gt; = &lt;expr&gt;
 *        +-&lt;update_item&gt; = ResolvedUpdateItem
 *          +-&lt;target&gt; = &lt;x&gt;.c
 *          +-&lt;set_value&gt; = &lt;value&gt;
 * The engine is required to fail the update if there are two elements of
 * &lt;array_update_list&gt; corresponding to offset expressions that evaluate to
 * the same value. These are considered to be conflicting updates.
 * Multiple updates to the same array are always represented as multiple
 * elements of &lt;array_update_list&gt; under a single ResolvedUpdateItem
 * corresponding to that array. &lt;array_update_list&gt; will only have one
 * element for modifications to an array-valued subfield of an array element.
 * E.g., for SET a[&lt;expr1&gt;].b[&lt;expr2&gt;] = 5, a[&lt;expr3&gt;].b[&lt;expr4&gt;] = 6, we
 * will have:
 *     ResolvedUpdateItem
 *     +-&lt;target&gt; = a
 *     +-&lt;element_column&gt; = x
 *     +-&lt;array_update_list&gt;
 *       +-ResolvedUpdateArrayItem
 *         +-&lt;offset&gt; = &lt;expr1&gt;
 *         +-ResolvedUpdateItem for &lt;x&gt;.b[&lt;expr2&gt;] = 5
 *       +-ResolvedUpdateArrayItem
 *         +-&lt;offset&gt; = &lt;expr3&gt;
 *         +-ResolvedUpdateItem for &lt;x&gt;.b[&lt;expr4&gt;] = 6
 * The engine must give a runtime error if &lt;expr1&gt; and &lt;expr3&gt; evaluate to
 * the same thing. Notably, it does not have to understand that the
 * two ResolvedUpdateItems corresponding to "b" refer to the same array iff
 * &lt;expr1&gt; and &lt;expr3&gt; evaluate to the same thing.
 * TODO: Consider allowing the engine to execute an update like
 * SET a[&lt;expr1&gt;].b = 1, a[&lt;expr2&gt;].c = 2 even if &lt;expr1&gt; == &lt;expr2&gt; since
 * "b" and "c" do not overlap. Also consider allowing a more complex example
 * like SET a[&lt;expr1&gt;].b[&lt;expr2&gt;] = ...,
 * a[&lt;expr3&gt;].b[&lt;expr4&gt;].c[&lt;expr5&gt;] = ... even if &lt;expr1&gt; == &lt;expr3&gt;, as long
 * as &lt;expr2&gt; != &lt;expr4&gt; in that case.
 * For nested DML, &lt;target&gt; and &lt;element_column&gt; will both be set, and one or
 * more of the nested statement lists will be non-empty. &lt;target&gt; must have
 * ARRAY type, and &lt;element_column&gt; introduces a ResolvedColumn representing
 * elements of that array. The nested statement lists will always be empty in
 * a ResolvedUpdateItem child of a ResolvedUpdateArrayItem node.
 * See (broken link) for more detail.
 * </pre>
 *
 * Protobuf type {@code zetasql.ResolvedUpdateItemProto}
 */
public  final class ResolvedUpdateItemProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:zetasql.ResolvedUpdateItemProto)
    ResolvedUpdateItemProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolvedUpdateItemProto.newBuilder() to construct.
  private ResolvedUpdateItemProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolvedUpdateItemProto() {
    arrayUpdateList_ = java.util.Collections.emptyList();
    deleteList_ = java.util.Collections.emptyList();
    updateList_ = java.util.Collections.emptyList();
    insertList_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUpdateItemProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUpdateItemProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.zetasql.ResolvedUpdateItemProto.class, com.google.zetasql.ResolvedUpdateItemProto.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private com.google.zetasql.ResolvedArgumentProto parent_;
  /**
   * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
   */
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) == 0x00000001);
  }
  /**
   * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedArgumentProto getParent() {
    return parent_ == null ? com.google.zetasql.ResolvedArgumentProto.getDefaultInstance() : parent_;
  }
  /**
   * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
   */
  public com.google.zetasql.ResolvedArgumentProtoOrBuilder getParentOrBuilder() {
    return parent_ == null ? com.google.zetasql.ResolvedArgumentProto.getDefaultInstance() : parent_;
  }

  public static final int TARGET_FIELD_NUMBER = 2;
  private com.google.zetasql.AnyResolvedExprProto target_;
  /**
   * <pre>
   * The target entity to be updated.
   * This is an expression evaluated using the ResolvedColumns visible
   * inside this statement.  This expression can contain only
   * ResolvedColumnRefs, ResolvedGetProtoField and
   * ResolvedGetStructField nodes.
   * In a top-level UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing a column from the statement's
   * TableScan.
   * In a nested UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing the element_column from the
   * ResolvedUpdateItem containing this scan.
   * This node is also used to represent a modification of a single
   * array element (when it occurs as a child of a
   * ResolvedUpdateArrayItem node).  In that case, the expression
   * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
   * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
   * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
   * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
   * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
   * &lt;element_column&gt; field.)
   * For either a nested UPDATE or an array modification, there may be
   * a path of field accesses after the initial ResolvedColumnRef,
   * represented by a chain of GetField nodes.
   * NOTE: We use the same GetField nodes as we do for queries, but
   * they are not treated the same.  Here, they express a path inside
   * an object that is being mutated, so they have reference semantics.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
   */
  public boolean hasTarget() {
    return ((bitField0_ & 0x00000002) == 0x00000002);
  }
  /**
   * <pre>
   * The target entity to be updated.
   * This is an expression evaluated using the ResolvedColumns visible
   * inside this statement.  This expression can contain only
   * ResolvedColumnRefs, ResolvedGetProtoField and
   * ResolvedGetStructField nodes.
   * In a top-level UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing a column from the statement's
   * TableScan.
   * In a nested UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing the element_column from the
   * ResolvedUpdateItem containing this scan.
   * This node is also used to represent a modification of a single
   * array element (when it occurs as a child of a
   * ResolvedUpdateArrayItem node).  In that case, the expression
   * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
   * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
   * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
   * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
   * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
   * &lt;element_column&gt; field.)
   * For either a nested UPDATE or an array modification, there may be
   * a path of field accesses after the initial ResolvedColumnRef,
   * represented by a chain of GetField nodes.
   * NOTE: We use the same GetField nodes as we do for queries, but
   * they are not treated the same.  Here, they express a path inside
   * an object that is being mutated, so they have reference semantics.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
   */
  public com.google.zetasql.AnyResolvedExprProto getTarget() {
    return target_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : target_;
  }
  /**
   * <pre>
   * The target entity to be updated.
   * This is an expression evaluated using the ResolvedColumns visible
   * inside this statement.  This expression can contain only
   * ResolvedColumnRefs, ResolvedGetProtoField and
   * ResolvedGetStructField nodes.
   * In a top-level UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing a column from the statement's
   * TableScan.
   * In a nested UPDATE, the expression always starts with a
   * ResolvedColumnRef referencing the element_column from the
   * ResolvedUpdateItem containing this scan.
   * This node is also used to represent a modification of a single
   * array element (when it occurs as a child of a
   * ResolvedUpdateArrayItem node).  In that case, the expression
   * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
   * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
   * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
   * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
   * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
   * &lt;element_column&gt; field.)
   * For either a nested UPDATE or an array modification, there may be
   * a path of field accesses after the initial ResolvedColumnRef,
   * represented by a chain of GetField nodes.
   * NOTE: We use the same GetField nodes as we do for queries, but
   * they are not treated the same.  Here, they express a path inside
   * an object that is being mutated, so they have reference semantics.
   * </pre>
   *
   * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
   */
  public com.google.zetasql.AnyResolvedExprProtoOrBuilder getTargetOrBuilder() {
    return target_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : target_;
  }

  public static final int SET_VALUE_FIELD_NUMBER = 3;
  private com.google.zetasql.ResolvedDMLValueProto setValue_;
  /**
   * <pre>
   * Set the target entity to this value.  The types must match.
   * This can contain the same columns that can appear in the
   * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
   * This is mutually exclusive with all fields below, which are used
   * for nested updates only.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
   */
  public boolean hasSetValue() {
    return ((bitField0_ & 0x00000004) == 0x00000004);
  }
  /**
   * <pre>
   * Set the target entity to this value.  The types must match.
   * This can contain the same columns that can appear in the
   * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
   * This is mutually exclusive with all fields below, which are used
   * for nested updates only.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
   */
  public com.google.zetasql.ResolvedDMLValueProto getSetValue() {
    return setValue_ == null ? com.google.zetasql.ResolvedDMLValueProto.getDefaultInstance() : setValue_;
  }
  /**
   * <pre>
   * Set the target entity to this value.  The types must match.
   * This can contain the same columns that can appear in the
   * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
   * This is mutually exclusive with all fields below, which are used
   * for nested updates only.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
   */
  public com.google.zetasql.ResolvedDMLValueProtoOrBuilder getSetValueOrBuilder() {
    return setValue_ == null ? com.google.zetasql.ResolvedDMLValueProto.getDefaultInstance() : setValue_;
  }

  public static final int ELEMENT_COLUMN_FIELD_NUMBER = 4;
  private com.google.zetasql.ResolvedColumnHolderProto elementColumn_;
  /**
   * <pre>
   * The ResolvedColumn introduced to represent the elements of the
   * array being updated.  This works similarly to
   * ArrayScan::element_column.
   * &lt;target&gt; must have array type, and this column has the array's
   * element type.
   * This column can be referenced inside the nested statements below.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
   */
  public boolean hasElementColumn() {
    return ((bitField0_ & 0x00000008) == 0x00000008);
  }
  /**
   * <pre>
   * The ResolvedColumn introduced to represent the elements of the
   * array being updated.  This works similarly to
   * ArrayScan::element_column.
   * &lt;target&gt; must have array type, and this column has the array's
   * element type.
   * This column can be referenced inside the nested statements below.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
   */
  public com.google.zetasql.ResolvedColumnHolderProto getElementColumn() {
    return elementColumn_ == null ? com.google.zetasql.ResolvedColumnHolderProto.getDefaultInstance() : elementColumn_;
  }
  /**
   * <pre>
   * The ResolvedColumn introduced to represent the elements of the
   * array being updated.  This works similarly to
   * ArrayScan::element_column.
   * &lt;target&gt; must have array type, and this column has the array's
   * element type.
   * This column can be referenced inside the nested statements below.
   * </pre>
   *
   * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
   */
  public com.google.zetasql.ResolvedColumnHolderProtoOrBuilder getElementColumnOrBuilder() {
    return elementColumn_ == null ? com.google.zetasql.ResolvedColumnHolderProto.getDefaultInstance() : elementColumn_;
  }

  public static final int ARRAY_UPDATE_LIST_FIELD_NUMBER = 8;
  private java.util.List<com.google.zetasql.ResolvedUpdateArrayItemProto> arrayUpdateList_;
  /**
   * <pre>
   * Array element modifications to apply. Each item runs on the value
   * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
   * This field is always empty if the analyzer option
   * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
   * The engine must fail if two elements in this list have offset
   * expressions that evaluate to the same value.
   * TODO: Consider generalizing this to allow
   * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedUpdateArrayItemProto> getArrayUpdateListList() {
    return arrayUpdateList_;
  }
  /**
   * <pre>
   * Array element modifications to apply. Each item runs on the value
   * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
   * This field is always empty if the analyzer option
   * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
   * The engine must fail if two elements in this list have offset
   * expressions that evaluate to the same value.
   * TODO: Consider generalizing this to allow
   * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder> 
      getArrayUpdateListOrBuilderList() {
    return arrayUpdateList_;
  }
  /**
   * <pre>
   * Array element modifications to apply. Each item runs on the value
   * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
   * This field is always empty if the analyzer option
   * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
   * The engine must fail if two elements in this list have offset
   * expressions that evaluate to the same value.
   * TODO: Consider generalizing this to allow
   * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
   */
  public int getArrayUpdateListCount() {
    return arrayUpdateList_.size();
  }
  /**
   * <pre>
   * Array element modifications to apply. Each item runs on the value
   * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
   * This field is always empty if the analyzer option
   * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
   * The engine must fail if two elements in this list have offset
   * expressions that evaluate to the same value.
   * TODO: Consider generalizing this to allow
   * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
   */
  public com.google.zetasql.ResolvedUpdateArrayItemProto getArrayUpdateList(int index) {
    return arrayUpdateList_.get(index);
  }
  /**
   * <pre>
   * Array element modifications to apply. Each item runs on the value
   * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
   * This field is always empty if the analyzer option
   * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
   * The engine must fail if two elements in this list have offset
   * expressions that evaluate to the same value.
   * TODO: Consider generalizing this to allow
   * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
   */
  public com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder getArrayUpdateListOrBuilder(
      int index) {
    return arrayUpdateList_.get(index);
  }

  public static final int DELETE_LIST_FIELD_NUMBER = 5;
  private java.util.List<com.google.zetasql.ResolvedDeleteStmtProto> deleteList_;
  /**
   * <pre>
   * Nested DELETE statements to apply.  Each delete runs on one value
   * of &lt;element_column&gt; and may choose to delete that array element.
   * DELETEs are applied before INSERTs or UPDATEs.
   * It is legal for the same input element to match multiple DELETEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedDeleteStmtProto> getDeleteListList() {
    return deleteList_;
  }
  /**
   * <pre>
   * Nested DELETE statements to apply.  Each delete runs on one value
   * of &lt;element_column&gt; and may choose to delete that array element.
   * DELETEs are applied before INSERTs or UPDATEs.
   * It is legal for the same input element to match multiple DELETEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder> 
      getDeleteListOrBuilderList() {
    return deleteList_;
  }
  /**
   * <pre>
   * Nested DELETE statements to apply.  Each delete runs on one value
   * of &lt;element_column&gt; and may choose to delete that array element.
   * DELETEs are applied before INSERTs or UPDATEs.
   * It is legal for the same input element to match multiple DELETEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
   */
  public int getDeleteListCount() {
    return deleteList_.size();
  }
  /**
   * <pre>
   * Nested DELETE statements to apply.  Each delete runs on one value
   * of &lt;element_column&gt; and may choose to delete that array element.
   * DELETEs are applied before INSERTs or UPDATEs.
   * It is legal for the same input element to match multiple DELETEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
   */
  public com.google.zetasql.ResolvedDeleteStmtProto getDeleteList(int index) {
    return deleteList_.get(index);
  }
  /**
   * <pre>
   * Nested DELETE statements to apply.  Each delete runs on one value
   * of &lt;element_column&gt; and may choose to delete that array element.
   * DELETEs are applied before INSERTs or UPDATEs.
   * It is legal for the same input element to match multiple DELETEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
   */
  public com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder getDeleteListOrBuilder(
      int index) {
    return deleteList_.get(index);
  }

  public static final int UPDATE_LIST_FIELD_NUMBER = 6;
  private java.util.List<com.google.zetasql.ResolvedUpdateStmtProto> updateList_;
  /**
   * <pre>
   * Nested UPDATE statements to apply.  Each update runs on one value
   * of &lt;element_column&gt; and may choose to update that array element.
   * UPDATEs are applied after DELETEs and before INSERTs.
   * It is an error if any element is matched by multiple UPDATEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedUpdateStmtProto> getUpdateListList() {
    return updateList_;
  }
  /**
   * <pre>
   * Nested UPDATE statements to apply.  Each update runs on one value
   * of &lt;element_column&gt; and may choose to update that array element.
   * UPDATEs are applied after DELETEs and before INSERTs.
   * It is an error if any element is matched by multiple UPDATEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder> 
      getUpdateListOrBuilderList() {
    return updateList_;
  }
  /**
   * <pre>
   * Nested UPDATE statements to apply.  Each update runs on one value
   * of &lt;element_column&gt; and may choose to update that array element.
   * UPDATEs are applied after DELETEs and before INSERTs.
   * It is an error if any element is matched by multiple UPDATEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
   */
  public int getUpdateListCount() {
    return updateList_.size();
  }
  /**
   * <pre>
   * Nested UPDATE statements to apply.  Each update runs on one value
   * of &lt;element_column&gt; and may choose to update that array element.
   * UPDATEs are applied after DELETEs and before INSERTs.
   * It is an error if any element is matched by multiple UPDATEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
   */
  public com.google.zetasql.ResolvedUpdateStmtProto getUpdateList(int index) {
    return updateList_.get(index);
  }
  /**
   * <pre>
   * Nested UPDATE statements to apply.  Each update runs on one value
   * of &lt;element_column&gt; and may choose to update that array element.
   * UPDATEs are applied after DELETEs and before INSERTs.
   * It is an error if any element is matched by multiple UPDATEs.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
   */
  public com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder getUpdateListOrBuilder(
      int index) {
    return updateList_.get(index);
  }

  public static final int INSERT_LIST_FIELD_NUMBER = 7;
  private java.util.List<com.google.zetasql.ResolvedInsertStmtProto> insertList_;
  /**
   * <pre>
   * Nested INSERT statements to apply.  Each insert will produce zero
   * or more values for &lt;element_column&gt;.
   * INSERTs are applied after DELETEs and UPDATEs.
   * For nested UPDATEs, insert_mode will always be the default, and
   * has no effect.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
   */
  public java.util.List<com.google.zetasql.ResolvedInsertStmtProto> getInsertListList() {
    return insertList_;
  }
  /**
   * <pre>
   * Nested INSERT statements to apply.  Each insert will produce zero
   * or more values for &lt;element_column&gt;.
   * INSERTs are applied after DELETEs and UPDATEs.
   * For nested UPDATEs, insert_mode will always be the default, and
   * has no effect.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
   */
  public java.util.List<? extends com.google.zetasql.ResolvedInsertStmtProtoOrBuilder> 
      getInsertListOrBuilderList() {
    return insertList_;
  }
  /**
   * <pre>
   * Nested INSERT statements to apply.  Each insert will produce zero
   * or more values for &lt;element_column&gt;.
   * INSERTs are applied after DELETEs and UPDATEs.
   * For nested UPDATEs, insert_mode will always be the default, and
   * has no effect.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
   */
  public int getInsertListCount() {
    return insertList_.size();
  }
  /**
   * <pre>
   * Nested INSERT statements to apply.  Each insert will produce zero
   * or more values for &lt;element_column&gt;.
   * INSERTs are applied after DELETEs and UPDATEs.
   * For nested UPDATEs, insert_mode will always be the default, and
   * has no effect.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
   */
  public com.google.zetasql.ResolvedInsertStmtProto getInsertList(int index) {
    return insertList_.get(index);
  }
  /**
   * <pre>
   * Nested INSERT statements to apply.  Each insert will produce zero
   * or more values for &lt;element_column&gt;.
   * INSERTs are applied after DELETEs and UPDATEs.
   * For nested UPDATEs, insert_mode will always be the default, and
   * has no effect.
   * </pre>
   *
   * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
   */
  public com.google.zetasql.ResolvedInsertStmtProtoOrBuilder getInsertListOrBuilder(
      int index) {
    return insertList_.get(index);
  }

  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.zetasql.ResolvedUpdateItemProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.zetasql.ResolvedUpdateItemProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This represents one item inside the SET clause of an UPDATE.
   * The entity being updated is specified by &lt;target&gt;.
   * For a regular
   *   SET {target} = {expression} | DEFAULT
   * clause (not including an array element update like SET a[OFFSET(0)] = 5),
   * &lt;target&gt; and &lt;set_value&gt; will be present, and all other fields will be
   * unset.
   * For an array element update (e.g. SET a.b[&lt;expr&gt;].c = &lt;value&gt;),
   *   - &lt;target&gt; is set to the array,
   *   - &lt;element_column&gt; is a new ResolvedColumn that can be used inside the
   *     update items to refer to the array element.
   *   - &lt;array_update_list&gt; will have a node corresponding to the offset into
   *     that array and the modification to that array element.
   * For example, for SET a.b[&lt;expr&gt;].c = &lt;value&gt;, we have
   *    ResolvedUpdateItem
   *    +-&lt;target&gt; = a.b
   *    +-&lt;element_column&gt; = &lt;x&gt;
   *    +-&lt;array_update_list&gt;
   *      +-ResolvedUpdateArrayItem
   *        +-&lt;offset&gt; = &lt;expr&gt;
   *        +-&lt;update_item&gt; = ResolvedUpdateItem
   *          +-&lt;target&gt; = &lt;x&gt;.c
   *          +-&lt;set_value&gt; = &lt;value&gt;
   * The engine is required to fail the update if there are two elements of
   * &lt;array_update_list&gt; corresponding to offset expressions that evaluate to
   * the same value. These are considered to be conflicting updates.
   * Multiple updates to the same array are always represented as multiple
   * elements of &lt;array_update_list&gt; under a single ResolvedUpdateItem
   * corresponding to that array. &lt;array_update_list&gt; will only have one
   * element for modifications to an array-valued subfield of an array element.
   * E.g., for SET a[&lt;expr1&gt;].b[&lt;expr2&gt;] = 5, a[&lt;expr3&gt;].b[&lt;expr4&gt;] = 6, we
   * will have:
   *     ResolvedUpdateItem
   *     +-&lt;target&gt; = a
   *     +-&lt;element_column&gt; = x
   *     +-&lt;array_update_list&gt;
   *       +-ResolvedUpdateArrayItem
   *         +-&lt;offset&gt; = &lt;expr1&gt;
   *         +-ResolvedUpdateItem for &lt;x&gt;.b[&lt;expr2&gt;] = 5
   *       +-ResolvedUpdateArrayItem
   *         +-&lt;offset&gt; = &lt;expr3&gt;
   *         +-ResolvedUpdateItem for &lt;x&gt;.b[&lt;expr4&gt;] = 6
   * The engine must give a runtime error if &lt;expr1&gt; and &lt;expr3&gt; evaluate to
   * the same thing. Notably, it does not have to understand that the
   * two ResolvedUpdateItems corresponding to "b" refer to the same array iff
   * &lt;expr1&gt; and &lt;expr3&gt; evaluate to the same thing.
   * TODO: Consider allowing the engine to execute an update like
   * SET a[&lt;expr1&gt;].b = 1, a[&lt;expr2&gt;].c = 2 even if &lt;expr1&gt; == &lt;expr2&gt; since
   * "b" and "c" do not overlap. Also consider allowing a more complex example
   * like SET a[&lt;expr1&gt;].b[&lt;expr2&gt;] = ...,
   * a[&lt;expr3&gt;].b[&lt;expr4&gt;].c[&lt;expr5&gt;] = ... even if &lt;expr1&gt; == &lt;expr3&gt;, as long
   * as &lt;expr2&gt; != &lt;expr4&gt; in that case.
   * For nested DML, &lt;target&gt; and &lt;element_column&gt; will both be set, and one or
   * more of the nested statement lists will be non-empty. &lt;target&gt; must have
   * ARRAY type, and &lt;element_column&gt; introduces a ResolvedColumn representing
   * elements of that array. The nested statement lists will always be empty in
   * a ResolvedUpdateItem child of a ResolvedUpdateArrayItem node.
   * See (broken link) for more detail.
   * </pre>
   *
   * Protobuf type {@code zetasql.ResolvedUpdateItemProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:zetasql.ResolvedUpdateItemProto)
      com.google.zetasql.ResolvedUpdateItemProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUpdateItemProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUpdateItemProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.zetasql.ResolvedUpdateItemProto.class, com.google.zetasql.ResolvedUpdateItemProto.Builder.class);
    }

    // Construct using com.google.zetasql.ResolvedUpdateItemProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getTargetFieldBuilder();
        getSetValueFieldBuilder();
        getElementColumnFieldBuilder();
        getArrayUpdateListFieldBuilder();
        getDeleteListFieldBuilder();
        getUpdateListFieldBuilder();
        getInsertListFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (parentBuilder_ == null) {
        parent_ = null;
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (targetBuilder_ == null) {
        target_ = null;
      } else {
        targetBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (setValueBuilder_ == null) {
        setValue_ = null;
      } else {
        setValueBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (elementColumnBuilder_ == null) {
        elementColumn_ = null;
      } else {
        elementColumnBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (arrayUpdateListBuilder_ == null) {
        arrayUpdateList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        arrayUpdateListBuilder_.clear();
      }
      if (deleteListBuilder_ == null) {
        deleteList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        deleteListBuilder_.clear();
      }
      if (updateListBuilder_ == null) {
        updateList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
      } else {
        updateListBuilder_.clear();
      }
      if (insertListBuilder_ == null) {
        insertList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
      } else {
        insertListBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.zetasql.ZetaSQLResolvedAST.internal_static_zetasql_ResolvedUpdateItemProto_descriptor;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUpdateItemProto getDefaultInstanceForType() {
      return com.google.zetasql.ResolvedUpdateItemProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUpdateItemProto build() {
      com.google.zetasql.ResolvedUpdateItemProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.zetasql.ResolvedUpdateItemProto buildPartial() {
      com.google.zetasql.ResolvedUpdateItemProto result = new com.google.zetasql.ResolvedUpdateItemProto(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
        to_bitField0_ |= 0x00000001;
      }
      if (parentBuilder_ == null) {
        result.parent_ = parent_;
      } else {
        result.parent_ = parentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
        to_bitField0_ |= 0x00000002;
      }
      if (targetBuilder_ == null) {
        result.target_ = target_;
      } else {
        result.target_ = targetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
        to_bitField0_ |= 0x00000004;
      }
      if (setValueBuilder_ == null) {
        result.setValue_ = setValue_;
      } else {
        result.setValue_ = setValueBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
        to_bitField0_ |= 0x00000008;
      }
      if (elementColumnBuilder_ == null) {
        result.elementColumn_ = elementColumn_;
      } else {
        result.elementColumn_ = elementColumnBuilder_.build();
      }
      if (arrayUpdateListBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          arrayUpdateList_ = java.util.Collections.unmodifiableList(arrayUpdateList_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.arrayUpdateList_ = arrayUpdateList_;
      } else {
        result.arrayUpdateList_ = arrayUpdateListBuilder_.build();
      }
      if (deleteListBuilder_ == null) {
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          deleteList_ = java.util.Collections.unmodifiableList(deleteList_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.deleteList_ = deleteList_;
      } else {
        result.deleteList_ = deleteListBuilder_.build();
      }
      if (updateListBuilder_ == null) {
        if (((bitField0_ & 0x00000040) == 0x00000040)) {
          updateList_ = java.util.Collections.unmodifiableList(updateList_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.updateList_ = updateList_;
      } else {
        result.updateList_ = updateListBuilder_.build();
      }
      if (insertListBuilder_ == null) {
        if (((bitField0_ & 0x00000080) == 0x00000080)) {
          insertList_ = java.util.Collections.unmodifiableList(insertList_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.insertList_ = insertList_;
      } else {
        result.insertList_ = insertListBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    private int bitField0_;

    private com.google.zetasql.ResolvedArgumentProto parent_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedArgumentProto, com.google.zetasql.ResolvedArgumentProto.Builder, com.google.zetasql.ResolvedArgumentProtoOrBuilder> parentBuilder_;
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedArgumentProto getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null ? com.google.zetasql.ResolvedArgumentProto.getDefaultInstance() : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public Builder setParent(com.google.zetasql.ResolvedArgumentProto value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        onChanged();
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public Builder setParent(
        com.google.zetasql.ResolvedArgumentProto.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
        onChanged();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public Builder mergeParent(com.google.zetasql.ResolvedArgumentProto value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) == 0x00000001) &&
            parent_ != null &&
            parent_ != com.google.zetasql.ResolvedArgumentProto.getDefaultInstance()) {
          parent_ =
            com.google.zetasql.ResolvedArgumentProto.newBuilder(parent_).mergeFrom(value).buildPartial();
        } else {
          parent_ = value;
        }
        onChanged();
      } else {
        parentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public Builder clearParent() {
      if (parentBuilder_ == null) {
        parent_ = null;
        onChanged();
      } else {
        parentBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedArgumentProto.Builder getParentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    public com.google.zetasql.ResolvedArgumentProtoOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null ?
            com.google.zetasql.ResolvedArgumentProto.getDefaultInstance() : parent_;
      }
    }
    /**
     * <code>optional .zetasql.ResolvedArgumentProto parent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedArgumentProto, com.google.zetasql.ResolvedArgumentProto.Builder, com.google.zetasql.ResolvedArgumentProtoOrBuilder> 
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedArgumentProto, com.google.zetasql.ResolvedArgumentProto.Builder, com.google.zetasql.ResolvedArgumentProtoOrBuilder>(
                getParent(),
                getParentForChildren(),
                isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private com.google.zetasql.AnyResolvedExprProto target_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> targetBuilder_;
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public boolean hasTarget() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto getTarget() {
      if (targetBuilder_ == null) {
        return target_ == null ? com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : target_;
      } else {
        return targetBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public Builder setTarget(com.google.zetasql.AnyResolvedExprProto value) {
      if (targetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        targetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public Builder setTarget(
        com.google.zetasql.AnyResolvedExprProto.Builder builderForValue) {
      if (targetBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        targetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public Builder mergeTarget(com.google.zetasql.AnyResolvedExprProto value) {
      if (targetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002) &&
            target_ != null &&
            target_ != com.google.zetasql.AnyResolvedExprProto.getDefaultInstance()) {
          target_ =
            com.google.zetasql.AnyResolvedExprProto.newBuilder(target_).mergeFrom(value).buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        targetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public Builder clearTarget() {
      if (targetBuilder_ == null) {
        target_ = null;
        onChanged();
      } else {
        targetBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public com.google.zetasql.AnyResolvedExprProto.Builder getTargetBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTargetFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    public com.google.zetasql.AnyResolvedExprProtoOrBuilder getTargetOrBuilder() {
      if (targetBuilder_ != null) {
        return targetBuilder_.getMessageOrBuilder();
      } else {
        return target_ == null ?
            com.google.zetasql.AnyResolvedExprProto.getDefaultInstance() : target_;
      }
    }
    /**
     * <pre>
     * The target entity to be updated.
     * This is an expression evaluated using the ResolvedColumns visible
     * inside this statement.  This expression can contain only
     * ResolvedColumnRefs, ResolvedGetProtoField and
     * ResolvedGetStructField nodes.
     * In a top-level UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing a column from the statement's
     * TableScan.
     * In a nested UPDATE, the expression always starts with a
     * ResolvedColumnRef referencing the element_column from the
     * ResolvedUpdateItem containing this scan.
     * This node is also used to represent a modification of a single
     * array element (when it occurs as a child of a
     * ResolvedUpdateArrayItem node).  In that case, the expression
     * starts with a ResolvedColumnRef referencing the &lt;element_column&gt;
     * from its grandparent ResolvedUpdateItem. (E.g., for "SET a[&lt;expr&gt;]
     * = 5", the grandparent ResolvedUpdateItem has &lt;target&gt; "a", the
     * parent ResolvedUpdateArrayItem has offset &lt;expr&gt;, and this node
     * has &lt;set_value&gt; 5 and target corresponding to the grandparent's
     * &lt;element_column&gt; field.)
     * For either a nested UPDATE or an array modification, there may be
     * a path of field accesses after the initial ResolvedColumnRef,
     * represented by a chain of GetField nodes.
     * NOTE: We use the same GetField nodes as we do for queries, but
     * they are not treated the same.  Here, they express a path inside
     * an object that is being mutated, so they have reference semantics.
     * </pre>
     *
     * <code>optional .zetasql.AnyResolvedExprProto target = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder> 
        getTargetFieldBuilder() {
      if (targetBuilder_ == null) {
        targetBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.AnyResolvedExprProto, com.google.zetasql.AnyResolvedExprProto.Builder, com.google.zetasql.AnyResolvedExprProtoOrBuilder>(
                getTarget(),
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      return targetBuilder_;
    }

    private com.google.zetasql.ResolvedDMLValueProto setValue_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedDMLValueProto, com.google.zetasql.ResolvedDMLValueProto.Builder, com.google.zetasql.ResolvedDMLValueProtoOrBuilder> setValueBuilder_;
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public boolean hasSetValue() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public com.google.zetasql.ResolvedDMLValueProto getSetValue() {
      if (setValueBuilder_ == null) {
        return setValue_ == null ? com.google.zetasql.ResolvedDMLValueProto.getDefaultInstance() : setValue_;
      } else {
        return setValueBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public Builder setSetValue(com.google.zetasql.ResolvedDMLValueProto value) {
      if (setValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        setValue_ = value;
        onChanged();
      } else {
        setValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public Builder setSetValue(
        com.google.zetasql.ResolvedDMLValueProto.Builder builderForValue) {
      if (setValueBuilder_ == null) {
        setValue_ = builderForValue.build();
        onChanged();
      } else {
        setValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public Builder mergeSetValue(com.google.zetasql.ResolvedDMLValueProto value) {
      if (setValueBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004) &&
            setValue_ != null &&
            setValue_ != com.google.zetasql.ResolvedDMLValueProto.getDefaultInstance()) {
          setValue_ =
            com.google.zetasql.ResolvedDMLValueProto.newBuilder(setValue_).mergeFrom(value).buildPartial();
        } else {
          setValue_ = value;
        }
        onChanged();
      } else {
        setValueBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public Builder clearSetValue() {
      if (setValueBuilder_ == null) {
        setValue_ = null;
        onChanged();
      } else {
        setValueBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public com.google.zetasql.ResolvedDMLValueProto.Builder getSetValueBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSetValueFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    public com.google.zetasql.ResolvedDMLValueProtoOrBuilder getSetValueOrBuilder() {
      if (setValueBuilder_ != null) {
        return setValueBuilder_.getMessageOrBuilder();
      } else {
        return setValue_ == null ?
            com.google.zetasql.ResolvedDMLValueProto.getDefaultInstance() : setValue_;
      }
    }
    /**
     * <pre>
     * Set the target entity to this value.  The types must match.
     * This can contain the same columns that can appear in the
     * &lt;where_expr&gt; of the enclosing ResolvedUpdateStmt.
     * This is mutually exclusive with all fields below, which are used
     * for nested updates only.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedDMLValueProto set_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedDMLValueProto, com.google.zetasql.ResolvedDMLValueProto.Builder, com.google.zetasql.ResolvedDMLValueProtoOrBuilder> 
        getSetValueFieldBuilder() {
      if (setValueBuilder_ == null) {
        setValueBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedDMLValueProto, com.google.zetasql.ResolvedDMLValueProto.Builder, com.google.zetasql.ResolvedDMLValueProtoOrBuilder>(
                getSetValue(),
                getParentForChildren(),
                isClean());
        setValue_ = null;
      }
      return setValueBuilder_;
    }

    private com.google.zetasql.ResolvedColumnHolderProto elementColumn_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedColumnHolderProto, com.google.zetasql.ResolvedColumnHolderProto.Builder, com.google.zetasql.ResolvedColumnHolderProtoOrBuilder> elementColumnBuilder_;
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public boolean hasElementColumn() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public com.google.zetasql.ResolvedColumnHolderProto getElementColumn() {
      if (elementColumnBuilder_ == null) {
        return elementColumn_ == null ? com.google.zetasql.ResolvedColumnHolderProto.getDefaultInstance() : elementColumn_;
      } else {
        return elementColumnBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public Builder setElementColumn(com.google.zetasql.ResolvedColumnHolderProto value) {
      if (elementColumnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementColumn_ = value;
        onChanged();
      } else {
        elementColumnBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public Builder setElementColumn(
        com.google.zetasql.ResolvedColumnHolderProto.Builder builderForValue) {
      if (elementColumnBuilder_ == null) {
        elementColumn_ = builderForValue.build();
        onChanged();
      } else {
        elementColumnBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public Builder mergeElementColumn(com.google.zetasql.ResolvedColumnHolderProto value) {
      if (elementColumnBuilder_ == null) {
        if (((bitField0_ & 0x00000008) == 0x00000008) &&
            elementColumn_ != null &&
            elementColumn_ != com.google.zetasql.ResolvedColumnHolderProto.getDefaultInstance()) {
          elementColumn_ =
            com.google.zetasql.ResolvedColumnHolderProto.newBuilder(elementColumn_).mergeFrom(value).buildPartial();
        } else {
          elementColumn_ = value;
        }
        onChanged();
      } else {
        elementColumnBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public Builder clearElementColumn() {
      if (elementColumnBuilder_ == null) {
        elementColumn_ = null;
        onChanged();
      } else {
        elementColumnBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public com.google.zetasql.ResolvedColumnHolderProto.Builder getElementColumnBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getElementColumnFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    public com.google.zetasql.ResolvedColumnHolderProtoOrBuilder getElementColumnOrBuilder() {
      if (elementColumnBuilder_ != null) {
        return elementColumnBuilder_.getMessageOrBuilder();
      } else {
        return elementColumn_ == null ?
            com.google.zetasql.ResolvedColumnHolderProto.getDefaultInstance() : elementColumn_;
      }
    }
    /**
     * <pre>
     * The ResolvedColumn introduced to represent the elements of the
     * array being updated.  This works similarly to
     * ArrayScan::element_column.
     * &lt;target&gt; must have array type, and this column has the array's
     * element type.
     * This column can be referenced inside the nested statements below.
     * </pre>
     *
     * <code>optional .zetasql.ResolvedColumnHolderProto element_column = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.zetasql.ResolvedColumnHolderProto, com.google.zetasql.ResolvedColumnHolderProto.Builder, com.google.zetasql.ResolvedColumnHolderProtoOrBuilder> 
        getElementColumnFieldBuilder() {
      if (elementColumnBuilder_ == null) {
        elementColumnBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.zetasql.ResolvedColumnHolderProto, com.google.zetasql.ResolvedColumnHolderProto.Builder, com.google.zetasql.ResolvedColumnHolderProtoOrBuilder>(
                getElementColumn(),
                getParentForChildren(),
                isClean());
        elementColumn_ = null;
      }
      return elementColumnBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedUpdateArrayItemProto> arrayUpdateList_ =
      java.util.Collections.emptyList();
    private void ensureArrayUpdateListIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        arrayUpdateList_ = new java.util.ArrayList<com.google.zetasql.ResolvedUpdateArrayItemProto>(arrayUpdateList_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUpdateArrayItemProto, com.google.zetasql.ResolvedUpdateArrayItemProto.Builder, com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder> arrayUpdateListBuilder_;

    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUpdateArrayItemProto> getArrayUpdateListList() {
      if (arrayUpdateListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(arrayUpdateList_);
      } else {
        return arrayUpdateListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public int getArrayUpdateListCount() {
      if (arrayUpdateListBuilder_ == null) {
        return arrayUpdateList_.size();
      } else {
        return arrayUpdateListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public com.google.zetasql.ResolvedUpdateArrayItemProto getArrayUpdateList(int index) {
      if (arrayUpdateListBuilder_ == null) {
        return arrayUpdateList_.get(index);
      } else {
        return arrayUpdateListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder setArrayUpdateList(
        int index, com.google.zetasql.ResolvedUpdateArrayItemProto value) {
      if (arrayUpdateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.set(index, value);
        onChanged();
      } else {
        arrayUpdateListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder setArrayUpdateList(
        int index, com.google.zetasql.ResolvedUpdateArrayItemProto.Builder builderForValue) {
      if (arrayUpdateListBuilder_ == null) {
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.set(index, builderForValue.build());
        onChanged();
      } else {
        arrayUpdateListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder addArrayUpdateList(com.google.zetasql.ResolvedUpdateArrayItemProto value) {
      if (arrayUpdateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.add(value);
        onChanged();
      } else {
        arrayUpdateListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder addArrayUpdateList(
        int index, com.google.zetasql.ResolvedUpdateArrayItemProto value) {
      if (arrayUpdateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.add(index, value);
        onChanged();
      } else {
        arrayUpdateListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder addArrayUpdateList(
        com.google.zetasql.ResolvedUpdateArrayItemProto.Builder builderForValue) {
      if (arrayUpdateListBuilder_ == null) {
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.add(builderForValue.build());
        onChanged();
      } else {
        arrayUpdateListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder addArrayUpdateList(
        int index, com.google.zetasql.ResolvedUpdateArrayItemProto.Builder builderForValue) {
      if (arrayUpdateListBuilder_ == null) {
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.add(index, builderForValue.build());
        onChanged();
      } else {
        arrayUpdateListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder addAllArrayUpdateList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedUpdateArrayItemProto> values) {
      if (arrayUpdateListBuilder_ == null) {
        ensureArrayUpdateListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, arrayUpdateList_);
        onChanged();
      } else {
        arrayUpdateListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder clearArrayUpdateList() {
      if (arrayUpdateListBuilder_ == null) {
        arrayUpdateList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        arrayUpdateListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public Builder removeArrayUpdateList(int index) {
      if (arrayUpdateListBuilder_ == null) {
        ensureArrayUpdateListIsMutable();
        arrayUpdateList_.remove(index);
        onChanged();
      } else {
        arrayUpdateListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public com.google.zetasql.ResolvedUpdateArrayItemProto.Builder getArrayUpdateListBuilder(
        int index) {
      return getArrayUpdateListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder getArrayUpdateListOrBuilder(
        int index) {
      if (arrayUpdateListBuilder_ == null) {
        return arrayUpdateList_.get(index);  } else {
        return arrayUpdateListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder> 
         getArrayUpdateListOrBuilderList() {
      if (arrayUpdateListBuilder_ != null) {
        return arrayUpdateListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(arrayUpdateList_);
      }
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public com.google.zetasql.ResolvedUpdateArrayItemProto.Builder addArrayUpdateListBuilder() {
      return getArrayUpdateListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedUpdateArrayItemProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public com.google.zetasql.ResolvedUpdateArrayItemProto.Builder addArrayUpdateListBuilder(
        int index) {
      return getArrayUpdateListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedUpdateArrayItemProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Array element modifications to apply. Each item runs on the value
     * of &lt;element_column&gt; specified by ResolvedUpdateArrayItem.offset.
     * This field is always empty if the analyzer option
     * FEATURE_V_1_2_ARRAY_ELEMENTS_WITH_SET is disabled.
     * The engine must fail if two elements in this list have offset
     * expressions that evaluate to the same value.
     * TODO: Consider generalizing this to allow
     * SET a[&lt;expr1&gt;].b = ..., a[&lt;expr2&gt;].c = ...
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateArrayItemProto array_update_list = 8;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUpdateArrayItemProto.Builder> 
         getArrayUpdateListBuilderList() {
      return getArrayUpdateListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUpdateArrayItemProto, com.google.zetasql.ResolvedUpdateArrayItemProto.Builder, com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder> 
        getArrayUpdateListFieldBuilder() {
      if (arrayUpdateListBuilder_ == null) {
        arrayUpdateListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedUpdateArrayItemProto, com.google.zetasql.ResolvedUpdateArrayItemProto.Builder, com.google.zetasql.ResolvedUpdateArrayItemProtoOrBuilder>(
                arrayUpdateList_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        arrayUpdateList_ = null;
      }
      return arrayUpdateListBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedDeleteStmtProto> deleteList_ =
      java.util.Collections.emptyList();
    private void ensureDeleteListIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        deleteList_ = new java.util.ArrayList<com.google.zetasql.ResolvedDeleteStmtProto>(deleteList_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedDeleteStmtProto, com.google.zetasql.ResolvedDeleteStmtProto.Builder, com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder> deleteListBuilder_;

    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedDeleteStmtProto> getDeleteListList() {
      if (deleteListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deleteList_);
      } else {
        return deleteListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public int getDeleteListCount() {
      if (deleteListBuilder_ == null) {
        return deleteList_.size();
      } else {
        return deleteListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public com.google.zetasql.ResolvedDeleteStmtProto getDeleteList(int index) {
      if (deleteListBuilder_ == null) {
        return deleteList_.get(index);
      } else {
        return deleteListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder setDeleteList(
        int index, com.google.zetasql.ResolvedDeleteStmtProto value) {
      if (deleteListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeleteListIsMutable();
        deleteList_.set(index, value);
        onChanged();
      } else {
        deleteListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder setDeleteList(
        int index, com.google.zetasql.ResolvedDeleteStmtProto.Builder builderForValue) {
      if (deleteListBuilder_ == null) {
        ensureDeleteListIsMutable();
        deleteList_.set(index, builderForValue.build());
        onChanged();
      } else {
        deleteListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder addDeleteList(com.google.zetasql.ResolvedDeleteStmtProto value) {
      if (deleteListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeleteListIsMutable();
        deleteList_.add(value);
        onChanged();
      } else {
        deleteListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder addDeleteList(
        int index, com.google.zetasql.ResolvedDeleteStmtProto value) {
      if (deleteListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeleteListIsMutable();
        deleteList_.add(index, value);
        onChanged();
      } else {
        deleteListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder addDeleteList(
        com.google.zetasql.ResolvedDeleteStmtProto.Builder builderForValue) {
      if (deleteListBuilder_ == null) {
        ensureDeleteListIsMutable();
        deleteList_.add(builderForValue.build());
        onChanged();
      } else {
        deleteListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder addDeleteList(
        int index, com.google.zetasql.ResolvedDeleteStmtProto.Builder builderForValue) {
      if (deleteListBuilder_ == null) {
        ensureDeleteListIsMutable();
        deleteList_.add(index, builderForValue.build());
        onChanged();
      } else {
        deleteListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder addAllDeleteList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedDeleteStmtProto> values) {
      if (deleteListBuilder_ == null) {
        ensureDeleteListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, deleteList_);
        onChanged();
      } else {
        deleteListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder clearDeleteList() {
      if (deleteListBuilder_ == null) {
        deleteList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        deleteListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public Builder removeDeleteList(int index) {
      if (deleteListBuilder_ == null) {
        ensureDeleteListIsMutable();
        deleteList_.remove(index);
        onChanged();
      } else {
        deleteListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public com.google.zetasql.ResolvedDeleteStmtProto.Builder getDeleteListBuilder(
        int index) {
      return getDeleteListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder getDeleteListOrBuilder(
        int index) {
      if (deleteListBuilder_ == null) {
        return deleteList_.get(index);  } else {
        return deleteListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder> 
         getDeleteListOrBuilderList() {
      if (deleteListBuilder_ != null) {
        return deleteListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deleteList_);
      }
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public com.google.zetasql.ResolvedDeleteStmtProto.Builder addDeleteListBuilder() {
      return getDeleteListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedDeleteStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public com.google.zetasql.ResolvedDeleteStmtProto.Builder addDeleteListBuilder(
        int index) {
      return getDeleteListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedDeleteStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested DELETE statements to apply.  Each delete runs on one value
     * of &lt;element_column&gt; and may choose to delete that array element.
     * DELETEs are applied before INSERTs or UPDATEs.
     * It is legal for the same input element to match multiple DELETEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedDeleteStmtProto delete_list = 5;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedDeleteStmtProto.Builder> 
         getDeleteListBuilderList() {
      return getDeleteListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedDeleteStmtProto, com.google.zetasql.ResolvedDeleteStmtProto.Builder, com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder> 
        getDeleteListFieldBuilder() {
      if (deleteListBuilder_ == null) {
        deleteListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedDeleteStmtProto, com.google.zetasql.ResolvedDeleteStmtProto.Builder, com.google.zetasql.ResolvedDeleteStmtProtoOrBuilder>(
                deleteList_,
                ((bitField0_ & 0x00000020) == 0x00000020),
                getParentForChildren(),
                isClean());
        deleteList_ = null;
      }
      return deleteListBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedUpdateStmtProto> updateList_ =
      java.util.Collections.emptyList();
    private void ensureUpdateListIsMutable() {
      if (!((bitField0_ & 0x00000040) == 0x00000040)) {
        updateList_ = new java.util.ArrayList<com.google.zetasql.ResolvedUpdateStmtProto>(updateList_);
        bitField0_ |= 0x00000040;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUpdateStmtProto, com.google.zetasql.ResolvedUpdateStmtProto.Builder, com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder> updateListBuilder_;

    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUpdateStmtProto> getUpdateListList() {
      if (updateListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(updateList_);
      } else {
        return updateListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public int getUpdateListCount() {
      if (updateListBuilder_ == null) {
        return updateList_.size();
      } else {
        return updateListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUpdateStmtProto getUpdateList(int index) {
      if (updateListBuilder_ == null) {
        return updateList_.get(index);
      } else {
        return updateListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder setUpdateList(
        int index, com.google.zetasql.ResolvedUpdateStmtProto value) {
      if (updateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpdateListIsMutable();
        updateList_.set(index, value);
        onChanged();
      } else {
        updateListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder setUpdateList(
        int index, com.google.zetasql.ResolvedUpdateStmtProto.Builder builderForValue) {
      if (updateListBuilder_ == null) {
        ensureUpdateListIsMutable();
        updateList_.set(index, builderForValue.build());
        onChanged();
      } else {
        updateListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder addUpdateList(com.google.zetasql.ResolvedUpdateStmtProto value) {
      if (updateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpdateListIsMutable();
        updateList_.add(value);
        onChanged();
      } else {
        updateListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder addUpdateList(
        int index, com.google.zetasql.ResolvedUpdateStmtProto value) {
      if (updateListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpdateListIsMutable();
        updateList_.add(index, value);
        onChanged();
      } else {
        updateListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder addUpdateList(
        com.google.zetasql.ResolvedUpdateStmtProto.Builder builderForValue) {
      if (updateListBuilder_ == null) {
        ensureUpdateListIsMutable();
        updateList_.add(builderForValue.build());
        onChanged();
      } else {
        updateListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder addUpdateList(
        int index, com.google.zetasql.ResolvedUpdateStmtProto.Builder builderForValue) {
      if (updateListBuilder_ == null) {
        ensureUpdateListIsMutable();
        updateList_.add(index, builderForValue.build());
        onChanged();
      } else {
        updateListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder addAllUpdateList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedUpdateStmtProto> values) {
      if (updateListBuilder_ == null) {
        ensureUpdateListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, updateList_);
        onChanged();
      } else {
        updateListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder clearUpdateList() {
      if (updateListBuilder_ == null) {
        updateList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        updateListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public Builder removeUpdateList(int index) {
      if (updateListBuilder_ == null) {
        ensureUpdateListIsMutable();
        updateList_.remove(index);
        onChanged();
      } else {
        updateListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUpdateStmtProto.Builder getUpdateListBuilder(
        int index) {
      return getUpdateListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder getUpdateListOrBuilder(
        int index) {
      if (updateListBuilder_ == null) {
        return updateList_.get(index);  } else {
        return updateListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder> 
         getUpdateListOrBuilderList() {
      if (updateListBuilder_ != null) {
        return updateListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(updateList_);
      }
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUpdateStmtProto.Builder addUpdateListBuilder() {
      return getUpdateListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedUpdateStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public com.google.zetasql.ResolvedUpdateStmtProto.Builder addUpdateListBuilder(
        int index) {
      return getUpdateListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedUpdateStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested UPDATE statements to apply.  Each update runs on one value
     * of &lt;element_column&gt; and may choose to update that array element.
     * UPDATEs are applied after DELETEs and before INSERTs.
     * It is an error if any element is matched by multiple UPDATEs.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedUpdateStmtProto update_list = 6;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedUpdateStmtProto.Builder> 
         getUpdateListBuilderList() {
      return getUpdateListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedUpdateStmtProto, com.google.zetasql.ResolvedUpdateStmtProto.Builder, com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder> 
        getUpdateListFieldBuilder() {
      if (updateListBuilder_ == null) {
        updateListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedUpdateStmtProto, com.google.zetasql.ResolvedUpdateStmtProto.Builder, com.google.zetasql.ResolvedUpdateStmtProtoOrBuilder>(
                updateList_,
                ((bitField0_ & 0x00000040) == 0x00000040),
                getParentForChildren(),
                isClean());
        updateList_ = null;
      }
      return updateListBuilder_;
    }

    private java.util.List<com.google.zetasql.ResolvedInsertStmtProto> insertList_ =
      java.util.Collections.emptyList();
    private void ensureInsertListIsMutable() {
      if (!((bitField0_ & 0x00000080) == 0x00000080)) {
        insertList_ = new java.util.ArrayList<com.google.zetasql.ResolvedInsertStmtProto>(insertList_);
        bitField0_ |= 0x00000080;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedInsertStmtProto, com.google.zetasql.ResolvedInsertStmtProto.Builder, com.google.zetasql.ResolvedInsertStmtProtoOrBuilder> insertListBuilder_;

    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedInsertStmtProto> getInsertListList() {
      if (insertListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(insertList_);
      } else {
        return insertListBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public int getInsertListCount() {
      if (insertListBuilder_ == null) {
        return insertList_.size();
      } else {
        return insertListBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public com.google.zetasql.ResolvedInsertStmtProto getInsertList(int index) {
      if (insertListBuilder_ == null) {
        return insertList_.get(index);
      } else {
        return insertListBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder setInsertList(
        int index, com.google.zetasql.ResolvedInsertStmtProto value) {
      if (insertListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInsertListIsMutable();
        insertList_.set(index, value);
        onChanged();
      } else {
        insertListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder setInsertList(
        int index, com.google.zetasql.ResolvedInsertStmtProto.Builder builderForValue) {
      if (insertListBuilder_ == null) {
        ensureInsertListIsMutable();
        insertList_.set(index, builderForValue.build());
        onChanged();
      } else {
        insertListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder addInsertList(com.google.zetasql.ResolvedInsertStmtProto value) {
      if (insertListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInsertListIsMutable();
        insertList_.add(value);
        onChanged();
      } else {
        insertListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder addInsertList(
        int index, com.google.zetasql.ResolvedInsertStmtProto value) {
      if (insertListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInsertListIsMutable();
        insertList_.add(index, value);
        onChanged();
      } else {
        insertListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder addInsertList(
        com.google.zetasql.ResolvedInsertStmtProto.Builder builderForValue) {
      if (insertListBuilder_ == null) {
        ensureInsertListIsMutable();
        insertList_.add(builderForValue.build());
        onChanged();
      } else {
        insertListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder addInsertList(
        int index, com.google.zetasql.ResolvedInsertStmtProto.Builder builderForValue) {
      if (insertListBuilder_ == null) {
        ensureInsertListIsMutable();
        insertList_.add(index, builderForValue.build());
        onChanged();
      } else {
        insertListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder addAllInsertList(
        java.lang.Iterable<? extends com.google.zetasql.ResolvedInsertStmtProto> values) {
      if (insertListBuilder_ == null) {
        ensureInsertListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, insertList_);
        onChanged();
      } else {
        insertListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder clearInsertList() {
      if (insertListBuilder_ == null) {
        insertList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        insertListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public Builder removeInsertList(int index) {
      if (insertListBuilder_ == null) {
        ensureInsertListIsMutable();
        insertList_.remove(index);
        onChanged();
      } else {
        insertListBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public com.google.zetasql.ResolvedInsertStmtProto.Builder getInsertListBuilder(
        int index) {
      return getInsertListFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public com.google.zetasql.ResolvedInsertStmtProtoOrBuilder getInsertListOrBuilder(
        int index) {
      if (insertListBuilder_ == null) {
        return insertList_.get(index);  } else {
        return insertListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public java.util.List<? extends com.google.zetasql.ResolvedInsertStmtProtoOrBuilder> 
         getInsertListOrBuilderList() {
      if (insertListBuilder_ != null) {
        return insertListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(insertList_);
      }
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public com.google.zetasql.ResolvedInsertStmtProto.Builder addInsertListBuilder() {
      return getInsertListFieldBuilder().addBuilder(
          com.google.zetasql.ResolvedInsertStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public com.google.zetasql.ResolvedInsertStmtProto.Builder addInsertListBuilder(
        int index) {
      return getInsertListFieldBuilder().addBuilder(
          index, com.google.zetasql.ResolvedInsertStmtProto.getDefaultInstance());
    }
    /**
     * <pre>
     * Nested INSERT statements to apply.  Each insert will produce zero
     * or more values for &lt;element_column&gt;.
     * INSERTs are applied after DELETEs and UPDATEs.
     * For nested UPDATEs, insert_mode will always be the default, and
     * has no effect.
     * </pre>
     *
     * <code>repeated .zetasql.ResolvedInsertStmtProto insert_list = 7;</code>
     */
    public java.util.List<com.google.zetasql.ResolvedInsertStmtProto.Builder> 
         getInsertListBuilderList() {
      return getInsertListFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.zetasql.ResolvedInsertStmtProto, com.google.zetasql.ResolvedInsertStmtProto.Builder, com.google.zetasql.ResolvedInsertStmtProtoOrBuilder> 
        getInsertListFieldBuilder() {
      if (insertListBuilder_ == null) {
        insertListBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.zetasql.ResolvedInsertStmtProto, com.google.zetasql.ResolvedInsertStmtProto.Builder, com.google.zetasql.ResolvedInsertStmtProtoOrBuilder>(
                insertList_,
                ((bitField0_ & 0x00000080) == 0x00000080),
                getParentForChildren(),
                isClean());
        insertList_ = null;
      }
      return insertListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:zetasql.ResolvedUpdateItemProto)
  }

  // @@protoc_insertion_point(class_scope:zetasql.ResolvedUpdateItemProto)
  private static final com.google.zetasql.ResolvedUpdateItemProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.zetasql.ResolvedUpdateItemProto();
  }

  public static com.google.zetasql.ResolvedUpdateItemProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<ResolvedUpdateItemProto>
      PARSER = new com.google.protobuf.AbstractParser<ResolvedUpdateItemProto>() {
    @java.lang.Override
    public ResolvedUpdateItemProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(
                builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<ResolvedUpdateItemProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolvedUpdateItemProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.zetasql.ResolvedUpdateItemProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

