/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.beam.runners.flink.metrics.Metrics;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.AbstractReporter;

public class FileReporter
extends AbstractReporter {
    private String path;
    private PrintStream ps;

    public String filterCharacters(String input) {
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void open(MetricConfig config) {
        FileReporter fileReporter = this;
        synchronized (fileReporter) {
            if (this.path == null) {
                this.path = config.getString("path", null);
                this.log.info("Opening file: {}", (Object)this.path);
                if (this.path == null) {
                    throw new IllegalStateException("FileReporter metrics config needs 'path' key");
                }
                try {
                    FileOutputStream fos = new FileOutputStream(this.path);
                    this.ps = new PrintStream(fos);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("FileReporter couldn't open file", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        String name = group.getMetricIdentifier(metricName, (CharacterFilter)this);
        super.notifyOfRemovedMetric(metric, metricName, group);
        FileReporter fileReporter = this;
        synchronized (fileReporter) {
            this.ps.printf("%s: %s%n", name, Metrics.toString(metric));
        }
    }

    public void close() {
        this.ps.close();
        this.log.info("wrote metrics to {}", (Object)this.path);
    }
}

