/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class EncodedValueSerializer
extends TypeSerializerSingleton<byte[]> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY = new byte[0];

    public @UnknownKeyFor @NonNull @Initialized boolean isImmutableType() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] createInstance() {
        return EMPTY;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] copy(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] from) {
        return from;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] copy(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] from, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] reuse) {
        return this.copy(from);
    }

    public @UnknownKeyFor @NonNull @Initialized int getLength() {
        return -1;
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] record, @UnknownKeyFor @NonNull @Initialized DataOutputView target) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] deserialize(@UnknownKeyFor @NonNull @Initialized DataInputView source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int len = source.readInt();
        byte[] result = new byte[len];
        source.readFully(result);
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] deserialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] reuse, @UnknownKeyFor @NonNull @Initialized DataInputView source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.deserialize(source);
    }

    public void copy(@UnknownKeyFor @NonNull @Initialized DataInputView source, @UnknownKeyFor @NonNull @Initialized DataOutputView target) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeSerializerSnapshot<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> snapshotConfiguration() {
        return new TypeSerializerSnapshot<byte[]>(){

            public @UnknownKeyFor @NonNull @Initialized int getCurrentVersion() {
                return 1;
            }

            public void writeSnapshot(@UnknownKeyFor @NonNull @Initialized DataOutputView out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            }

            public void readSnapshot(@UnknownKeyFor @NonNull @Initialized int readVersion, @UnknownKeyFor @NonNull @Initialized DataInputView in, @UnknownKeyFor @NonNull @Initialized ClassLoader userCodeClassLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
            }

            public @UnknownKeyFor @NonNull @Initialized TypeSerializer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> restoreSerializer() {
                return new EncodedValueSerializer();
            }

            public @UnknownKeyFor @NonNull @Initialized TypeSerializerSchemaCompatibility<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> resolveSchemaCompatibility(@UnknownKeyFor @NonNull @Initialized TypeSerializer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> newSerializer) {
                return newSerializer instanceof EncodedValueSerializer ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.compatibleAfterMigration();
            }
        };
    }
}

