/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import java.io.IOException;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BeamAdapterCoderUtils {
    BeamAdapterCoderUtils() {
    }

    static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> typeInformationToCoder(@UnknownKeyFor @NonNull @Initialized TypeInformation<T> typeInfo, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
        Class clazz = typeInfo.getTypeClass();
        if (typeInfo instanceof CoderTypeInformation) {
            return ((CoderTypeInformation)typeInfo).getCoder();
        }
        if (clazz.getTypeParameters().length == 0) {
            try {
                return coderRegistry.getCoder(clazz);
            }
            catch (CannotProvideCoderException exn) {
                throw new RuntimeException(exn);
            }
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            TypeInformation elementType = (TypeInformation)Preconditions.checkArgumentNotNull((Object)((TypeInformation)typeInfo.getGenericParameters().get("T")));
            return IterableCoder.of(BeamAdapterCoderUtils.typeInformationToCoder(elementType, coderRegistry));
        }
        if (Map.class.isAssignableFrom(clazz)) {
            TypeInformation keyType = (TypeInformation)Preconditions.checkArgumentNotNull((Object)((TypeInformation)typeInfo.getGenericParameters().get("K")));
            TypeInformation valueType = (TypeInformation)Preconditions.checkArgumentNotNull((Object)((TypeInformation)typeInfo.getGenericParameters().get("V")));
            return MapCoder.of(BeamAdapterCoderUtils.typeInformationToCoder(keyType, coderRegistry), BeamAdapterCoderUtils.typeInformationToCoder(valueType, coderRegistry));
        }
        throw new RuntimeException("Coder translation for " + typeInfo + " not yet supported.");
    }

    static <T> @UnknownKeyFor @NonNull @Initialized TypeInformation<T> coderToTypeInformation(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new CoderTypeInformation<T>(coder, options);
    }

    static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> lookupCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline p, @UnknownKeyFor @NonNull @Initialized String pCollectionId) {
        try {
            return CoderTranslation.fromProto((RunnerApi.Coder)p.getComponents().getCodersOrThrow(p.getComponents().getPcollectionsOrThrow(pCollectionId).getCoderId()), (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)p.getComponents()), (CoderTranslation.TranslationContext)CoderTranslation.TranslationContext.DEFAULT);
        }
        catch (IOException exn) {
            throw new RuntimeException(exn);
        }
    }
}

