/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.Concatenate;
import org.apache.beam.runners.flink.FlinkExecutionEnvironments;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPortablePipelineTranslator;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContextFactory;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStagePruningFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkPartialReduceFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkReduceFunction;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.types.KvKeySelector;
import org.apache.beam.runners.flink.translation.utils.FlinkPortableRunnerUtils;
import org.apache.beam.runners.flink.translation.wrappers.ImpulseInputFormat;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.ExecutableStageTranslation;
import org.apache.beam.sdk.util.construction.NativeTransforms;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkBatchPortablePipelineTranslator
implements FlinkPortablePipelineTranslator<BatchTranslationContext> {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator> urnToTransformTranslator;

    @Override
    public @UnknownKeyFor @NonNull @Initialized BatchTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @Nullable @UnknownKeyFor @Initialized String confDir, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filesToStage) {
        ExecutionEnvironment executionEnvironment = FlinkExecutionEnvironments.createBatchExecutionEnvironment(pipelineOptions, filesToStage, confDir);
        return FlinkBatchPortablePipelineTranslator.createTranslationContext(jobInfo, pipelineOptions, executionEnvironment);
    }

    public static @UnknownKeyFor @NonNull @Initialized BatchTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment) {
        return new BatchTranslationContext(jobInfo, pipelineOptions, executionEnvironment);
    }

    public static @UnknownKeyFor @NonNull @Initialized FlinkBatchPortablePipelineTranslator createTranslator() {
        return FlinkBatchPortablePipelineTranslator.createTranslator((Map<String, PTransformTranslator>)ImmutableMap.of());
    }

    public static @UnknownKeyFor @NonNull @Initialized FlinkBatchPortablePipelineTranslator createTranslator(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator> extraTranslations) {
        ImmutableMap.Builder translatorMap = ImmutableMap.builder();
        translatorMap.put((Object)"beam:transform:flatten:v1", FlinkBatchPortablePipelineTranslator::translateFlatten);
        translatorMap.put((Object)"beam:transform:group_by_key:v1", FlinkBatchPortablePipelineTranslator::translateGroupByKey);
        translatorMap.put((Object)"beam:transform:impulse:v1", FlinkBatchPortablePipelineTranslator::translateImpulse);
        translatorMap.put((Object)"beam:runner:executable_stage:v1", FlinkBatchPortablePipelineTranslator::translateExecutableStage);
        translatorMap.put((Object)"beam:transform:reshuffle:v1", FlinkBatchPortablePipelineTranslator::translateReshuffle);
        translatorMap.putAll(extraTranslations);
        return new FlinkBatchPortablePipelineTranslator((Map<String, PTransformTranslator>)translatorMap.build());
    }

    public FlinkBatchPortablePipelineTranslator(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator> urnToTransformTranslator) {
        this.urnToTransformTranslator = urnToTransformTranslator;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> knownUrns() {
        return this.urnToTransformTranslator.keySet();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FlinkPortablePipelineTranslator.Executor translate(@UnknownKeyFor @NonNull @Initialized BatchTranslationContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode pTransformNode : p.getTopologicallyOrderedTransforms()) {
            this.urnToTransformTranslator.getOrDefault(pTransformNode.getTransform().getSpec().getUrn(), FlinkBatchPortablePipelineTranslator::urnNotFound).translate(pTransformNode, pipeline, context);
        }
        for (DataSet dataSet : context.getDanglingDataSets()) {
            dataSet.output((OutputFormat)new DiscardingOutputFormat()).name("DiscardingOutput");
        }
        return context;
    }

    private static <K, V> void translateReshuffle(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        DataSet inputDataSet = context.getDataSetOrThrow((String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values()));
        context.addDataSet((String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values()), inputDataSet.rebalance());
    }

    private static <InputT> void translateExecutableStage(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        MapPartitionOperator taggedDataset;
        RunnerApi.ExecutableStagePayload stagePayload;
        RunnerApi.Components components = pipeline.getComponents();
        Map outputs = transform.getTransform().getOutputsMap();
        BiMap outputMap = PipelineTranslatorUtils.createOutputMap(outputs.values());
        ArrayList unionCoders = Lists.newArrayList();
        HashMap outputCoders = Maps.newHashMap();
        for (String collectionId : new TreeMap(outputMap.inverse()).values()) {
            Coder coder;
            PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
            try {
                coder = WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)collectionNode, (RunnerApi.Components)components);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            outputCoders.put(collectionId, coder);
            unionCoders.add(coder);
        }
        UnionCoder unionCoder = UnionCoder.of((List)unionCoders);
        CoderTypeInformation typeInformation = new CoderTypeInformation(unionCoder, context.getPipelineOptions());
        try {
            stagePayload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getTransform().getSpec().getPayload());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String inputPCollectionId = stagePayload.getInput();
        Coder windowedInputCoder = PipelineTranslatorUtils.instantiateCoder((String)inputPCollectionId, (RunnerApi.Components)components);
        DataSet inputDataSet = context.getDataSetOrThrow(inputPCollectionId);
        FlinkExecutableStageFunction function = new FlinkExecutableStageFunction(transform.getTransform().getUniqueName(), context.getPipelineOptions(), stagePayload, context.getJobInfo(), (Map<String, Integer>)outputMap, FlinkExecutableStageContextFactory.getInstance(), PipelineTranslatorUtils.getWindowingStrategy((String)inputPCollectionId, (RunnerApi.Components)components).getWindowFn().windowCoder(), windowedInputCoder);
        String operatorName = ExecutableStageTranslation.generateNameFromStagePayload((RunnerApi.ExecutableStagePayload)stagePayload);
        if (stagePayload.getUserStatesCount() > 0 || stagePayload.getTimersCount() > 0) {
            Coder valueCoder = ((WindowedValue.FullWindowedValueCoder)windowedInputCoder).getValueCoder();
            if (!(valueCoder instanceof KvCoder)) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "The element coder for stateful DoFn '%s' must be KvCoder but is: %s", inputPCollectionId, valueCoder.getClass().getSimpleName()));
            }
            Coder keyCoder = ((KvCoder)valueCoder).getKeyCoder();
            UnsortedGrouping groupedInput = inputDataSet.groupBy(new KvKeySelector(keyCoder));
            boolean requiresTimeSortedInput = FlinkPortableRunnerUtils.requiresTimeSortedInput(stagePayload, false);
            if (requiresTimeSortedInput) {
                groupedInput = groupedInput.sortGroup(WindowedValue::getTimestamp, Order.ASCENDING);
            }
            taggedDataset = new GroupReduceOperator((Grouping)groupedInput, typeInformation, function, operatorName);
        } else {
            taggedDataset = new MapPartitionOperator(inputDataSet, typeInformation, function, operatorName);
        }
        for (RunnerApi.ExecutableStagePayload.SideInputId sideInputId : stagePayload.getSideInputsList()) {
            String collectionId = stagePayload.getComponents().getTransformsOrThrow(sideInputId.getTransformId()).getInputsOrThrow(sideInputId.getLocalName());
            taggedDataset.withBroadcastSet(context.getDataSetOrThrow(collectionId), collectionId);
        }
        for (String collectionId : outputs.values()) {
            FlinkBatchPortablePipelineTranslator.pruneOutput((DataSet<RawUnionValue>)taggedDataset, context, (Integer)outputMap.get((Object)collectionId), (Coder)outputCoders.get(collectionId), collectionId);
        }
        if (outputs.isEmpty()) {
            taggedDataset.output((OutputFormat)new DiscardingOutputFormat()).name("DiscardingOutput");
        }
    }

    private static <T> void translateFlatten(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        Map allInputs = transform.getTransform().getInputsMap();
        UnionOperator result = null;
        if (allInputs.isEmpty()) {
            DataSource dummySource = context.getExecutionEnvironment().fromElements((Object[])new String[]{"dummy"});
            result = dummySource.flatMap((FlatMapFunction & Serializable)(s, collector) -> {}).returns(new CoderTypeInformation(WindowedValue.getFullCoder((Coder)VoidCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions()));
        } else {
            for (String pCollectionId : allInputs.values()) {
                UnionOperator current = context.getDataSetOrThrow(pCollectionId);
                if (result == null) {
                    result = current;
                    continue;
                }
                result = result.union(current);
            }
        }
        result = result.filter((FilterFunction & Serializable)tWindowedValue -> true).name("UnionFixFilter");
        context.addDataSet((String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values()), result);
    }

    private static <K, V> void translateGroupByKey(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        WindowedValue.WindowedValueCoder inputCoder;
        WindowingStrategy windowingStrategy;
        RunnerApi.Components components = pipeline.getComponents();
        String inputPCollectionId = (String)Iterables.getOnlyElement(transform.getTransform().getInputsMap().values());
        PipelineNode.PCollectionNode inputCollection = PipelineNode.pCollection((String)inputPCollectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(inputPCollectionId));
        DataSet inputDataSet = context.getDataSetOrThrow(inputPCollectionId);
        RunnerApi.WindowingStrategy windowingStrategyProto = pipeline.getComponents().getWindowingStrategiesOrThrow(pipeline.getComponents().getPcollectionsOrThrow(inputPCollectionId).getWindowingStrategyId());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)pipeline.getComponents());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        try {
            inputCoder = (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder((PipelineNode.PCollectionNode)inputCollection, (RunnerApi.Components)pipeline.getComponents());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KvCoder inputElementCoder = (KvCoder)inputCoder.getValueCoder();
        Concatenate combineFn = new Concatenate();
        Coder accumulatorCoder = combineFn.getAccumulatorCoder(CoderRegistry.createDefault(), inputElementCoder.getValueCoder());
        WindowedValue.FullWindowedValueCoder outputCoder = WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)inputElementCoder.getKeyCoder(), (Coder)accumulatorCoder), (Coder)windowingStrategy.getWindowFn().windowCoder());
        CoderTypeInformation partialReduceTypeInfo = new CoderTypeInformation(outputCoder, context.getPipelineOptions());
        UnsortedGrouping inputGrouping = inputDataSet.groupBy(new KvKeySelector(inputElementCoder.getKeyCoder()));
        FlinkPartialReduceFunction partialReduceFunction = new FlinkPartialReduceFunction(combineFn, windowingStrategy, Collections.emptyMap(), context.getPipelineOptions());
        FlinkReduceFunction reduceFunction = new FlinkReduceFunction(combineFn, windowingStrategy, Collections.emptyMap(), context.getPipelineOptions());
        GroupCombineOperator groupCombine = new GroupCombineOperator((Grouping)inputGrouping, partialReduceTypeInfo, partialReduceFunction, "GroupCombine: " + transform.getTransform().getUniqueName());
        UnsortedGrouping intermediateGrouping = groupCombine.groupBy(new KvKeySelector(inputElementCoder.getKeyCoder()));
        GroupReduceOperator outputDataSet = new GroupReduceOperator((Grouping)intermediateGrouping, partialReduceTypeInfo, reduceFunction, transform.getTransform().getUniqueName());
        context.addDataSet((String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values()), outputDataSet);
    }

    private static void translateImpulse(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        CoderTypeInformation typeInformation = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)ByteArrayCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions());
        DataSource dataSource = (DataSource)new DataSource(context.getExecutionEnvironment(), (InputFormat)new ImpulseInputFormat(), typeInformation, transform.getTransform().getUniqueName()).name("Impulse");
        context.addDataSet((String)Iterables.getOnlyElement(transform.getTransform().getOutputsMap().values()), dataSource);
    }

    private static void urnNotFound(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context) {
        throw new IllegalArgumentException(String.format("Unknown type of URN %s for PTransform with id %s.", transform.getTransform().getSpec().getUrn(), transform.getId()));
    }

    private static void pruneOutput(@UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedDataset, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext context, @UnknownKeyFor @NonNull @Initialized int unionTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoder, @UnknownKeyFor @NonNull @Initialized String collectionId) {
        CoderTypeInformation outputType = new CoderTypeInformation(outputCoder, context.getPipelineOptions());
        FlinkExecutableStagePruningFunction pruningFunction = new FlinkExecutableStagePruningFunction(unionTag, context.getPipelineOptions());
        FlatMapOperator pruningOperator = new FlatMapOperator(taggedDataset, outputType, (FlatMapFunction)pruningFunction, String.format("ExtractOutput[%s]", unionTag));
        context.addDataSet(collectionId, pruningOperator);
    }

    @AutoService(value={NativeTransforms.IsNativeTransform.class})
    public static class IsFlinkNativeTransform
    implements NativeTransforms.IsNativeTransform {
        public @UnknownKeyFor @NonNull @Initialized boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
            return "beam:transform:reshuffle:v1".equals(PTransformTranslation.urnForTransformOrNull((RunnerApi.PTransform)pTransform));
        }
    }

    @FunctionalInterface
    public static interface PTransformTranslator {
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline var2, @UnknownKeyFor @NonNull @Initialized BatchTranslationContext var3);
    }

    public static class BatchTranslationContext
    implements FlinkPortablePipelineTranslator.TranslationContext,
    FlinkPortablePipelineTranslator.Executor {
        private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
        private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;
        private final @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataSets;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> danglingDataSets;

        private BatchTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options, @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment) {
            this.jobInfo = jobInfo;
            this.options = options;
            this.executionEnvironment = executionEnvironment;
            this.dataSets = new HashMap();
            this.danglingDataSets = new HashSet<String>();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JobInfo getJobInfo() {
            return this.jobInfo;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions getPipelineOptions() {
            return this.options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JobExecutionResult execute(@UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.getExecutionEnvironment().execute(jobName);
        }

        public @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment getExecutionEnvironment() {
            return this.executionEnvironment;
        }

        public <T> void addDataSet(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized DataSet<T> dataSet) {
            Preconditions.checkArgument((!this.dataSets.containsKey(pCollectionId) ? 1 : 0) != 0);
            this.dataSets.put(pCollectionId, dataSet);
            this.danglingDataSets.add(pCollectionId);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized DataSet<T> getDataSetOrThrow(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
            DataSet<?> dataSet = this.dataSets.get(pCollectionId);
            if (dataSet == null) {
                throw new IllegalArgumentException(String.format("Unknown dataset for id %s.", pCollectionId));
            }
            this.danglingDataSets.remove(pCollectionId);
            return dataSet;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getDanglingDataSets() {
            return this.danglingDataSets.stream().map(id -> this.dataSets.get(id)).collect(Collectors.toList());
        }
    }
}

