/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkExecutionEnvironments;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkStreamingTransformTranslators;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContextFactory;
import org.apache.beam.runners.flink.translation.functions.ImpulseSourceFunction;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.wrappers.SourceInputFormat;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.ExecutableStageDoFnOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.KvToFlinkKeyKeySelector;
import org.apache.beam.runners.flink.translation.wrappers.streaming.SdfFlinkKeyKeySelector;
import org.apache.beam.runners.flink.translation.wrappers.streaming.SingletonKeyedWorkItemCoder;
import org.apache.beam.runners.flink.translation.wrappers.streaming.WindowDoFnOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.WorkItemKeySelector;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.DedupingOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.StreamingImpulseSource;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.TestStreamSource;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.UnboundedSourceWrapper;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.ExecutableStageTranslation;
import org.apache.beam.sdk.util.construction.NativeTransforms;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.ReadTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.RunnerPCollectionView;
import org.apache.beam.sdk.util.construction.TestStreamTranslation;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultiset;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkStreamingPortablePipelineTranslator
implements FlinkPortablePipelineTranslator<StreamingTranslationContext> {
    @Deprecated
    private static final @UnknownKeyFor @NonNull @Initialized String STREAMING_IMPULSE_TRANSFORM_URN = "flink:transform:streaming_impulse:v1";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator<@UnknownKeyFor @NonNull @Initialized StreamingTranslationContext>> urnToTransformTranslator;

    @Override
    public @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String confDir, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filesToStage) {
        StreamExecutionEnvironment executionEnvironment = FlinkExecutionEnvironments.createStreamExecutionEnvironment(pipelineOptions, filesToStage, confDir);
        return this.createTranslationContext(jobInfo, pipelineOptions, executionEnvironment);
    }

    public @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment) {
        return new StreamingTranslationContext(jobInfo, pipelineOptions, executionEnvironment);
    }

    public FlinkStreamingPortablePipelineTranslator() {
        this((Map<String, PTransformTranslator<StreamingTranslationContext>>)ImmutableMap.of());
    }

    public FlinkStreamingPortablePipelineTranslator(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator<@UnknownKeyFor @NonNull @Initialized StreamingTranslationContext>> extraTranslations) {
        ImmutableMap.Builder translatorMap = ImmutableMap.builder();
        translatorMap.put((Object)"beam:transform:flatten:v1", this::translateFlatten);
        translatorMap.put((Object)"beam:transform:group_by_key:v1", this::translateGroupByKey);
        translatorMap.put((Object)"beam:transform:impulse:v1", this::translateImpulse);
        translatorMap.put((Object)"beam:runner:executable_stage:v1", this::translateExecutableStage);
        translatorMap.put((Object)"beam:transform:reshuffle:v1", this::translateReshuffle);
        translatorMap.put((Object)STREAMING_IMPULSE_TRANSFORM_URN, this::translateStreamingImpulse);
        translatorMap.put((Object)"beam:transform:read:v1", this::translateRead);
        translatorMap.put((Object)"beam:transform:teststream:v1", this::translateTestStream);
        translatorMap.putAll(extraTranslations);
        this.urnToTransformTranslator = translatorMap.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> knownUrns() {
        return Sets.difference(this.urnToTransformTranslator.keySet(), (Set)ImmutableSet.of((Object)"beam:transform:read:v1"));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FlinkPortablePipelineTranslator.Executor translate(@UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transform : p.getTopologicallyOrderedTransforms()) {
            this.urnToTransformTranslator.getOrDefault(transform.getTransform().getSpec().getUrn(), this::urnNotFound).translate(transform.getId(), pipeline, context);
        }
        return context;
    }

    private void urnNotFound(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized FlinkPortablePipelineTranslator.TranslationContext context) {
        throw new IllegalArgumentException(String.format("Unknown type of URN %s for PTransform with id %s.", pipeline.getComponents().getTransformsOrThrow(id).getSpec().getUrn(), id));
    }

    private <K, V> void translateReshuffle(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        RunnerApi.PTransform transform = pipeline.getComponents().getTransformsOrThrow(id);
        DataStream inputDataStream = context.getDataStreamOrThrow((String)Iterables.getOnlyElement(transform.getInputsMap().values()));
        context.addDataStream((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), inputDataStream.rebalance());
    }

    private <T> void translateFlatten(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        RunnerApi.PTransform transform = pipeline.getComponents().getTransformsOrThrow(id);
        Map allInputs = transform.getInputsMap();
        if (allInputs.isEmpty()) {
            long shutdownAfterIdleSourcesMs = context.getPipelineOptions().getShutdownSourcesAfterIdleMs();
            DataStreamSource dummySource = context.getExecutionEnvironment().addSource((SourceFunction)new ImpulseSourceFunction(shutdownAfterIdleSourcesMs));
            SingleOutputStreamOperator result = dummySource.flatMap((FlatMapFunction & Serializable)(s, collector) -> {}).returns(new CoderTypeInformation(WindowedValue.getFullCoder((Coder)VoidCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions()));
            context.addDataStream((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), result);
        } else {
            DataStream current;
            DataStream result = null;
            HashMultiset inputCounts = HashMultiset.create();
            for (String input : allInputs.values()) {
                current = context.getDataStreamOrThrow(input);
                inputCounts.add(current, 1);
            }
            for (String input : allInputs.values()) {
                current = context.getDataStreamOrThrow(input);
                int timesRequired = inputCounts.count(current);
                if (timesRequired > 1) {
                    current = current.flatMap(new FlatMapFunction<T, T>(){
                        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;

                        public void flatMap(T t, @UnknownKeyFor @NonNull @Initialized Collector<T> collector) {
                            collector.collect(t);
                        }
                    });
                }
                result = result == null ? current : result.union(new DataStream[]{current});
            }
            context.addDataStream((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), result);
        }
    }

    private <K, V> void translateGroupByKey(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        WindowingStrategy windowingStrategy;
        RunnerApi.PTransform pTransform = pipeline.getComponents().getTransformsOrThrow(id);
        String inputPCollectionId = (String)Iterables.getOnlyElement(pTransform.getInputsMap().values());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)pipeline.getComponents());
        RunnerApi.WindowingStrategy windowingStrategyProto = pipeline.getComponents().getWindowingStrategiesOrThrow(pipeline.getComponents().getPcollectionsOrThrow(inputPCollectionId).getWindowingStrategyId());
        try {
            windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate GroupByKey windowing strategy %s.", windowingStrategyProto), e);
        }
        WindowedValue.WindowedValueCoder windowedInputCoder = (WindowedValue.WindowedValueCoder)PipelineTranslatorUtils.instantiateCoder((String)inputPCollectionId, (RunnerApi.Components)pipeline.getComponents());
        DataStream inputDataStream = context.getDataStreamOrThrow(inputPCollectionId);
        SingleOutputStreamOperator<WindowedValue<KV<K, Iterable<V>>>> outputDataStream = this.addGBK(inputDataStream, windowingStrategy, windowedInputCoder, pTransform.getUniqueName(), context);
        outputDataStream.uid(pTransform.getUniqueName());
        context.addDataStream((String)Iterables.getOnlyElement(pTransform.getOutputsMap().values()), outputDataStream);
    }

    private <K, V> @UnknownKeyFor @NonNull @Initialized SingleOutputStreamOperator<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> addGBK(@UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> inputDataStream, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> windowedInputCoder, @UnknownKeyFor @NonNull @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        KvCoder inputElementCoder = (KvCoder)windowedInputCoder.getValueCoder();
        SingletonKeyedWorkItemCoder workItemCoder = SingletonKeyedWorkItemCoder.of(inputElementCoder.getKeyCoder(), inputElementCoder.getValueCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder());
        WindowedValue.FullWindowedValueCoder windowedWorkItemCoder = WindowedValue.getFullCoder(workItemCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        WorkItemKeySelector keySelector = new WorkItemKeySelector(inputElementCoder.getKeyCoder());
        KeyedStream keyedWorkItemStream = inputDataStream.keyBy(new KvToFlinkKeyKeySelector(inputElementCoder.getKeyCoder()));
        SystemReduceFn reduceFn = SystemReduceFn.buffering((Coder)inputElementCoder.getValueCoder());
        IterableCoder accumulatorCoder = IterableCoder.of((Coder)inputElementCoder.getValueCoder());
        WindowedValue.FullWindowedValueCoder outputCoder = WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)inputElementCoder.getKeyCoder(), (Coder)accumulatorCoder), (Coder)windowingStrategy.getWindowFn().windowCoder());
        CoderTypeInformation outputTypeInfo = new CoderTypeInformation(outputCoder, context.getPipelineOptions());
        TupleTag mainTag = new TupleTag("main output");
        WindowDoFnOperator doFnOperator = new WindowDoFnOperator(reduceFn, operatorName, windowedWorkItemCoder, mainTag, Collections.emptyList(), new DoFnOperator.MultiOutputOutputManagerFactory(mainTag, outputCoder, new SerializablePipelineOptions((PipelineOptions)context.getPipelineOptions())), windowingStrategy, new HashMap(), (Collection<PCollectionView<?>>)Collections.emptyList(), context.getPipelineOptions(), inputElementCoder.getKeyCoder(), keySelector);
        return keyedWorkItemStream.transform(operatorName, outputTypeInfo, doFnOperator);
    }

    private <T> void translateRead(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        RunnerApi.ReadPayload payload;
        RunnerApi.PTransform transform = pipeline.getComponents().getTransformsOrThrow(id);
        String outputCollectionId = (String)Iterables.getOnlyElement(transform.getOutputsMap().values());
        try {
            payload = RunnerApi.ReadPayload.parseFrom((ByteString)transform.getSpec().getPayload());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse ReadPayload from transform", e);
        }
        DataStream<WindowedValue<T>> source = payload.getIsBounded() == RunnerApi.IsBounded.Enum.BOUNDED ? this.translateBoundedSource(transform.getUniqueName(), outputCollectionId, payload, pipeline, context.getPipelineOptions(), context.getExecutionEnvironment()) : FlinkStreamingPortablePipelineTranslator.translateUnboundedSource(transform.getUniqueName(), outputCollectionId, payload, pipeline, context.getPipelineOptions(), context.getExecutionEnvironment());
        context.addDataStream(outputCollectionId, source);
    }

    private <T> @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> translateBoundedSource(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized String outputCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload payload, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment env) {
        try {
            BoundedSource boundedSource = ReadTranslation.boundedSourceFromProto((RunnerApi.ReadPayload)payload);
            WindowedValue.FullWindowedValueCoder wireCoder = (WindowedValue.FullWindowedValueCoder)PipelineTranslatorUtils.instantiateCoder((String)outputCollectionId, (RunnerApi.Components)pipeline.getComponents());
            WindowedValue.FullWindowedValueCoder sdkCoder = FlinkStreamingPortablePipelineTranslator.getSdkCoder(outputCollectionId, pipeline.getComponents());
            CoderTypeInformation outputTypeInfo = new CoderTypeInformation(wireCoder, pipelineOptions);
            CoderTypeInformation<T> sdkTypeInfo = new CoderTypeInformation<T>(sdkCoder, pipelineOptions);
            return env.createInput(new SourceInputFormat(transformName, boundedSource, pipelineOptions)).name(transformName).uid(transformName).returns(sdkTypeInfo).map((MapFunction & Serializable)value -> FlinkStreamingPortablePipelineTranslator.intoWireTypes(sdkCoder, wireCoder, value)).returns(outputTypeInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while translating UnboundedSource: " + transformName, e);
        }
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> translateUnboundedSource(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized String outputCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ReadPayload payload, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment env) {
        UnboundedSource unboundedSource = ReadTranslation.unboundedSourceFromProto((RunnerApi.ReadPayload)payload);
        WindowingStrategy windowStrategy = PipelineTranslatorUtils.getWindowingStrategy((String)outputCollectionId, (RunnerApi.Components)pipeline.getComponents());
        try {
            WindowedValue.FullWindowedValueCoder wireCoder = (WindowedValue.FullWindowedValueCoder)PipelineTranslatorUtils.instantiateCoder((String)outputCollectionId, (RunnerApi.Components)pipeline.getComponents());
            WindowedValue.FullWindowedValueCoder sdkCoder = FlinkStreamingPortablePipelineTranslator.getSdkCoder(outputCollectionId, pipeline.getComponents());
            CoderTypeInformation outputTypeInfo = new CoderTypeInformation(wireCoder, pipelineOptions);
            CoderTypeInformation<T> sdkTypeInformation = new CoderTypeInformation<T>(sdkCoder, pipelineOptions);
            CoderTypeInformation withIdTypeInfo = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)ValueWithRecordId.ValueWithRecordIdCoder.of((Coder)sdkCoder.getValueCoder()), (Coder)windowStrategy.getWindowFn().windowCoder()), pipelineOptions);
            int parallelism = env.getMaxParallelism() > 0 ? env.getMaxParallelism() : env.getParallelism();
            UnboundedSourceWrapper sourceWrapper = new UnboundedSourceWrapper(transformName, pipelineOptions, unboundedSource, parallelism);
            SingleOutputStreamOperator nonDedupSource = env.addSource(sourceWrapper).name(transformName).uid(transformName).returns(withIdTypeInfo);
            SingleOutputStreamOperator source = unboundedSource.requiresDeduping() ? nonDedupSource.keyBy(new FlinkStreamingTransformTranslators.ValueWithRecordIdKeySelector()).transform("deduping", sdkTypeInformation, new DedupingOperator(pipelineOptions)).uid(String.format("%s/__deduplicated__", transformName)).returns(sdkTypeInformation) : nonDedupSource.flatMap(new FlinkStreamingTransformTranslators.StripIdsMap(pipelineOptions)).returns(sdkTypeInformation);
            return source.map((MapFunction & Serializable)value -> FlinkStreamingPortablePipelineTranslator.intoWireTypes(sdkCoder, wireCoder, value)).returns(outputTypeInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while translating UnboundedSource: " + unboundedSource, e);
        }
    }

    private static <T> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.FullWindowedValueCoder<T> getSdkCoder(@UnknownKeyFor @NonNull @Initialized String pCollectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        PipelineNode.PCollectionNode pCollectionNode = PipelineNode.pCollection((String)pCollectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(pCollectionId));
        RunnerApi.Components.Builder componentsBuilder = components.toBuilder();
        String coderId = WireCoders.addSdkWireCoder((PipelineNode.PCollectionNode)pCollectionNode, (RunnerApi.Components.Builder)componentsBuilder, (RunnerApi.ExecutableStagePayload.WireCoderSetting)RunnerApi.ExecutableStagePayload.WireCoderSetting.getDefaultInstance());
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)componentsBuilder.build());
        try {
            WindowedValue.FullWindowedValueCoder res = (WindowedValue.FullWindowedValueCoder)rehydratedComponents.getCoder(coderId);
            return res;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not get SDK coder.", ex);
        }
    }

    private static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT> intoWireTypes(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> outCoder, @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value) {
        try {
            return (WindowedValue)CoderUtils.decodeFromByteArray(outCoder, (byte[])CoderUtils.encodeToByteArray(inCoder, value));
        }
        catch (CoderException ex) {
            throw new IllegalStateException("Could not transform element into wire types", ex);
        }
    }

    private void translateImpulse(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        RunnerApi.PTransform pTransform = pipeline.getComponents().getTransformsOrThrow(id);
        CoderTypeInformation typeInfo = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)ByteArrayCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions());
        long shutdownAfterIdleSourcesMs = context.getPipelineOptions().getShutdownSourcesAfterIdleMs();
        SingleOutputStreamOperator source = context.getExecutionEnvironment().addSource((SourceFunction)new ImpulseSourceFunction(shutdownAfterIdleSourcesMs), "Impulse").returns(typeInfo);
        context.addDataStream((String)Iterables.getOnlyElement(pTransform.getOutputsMap().values()), source);
    }

    private void translateStreamingImpulse(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        int messageCount;
        int intervalMillis;
        RunnerApi.PTransform pTransform = pipeline.getComponents().getTransformsOrThrow(id);
        CoderTypeInformation typeInfo = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)ByteArrayCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions());
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode config = objectMapper.readTree(pTransform.getSpec().getPayload().toByteArray());
            intervalMillis = config.path("interval_ms").asInt(100);
            messageCount = config.path("message_count").asInt(0);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse configuration for streaming impulse", e);
        }
        SingleOutputStreamOperator source = context.getExecutionEnvironment().addSource((SourceFunction)new StreamingImpulseSource(intervalMillis, messageCount), StreamingImpulseSource.class.getSimpleName()).returns(typeInfo);
        context.addDataStream((String)Iterables.getOnlyElement(pTransform.getOutputsMap().values()), source);
    }

    private <InputT, OutputT> void translateExecutableStage(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        SingleOutputStreamOperator outputStream;
        RunnerApi.ExecutableStagePayload stagePayload;
        RunnerApi.Components components = pipeline.getComponents();
        RunnerApi.PTransform transform = components.getTransformsOrThrow(id);
        Map outputs = transform.getOutputsMap();
        try {
            stagePayload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getSpec().getPayload());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String inputPCollectionId = stagePayload.getInput();
        TransformedSideInputs transformedSideInputs = stagePayload.getSideInputsCount() > 0 ? this.transformSideInputs(stagePayload, components, context) : new TransformedSideInputs(Collections.emptyMap(), null);
        LinkedHashMap tagsToOutputTags = Maps.newLinkedHashMap();
        LinkedHashMap tagsToCoders = Maps.newLinkedHashMap();
        TupleTag mainOutputTag = outputs.isEmpty() ? null : new TupleTag((String)outputs.keySet().iterator().next());
        BiMap outputIndexMap = PipelineTranslatorUtils.createOutputMap(outputs.keySet());
        HashMap outputCoders = Maps.newHashMap();
        HashMap tagsToIds = Maps.newHashMap();
        HashMap collectionIdToTupleTag = Maps.newHashMap();
        for (String localOutputName : new TreeMap(outputIndexMap).keySet()) {
            String collectionId = (String)outputs.get(localOutputName);
            Coder windowCoder = PipelineTranslatorUtils.instantiateCoder((String)collectionId, (RunnerApi.Components)components);
            outputCoders.put(localOutputName, windowCoder);
            TupleTag tupleTag = new TupleTag(localOutputName);
            CoderTypeInformation typeInformation = new CoderTypeInformation(windowCoder, context.getPipelineOptions());
            tagsToOutputTags.put(tupleTag, new OutputTag(localOutputName, typeInformation));
            tagsToCoders.put(tupleTag, windowCoder);
            tagsToIds.put(tupleTag, (Integer)outputIndexMap.get((Object)localOutputName));
            collectionIdToTupleTag.put(collectionId, tupleTag);
        }
        KeyedStream inputDataStream = context.getDataStreamOrThrow(inputPCollectionId);
        CoderTypeInformation outputTypeInformation = !outputs.isEmpty() ? new CoderTypeInformation((Coder)outputCoders.get(mainOutputTag.getId()), context.getPipelineOptions()) : null;
        ArrayList additionalOutputTags = Lists.newArrayList();
        for (TupleTag tupleTag : tagsToCoders.keySet()) {
            if (mainOutputTag.getId().equals(tupleTag.getId())) continue;
            additionalOutputTags.add(tupleTag);
        }
        Coder windowedInputCoder = PipelineTranslatorUtils.instantiateCoder((String)inputPCollectionId, (RunnerApi.Components)components);
        boolean stateful = stagePayload.getUserStatesCount() > 0 || stagePayload.getTimersCount() > 0;
        boolean hasSdfProcessFn = stagePayload.getComponents().getTransformsMap().values().stream().anyMatch(pTransform -> pTransform.getSpec().getUrn().equals("beam:transform:sdf_process_sized_element_and_restrictions:v1"));
        Coder keyCoder = null;
        Object keySelector = null;
        if (stateful || hasSdfProcessFn) {
            Coder valueCoder = ((WindowedValue.FullWindowedValueCoder)windowedInputCoder).getValueCoder();
            if (!(valueCoder instanceof KvCoder)) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "The element coder for stateful DoFn '%s' must be KvCoder but is: %s", inputPCollectionId, valueCoder.getClass().getSimpleName()));
            }
            if (stateful) {
                keyCoder = ((KvCoder)valueCoder).getKeyCoder();
                keySelector = new KvToFlinkKeyKeySelector(keyCoder);
            } else {
                if (!(((KvCoder)valueCoder).getKeyCoder() instanceof KvCoder)) {
                    throw new IllegalStateException(String.format(Locale.ENGLISH, "The element coder for splittable DoFn '%s' must be KVCoder(KvCoder, DoubleCoder) but is: %s", inputPCollectionId, valueCoder.getClass().getSimpleName()));
                }
                keyCoder = ((KvCoder)((KvCoder)valueCoder).getKeyCoder()).getKeyCoder();
                keySelector = new SdfFlinkKeyKeySelector(keyCoder);
            }
            inputDataStream = inputDataStream.keyBy(keySelector);
        }
        DoFnOperator.MultiOutputOutputManagerFactory outputManagerFactory = new DoFnOperator.MultiOutputOutputManagerFactory(mainOutputTag, tagsToOutputTags, tagsToCoders, tagsToIds, new SerializablePipelineOptions((PipelineOptions)context.getPipelineOptions()));
        ExecutableStageDoFnOperator doFnOperator = new ExecutableStageDoFnOperator(transform.getUniqueName(), windowedInputCoder, Collections.emptyMap(), mainOutputTag, additionalOutputTags, outputManagerFactory, transformedSideInputs.unionTagToView, new ArrayList(transformedSideInputs.unionTagToView.values()), (Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>>)FlinkStreamingPortablePipelineTranslator.getSideInputIdToPCollectionViewMap(stagePayload, components), context.getPipelineOptions(), stagePayload, context.getJobInfo(), FlinkExecutableStageContextFactory.getInstance(), collectionIdToTupleTag, PipelineTranslatorUtils.getWindowingStrategy((String)inputPCollectionId, (RunnerApi.Components)components), keyCoder, keySelector);
        String operatorName = ExecutableStageTranslation.generateNameFromStagePayload((RunnerApi.ExecutableStagePayload)stagePayload);
        if (transformedSideInputs.unionTagToView.isEmpty()) {
            outputStream = inputDataStream.transform(operatorName, outputTypeInformation, doFnOperator);
        } else {
            DataStream sideInputStream = transformedSideInputs.unionedSideInputs.broadcast();
            if (stateful || hasSdfProcessFn) {
                TwoInputTransformation rawFlinkTransform = new TwoInputTransformation(inputDataStream.getTransformation(), sideInputStream.getTransformation(), transform.getUniqueName(), doFnOperator, outputTypeInformation, inputDataStream.getParallelism());
                rawFlinkTransform.setStateKeyType(inputDataStream.getKeyType());
                rawFlinkTransform.setStateKeySelectors(inputDataStream.getKeySelector(), null);
                outputStream = new SingleOutputStreamOperator(inputDataStream.getExecutionEnvironment(), (Transformation)rawFlinkTransform){};
            } else {
                outputStream = inputDataStream.connect(sideInputStream).transform(operatorName, outputTypeInformation, doFnOperator);
            }
        }
        outputStream.uid(transform.getUniqueName());
        if (mainOutputTag != null) {
            context.addDataStream((String)outputs.get(mainOutputTag.getId()), outputStream);
        }
        for (TupleTag tupleTag : additionalOutputTags) {
            context.addDataStream((String)outputs.get(tupleTag.getId()), outputStream.getSideOutput((OutputTag)tagsToOutputTags.get(tupleTag)));
        }
    }

    private <T> void translateTestStream(@UnknownKeyFor @NonNull @Initialized String id, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        RunnerApi.Components components = pipeline.getComponents();
        SerializableFunction & Serializable testStreamDecoder = (SerializableFunction & Serializable)bytes -> {
            try {
                RunnerApi.TestStreamPayload testStreamPayload = RunnerApi.TestStreamPayload.parseFrom((byte[])bytes);
                TestStream testStream = TestStreamTranslation.testStreamFromProtoPayload((RunnerApi.TestStreamPayload)testStreamPayload, (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)components));
                return testStream;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't decode TestStream payload.", e);
            }
        };
        RunnerApi.PTransform transform = components.getTransformsOrThrow(id);
        String outputPCollectionId = (String)Iterables.getOnlyElement(transform.getOutputsMap().values());
        Coder coder = PipelineTranslatorUtils.instantiateCoder((String)outputPCollectionId, (RunnerApi.Components)components);
        DataStreamSource source = context.getExecutionEnvironment().addSource(new TestStreamSource(testStreamDecoder, transform.getSpec().getPayload().toByteArray()), new CoderTypeInformation(coder, context.getPipelineOptions()));
        context.addDataStream(outputPCollectionId, source);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LinkedHashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputIdToPCollectionViewMap(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)components);
        LinkedHashMap sideInputs = new LinkedHashMap();
        PCollectionViews.MultimapViewFn viewFn = new PCollectionViews.MultimapViewFn((PCollectionViews.TypeDescriptorSupplier & Serializable)() -> TypeDescriptors.iterables((TypeDescriptor)new TypeDescriptor<WindowedValue<Void>>(){}), TypeDescriptors::voids);
        for (RunnerApi.ExecutableStagePayload.SideInputId sideInputId : stagePayload.getSideInputsList()) {
            WindowingStrategy windowingStrategy;
            String sideInputTag = sideInputId.getLocalName();
            String collectionId = components.getTransformsOrThrow(sideInputId.getTransformId()).getInputsOrThrow(sideInputId.getLocalName());
            RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(collectionId).getWindowingStrategyId());
            try {
                windowingStrategy = WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)rehydratedComponents);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException(String.format("Unable to hydrate side input windowing strategy %s.", windowingStrategyProto), e);
            }
            Coder coder = PipelineTranslatorUtils.instantiateCoder((String)collectionId, (RunnerApi.Components)components);
            WindowedValue.WindowedValueCoder wvCoder = (WindowedValue.WindowedValueCoder)coder;
            coder = wvCoder.withValueCoder((Coder)IterableCoder.of((Coder)wvCoder.getValueCoder()));
            sideInputs.put(sideInputId, (PCollectionView<?>)new RunnerPCollectionView(null, new TupleTag(sideInputTag), (ViewFn)viewFn, windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy, coder));
        }
        return sideInputs;
    }

    private @UnknownKeyFor @NonNull @Initialized TransformedSideInputs transformSideInputs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized StreamingTranslationContext context) {
        LinkedHashMap<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputs = FlinkStreamingPortablePipelineTranslator.getSideInputIdToPCollectionViewMap(stagePayload, components);
        HashMap<TupleTag, Integer> tagToIntMapping = new HashMap<TupleTag, Integer>();
        HashMap intToViewMapping = new HashMap();
        ArrayList<WindowedValue.WindowedValueCoder> kvCoders = new ArrayList<WindowedValue.WindowedValueCoder>();
        ArrayList<WindowedValue.WindowedValueCoder> viewCoders = new ArrayList<WindowedValue.WindowedValueCoder>();
        int count = 0;
        for (Map.Entry<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInput : sideInputs.entrySet()) {
            TupleTag tag = sideInput.getValue().getTagInternal();
            intToViewMapping.put(count, sideInput.getValue());
            tagToIntMapping.put(tag, count);
            ++count;
            String collectionId = components.getTransformsOrThrow(sideInput.getKey().getTransformId()).getInputsOrThrow(sideInput.getKey().getLocalName());
            DataStream sideInputStream = context.getDataStreamOrThrow(collectionId);
            TypeInformation tpe = sideInputStream.getType();
            if (!(tpe instanceof CoderTypeInformation)) {
                throw new IllegalStateException("Input Stream TypeInformation is no CoderTypeInformation.");
            }
            WindowedValue.WindowedValueCoder coder = (WindowedValue.WindowedValueCoder)((CoderTypeInformation)tpe).getCoder();
            KvCoder kvCoder = KvCoder.of((Coder)VoidCoder.of(), (Coder)coder.getValueCoder());
            kvCoders.add(coder.withValueCoder((Coder)kvCoder));
            WindowedValue.WindowedValueCoder viewCoder = coder.withValueCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)IterableCoder.of((Coder)coder.getValueCoder())));
            viewCoders.add(viewCoder);
        }
        UnionCoder unionCoder = UnionCoder.of(viewCoders);
        CoderTypeInformation unionTypeInformation = new CoderTypeInformation(unionCoder, context.getPipelineOptions());
        SingleOutputStreamOperator sideInputUnion = null;
        for (Map.Entry<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInput : sideInputs.entrySet()) {
            TupleTag tag = sideInput.getValue().getTagInternal();
            int intTag = (Integer)tagToIntMapping.get(tag);
            RunnerApi.PTransform pTransform = components.getTransformsOrThrow(sideInput.getKey().getTransformId());
            String collectionId = pTransform.getInputsOrThrow(sideInput.getKey().getLocalName());
            DataStream sideInputStream = context.getDataStreamOrThrow(collectionId);
            String viewName = sideInput.getKey().getTransformId() + "-" + sideInput.getKey().getLocalName();
            WindowedValue.WindowedValueCoder kvCoder = (WindowedValue.WindowedValueCoder)kvCoders.get(intTag);
            SingleOutputStreamOperator keyedSideInputStream = sideInputStream.map(new ToVoidKeyValue(context.getPipelineOptions()));
            SingleOutputStreamOperator viewStream = this.addGBK((DataStream)keyedSideInputStream, (WindowingStrategy<?, ?>)sideInput.getValue().getWindowingStrategyInternal(), (WindowedValue.WindowedValueCoder)kvCoder, viewName, context);
            viewStream.uid(pTransform.getUniqueName() + "-" + sideInput.getKey().getLocalName());
            SingleOutputStreamOperator unionValueStream = viewStream.map(new FlinkStreamingTransformTranslators.ToRawUnion(intTag, context.getPipelineOptions())).returns(unionTypeInformation);
            if (sideInputUnion == null) {
                sideInputUnion = unionValueStream;
                continue;
            }
            sideInputUnion = sideInputUnion.union(new DataStream[]{unionValueStream});
        }
        return new TransformedSideInputs(intToViewMapping, (DataStream<RawUnionValue>)sideInputUnion);
    }

    private static class ToVoidKeyValue<@UnknownKeyFor T>
    extends RichMapFunction<WindowedValue<T>, WindowedValue<KV<Void, T>>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;

        public ToVoidKeyValue(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            this.options = new SerializablePipelineOptions(pipelineOptions);
        }

        public void open(@UnknownKeyFor @NonNull @Initialized Configuration parameters) {
            FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options.get());
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> map(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value) {
            return value.withValue((Object)KV.of(null, (Object)value.getValue()));
        }
    }

    private static class TransformedSideInputs {
        final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> unionTagToView;
        final @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @NonNull @Initialized RawUnionValue> unionedSideInputs;

        TransformedSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> unionTagToView, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @NonNull @Initialized RawUnionValue> unionedSideInputs) {
            this.unionTagToView = unionTagToView;
            this.unionedSideInputs = unionedSideInputs;
        }
    }

    @AutoService(value={NativeTransforms.IsNativeTransform.class})
    public static class IsFlinkNativeTransform
    implements NativeTransforms.IsNativeTransform {
        public @UnknownKeyFor @NonNull @Initialized boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
            return FlinkStreamingPortablePipelineTranslator.STREAMING_IMPULSE_TRANSFORM_URN.equals(PTransformTranslation.urnForTransformOrNull((RunnerApi.PTransform)pTransform));
        }
    }

    public static interface PTransformTranslator<@UnknownKeyFor T> {
        public void translate(@UnknownKeyFor @NonNull @Initialized String var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline var2, T var3);
    }

    public static class StreamingTranslationContext
    implements FlinkPortablePipelineTranslator.TranslationContext,
    FlinkPortablePipelineTranslator.Executor {
        private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
        private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;
        private final @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataStreams;

        private StreamingTranslationContext(@UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options, @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment executionEnvironment) {
            this.jobInfo = jobInfo;
            this.options = options;
            this.executionEnvironment = executionEnvironment;
            this.dataStreams = new HashMap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JobInfo getJobInfo() {
            return this.jobInfo;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions getPipelineOptions() {
            return this.options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JobExecutionResult execute(@UnknownKeyFor @NonNull @Initialized String jobName) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.getExecutionEnvironment().execute(jobName);
        }

        public @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment getExecutionEnvironment() {
            return this.executionEnvironment;
        }

        public <T> void addDataStream(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized DataStream<T> dataStream) {
            this.dataStreams.put(pCollectionId, dataStream);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized DataStream<T> getDataStreamOrThrow(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
            DataStream<?> dataSet = this.dataStreams.get(pCollectionId);
            if (dataSet == null) {
                throw new IllegalArgumentException(String.format("Unknown datastream for id %s.", pCollectionId));
            }
            return dataSet;
        }
    }
}

