/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.flink.adapter.FlinkKey;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WorkItemKeySelector<@UnknownKeyFor K, @UnknownKeyFor V>
implements KeySelector<WindowedValue<KeyedWorkItem<K, V>>, FlinkKey>,
ResultTypeQueryable<FlinkKey> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;

    public WorkItemKeySelector(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
        this.keyCoder = keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized FlinkKey getKey(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, V>> value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Object key = ((KeyedWorkItem)value.getValue()).key();
        return FlinkKey.of(key, this.keyCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeInformation<@UnknownKeyFor @NonNull @Initialized FlinkKey> getProducedType() {
        return ValueTypeInfo.of(FlinkKey.class);
    }
}

