/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.flink.FlinkBatchTransformTranslators;
import org.apache.beam.runners.flink.FlinkBatchTranslationContext;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkBatchPipelineTranslator
extends FlinkPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkBatchPipelineTranslator.class);
    private final FlinkBatchTranslationContext batchContext;
    private int depth = 0;

    public FlinkBatchPipelineTranslator(ExecutionEnvironment env, PipelineOptions options) {
        this.batchContext = new FlinkBatchTranslationContext(env, options);
    }

    @Override
    public void translate(Pipeline pipeline) {
        super.translate(pipeline);
        for (DataSet<?> dataSet : this.batchContext.getDanglingDataSets().values()) {
            dataSet.output((OutputFormat)new DiscardingOutputFormat());
        }
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        LOG.info("{} enterCompositeTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        ++this.depth;
        BatchTransformTranslator<?> translator = FlinkBatchPipelineTranslator.getTranslator(node);
        if (translator != null) {
            this.applyBatchTransform(node.getTransform(), node, translator);
            LOG.info("{} translated- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        --this.depth;
        LOG.info("{} leaveCompositeTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        LOG.info("{} visitPrimitiveTransform- {}", (Object)FlinkBatchPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        PTransform transform = node.getTransform();
        BatchTransformTranslator<?> translator = FlinkBatchTransformTranslators.getTranslator(transform);
        if (translator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)transform);
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyBatchTransform(transform, node, translator);
    }

    private <T extends PTransform<?, ?>> void applyBatchTransform(PTransform<?, ?> transform, TransformHierarchy.Node node, BatchTransformTranslator<?> translator) {
        PTransform<?, ?> typedTransform = transform;
        BatchTransformTranslator<?> typedTranslator = translator;
        this.batchContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        typedTranslator.translateNode(typedTransform, this.batchContext);
    }

    private static BatchTransformTranslator<?> getTranslator(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        if (transform == null) {
            return null;
        }
        return FlinkBatchTransformTranslators.getTranslator(transform);
    }

    public static interface BatchTransformTranslator<TransformT extends PTransform> {
        public void translateNode(TransformT var1, FlinkBatchTranslationContext var2);
    }
}

