/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;

class FlinkBatchTranslationContext {
    private final Map<PValue, DataSet<?>> dataSets;
    private final Map<PCollectionView<?>, DataSet<?>> broadcastDataSets;
    private final Map<PValue, DataSet<?>> danglingDataSets;
    private final ExecutionEnvironment env;
    private final PipelineOptions options;
    private AppliedPTransform<?, ?, ?> currentTransform;

    public FlinkBatchTranslationContext(ExecutionEnvironment env, PipelineOptions options) {
        this.env = env;
        this.options = options;
        this.dataSets = new HashMap();
        this.broadcastDataSets = new HashMap();
        this.danglingDataSets = new HashMap();
    }

    public Map<PValue, DataSet<?>> getDanglingDataSets() {
        return this.danglingDataSets;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    public PipelineOptions getPipelineOptions() {
        return this.options;
    }

    public <T> DataSet<WindowedValue<T>> getInputDataSet(PValue value) {
        this.danglingDataSets.remove(value);
        return this.dataSets.get(value);
    }

    public <T> void setOutputDataSet(PValue value, DataSet<WindowedValue<T>> set) {
        if (!this.dataSets.containsKey(value)) {
            this.dataSets.put(value, set);
            this.danglingDataSets.put(value, set);
        }
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public <T> DataSet<T> getSideInputDataSet(PCollectionView<?> value) {
        return this.broadcastDataSets.get(value);
    }

    public <ViewT, ElemT> void setSideInputDataSet(PCollectionView<ViewT> value, DataSet<WindowedValue<ElemT>> set) {
        if (!this.broadcastDataSets.containsKey(value)) {
            this.broadcastDataSets.put(value, set);
        }
    }

    public <T> TypeInformation<WindowedValue<T>> getTypeInfo(PCollection<T> collection) {
        return this.getTypeInfo(collection.getCoder(), collection.getWindowingStrategy());
    }

    public <T> TypeInformation<WindowedValue<T>> getTypeInfo(Coder<T> coder, WindowingStrategy<?, ?> windowingStrategy) {
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder(coder, (Coder)windowingStrategy.getWindowFn().windowCoder());
        return new CoderTypeInformation<WindowedValue<T>>(windowedValueCoder);
    }

    Map<TupleTag<?>, PValue> getInputs(PTransform<?, ?> transform) {
        return this.currentTransform.getInputs();
    }

    <T extends PValue> T getInput(PTransform<T, ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform)));
    }

    Map<TupleTag<?>, PValue> getOutputs(PTransform<?, ?> transform) {
        return this.currentTransform.getOutputs();
    }

    <T extends PValue> T getOutput(PTransform<?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }
}

