/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.core.construction.PipelineResources;
import org.apache.beam.runners.flink.FlinkJobServerDriver;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineRunner;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvocation;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvoker;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v20_0.com.google.common.util.concurrent.ListeningExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkJobInvoker
extends JobInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkJobInvoker.class);
    private final FlinkJobServerDriver.FlinkServerConfiguration serverConfig;

    public static FlinkJobInvoker create(FlinkJobServerDriver.FlinkServerConfiguration serverConfig) {
        return new FlinkJobInvoker(serverConfig);
    }

    private FlinkJobInvoker(FlinkJobServerDriver.FlinkServerConfiguration serverConfig) {
        super("flink-runner-job-invoker");
        this.serverConfig = serverConfig;
    }

    protected JobInvocation invokeWithExecutor(RunnerApi.Pipeline pipeline, Struct options, @Nullable String retrievalToken, ListeningExecutorService executorService) throws IOException {
        PortablePipelineOptions portableOptions;
        LOG.trace("Parsing pipeline options");
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)PipelineOptionsTranslation.fromProto((Struct)options).as(FlinkPipelineOptions.class);
        String invocationId = String.format("%s_%s", flinkOptions.getJobName(), UUID.randomUUID().toString());
        LOG.info("Invoking job {}", (Object)invocationId);
        if ("[auto]".equals(flinkOptions.getFlinkMaster())) {
            flinkOptions.setFlinkMaster(this.serverConfig.getFlinkMasterUrl());
        }
        if ((portableOptions = (PortablePipelineOptions)flinkOptions.as(PortablePipelineOptions.class)).getSdkWorkerParallelism() == 0L) {
            portableOptions.setSdkWorkerParallelism(this.serverConfig.getSdkWorkerParallelism());
        }
        flinkOptions.setRunner(null);
        return FlinkJobInvoker.createJobInvocation(invocationId, retrievalToken, executorService, pipeline, flinkOptions, this.serverConfig.getFlinkConfDir(), PipelineResources.detectClassPathResourcesToStage((ClassLoader)FlinkJobInvoker.class.getClassLoader()));
    }

    static JobInvocation createJobInvocation(String invocationId, String retrievalToken, ListeningExecutorService executorService, RunnerApi.Pipeline pipeline, FlinkPipelineOptions flinkOptions, @Nullable String confDir, List<String> filesToStage) {
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)flinkOptions.getJobName(), (String)retrievalToken, (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)flinkOptions));
        FlinkPipelineRunner pipelineRunner = new FlinkPipelineRunner(flinkOptions, confDir, filesToStage);
        return new JobInvocation(jobInfo, executorService, pipeline, (PortablePipelineRunner)pipelineRunner);
    }
}

