/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.graph.GreedyPipelineFuser;
import org.apache.beam.runners.core.construction.graph.PipelineTrimmer;
import org.apache.beam.runners.flink.FlinkBatchPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.flink.FlinkStreamingPortablePipelineTranslator;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.flink.api.common.JobExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkPipelineRunner
implements PortablePipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkPipelineRunner.class);
    private final FlinkPipelineOptions pipelineOptions;
    private final String confDir;
    private final List<String> filesToStage;

    public FlinkPipelineRunner(FlinkPipelineOptions pipelineOptions, @Nullable String confDir, List<String> filesToStage) {
        this.pipelineOptions = pipelineOptions;
        this.confDir = confDir;
        this.filesToStage = filesToStage;
    }

    public PipelineResult run(RunnerApi.Pipeline pipeline, JobInfo jobInfo) throws Exception {
        MetricsEnvironment.setMetricsSupported((boolean)false);
        FlinkPortablePipelineTranslator<FlinkStreamingPortablePipelineTranslator.StreamingTranslationContext> translator = !this.pipelineOptions.isStreaming() && !PipelineTranslatorUtils.hasUnboundedPCollections((RunnerApi.Pipeline)pipeline) ? FlinkBatchPortablePipelineTranslator.createTranslator() : new FlinkStreamingPortablePipelineTranslator();
        return this.runPipelineWithTranslator(pipeline, jobInfo, translator);
    }

    private <T extends FlinkPortablePipelineTranslator.TranslationContext> PipelineResult runPipelineWithTranslator(RunnerApi.Pipeline pipeline, JobInfo jobInfo, FlinkPortablePipelineTranslator<T> translator) throws Exception {
        LOG.info("Translating pipeline to Flink program.");
        RunnerApi.Pipeline trimmedPipeline = PipelineTrimmer.trim((RunnerApi.Pipeline)pipeline, translator.knownUrns());
        RunnerApi.Pipeline fusedPipeline = trimmedPipeline.getComponents().getTransformsMap().values().stream().anyMatch(proto -> "beam:runner:executable_stage:v1".equals(proto.getSpec().getUrn())) ? trimmedPipeline : GreedyPipelineFuser.fuse((RunnerApi.Pipeline)trimmedPipeline).toPipeline();
        FlinkPortablePipelineTranslator.Executor executor = translator.translate(translator.createTranslationContext(jobInfo, this.pipelineOptions, this.confDir, this.filesToStage), fusedPipeline);
        JobExecutionResult result = executor.execute(this.pipelineOptions.getJobName());
        return FlinkRunner.createPipelineResult(result, this.pipelineOptions);
    }
}

