/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.joda.time.Duration;

public class FlinkRunnerResult
implements PipelineResult {
    private final Map<String, Object> accumulators;
    private final long runtime;

    FlinkRunnerResult(Map<String, Object> accumulators, long runtime) {
        this.accumulators = accumulators == null || accumulators.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(accumulators);
        this.runtime = runtime;
    }

    public PipelineResult.State getState() {
        return PipelineResult.State.DONE;
    }

    public String toString() {
        return "FlinkRunnerResult{accumulators=" + this.accumulators + ", runtime=" + this.runtime + '}';
    }

    public PipelineResult.State cancel() throws IOException {
        throw new UnsupportedOperationException("FlinkRunnerResult does not support cancel.");
    }

    public PipelineResult.State waitUntilFinish() {
        return PipelineResult.State.DONE;
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        return PipelineResult.State.DONE;
    }

    public MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.getMetricsContainerStepMap());
    }

    MetricsContainerStepMap getMetricsContainerStepMap() {
        return (MetricsContainerStepMap)this.accumulators.get("__metricscontainers");
    }
}

