/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

class FlinkStreamingTranslationContext {
    private final StreamExecutionEnvironment env;
    private final PipelineOptions options;
    private final Map<PValue, DataStream<?>> dataStreams;
    private AppliedPTransform<?, ?, ?> currentTransform;

    public FlinkStreamingTranslationContext(StreamExecutionEnvironment env, PipelineOptions options) {
        this.env = (StreamExecutionEnvironment)Preconditions.checkNotNull((Object)env);
        this.options = (PipelineOptions)Preconditions.checkNotNull((Object)options);
        this.dataStreams = new HashMap();
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    public PipelineOptions getPipelineOptions() {
        return this.options;
    }

    public <T> DataStream<T> getInputDataStream(PValue value) {
        return this.dataStreams.get(value);
    }

    public void setOutputDataStream(PValue value, DataStream<?> set) {
        if (!this.dataStreams.containsKey(value)) {
            this.dataStreams.put(value, set);
        }
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public <T> Coder<WindowedValue<T>> getWindowedInputCoder(PCollection<T> collection) {
        Coder valueCoder = collection.getCoder();
        return WindowedValue.getFullCoder((Coder)valueCoder, (Coder)collection.getWindowingStrategy().getWindowFn().windowCoder());
    }

    public <T> Coder<T> getInputCoder(PCollection<T> collection) {
        return collection.getCoder();
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public <T> TypeInformation<WindowedValue<T>> getTypeInfo(PCollection<T> collection) {
        Coder valueCoder = collection.getCoder();
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder((Coder)valueCoder, (Coder)collection.getWindowingStrategy().getWindowFn().windowCoder());
        return new CoderTypeInformation<WindowedValue<T>>(windowedValueCoder);
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T extends PValue> T getInput(PTransform<T, ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform)));
    }

    public <T extends PInput> Map<TupleTag<?>, PValue> getInputs(PTransform<T, ?> transform) {
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getOutput(PTransform<?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public <OutputT extends POutput> Map<TupleTag<?>, PValue> getOutputs(PTransform<?, OutputT> transform) {
        return this.currentTransform.getOutputs();
    }
}

