/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptions;

public class ReaderInvocationUtil<OutputT, ReaderT extends Source.Reader<OutputT>> {
    private final String stepName;
    private final FlinkMetricContainer container;
    private final Boolean enableMetrics;

    public ReaderInvocationUtil(String stepName, PipelineOptions options, FlinkMetricContainer container) {
        FlinkPipelineOptions flinkPipelineOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        this.stepName = stepName;
        this.enableMetrics = flinkPipelineOptions.getEnableMetrics();
        this.container = container;
    }

    public boolean invokeStart(ReaderT reader) throws IOException {
        if (this.enableMetrics.booleanValue()) {
            try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
                boolean result = reader.start();
                this.container.updateMetrics(this.stepName);
                boolean bl = result;
                return bl;
            }
        }
        return reader.start();
    }

    public boolean invokeAdvance(ReaderT reader) throws IOException {
        if (this.enableMetrics.booleanValue()) {
            try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
                boolean result = reader.advance();
                this.container.updateMetrics(this.stepName);
                boolean bl = result;
                return bl;
            }
        }
        return reader.advance();
    }
}

