/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collection;
import org.apache.beam.runners.core.GlobalCombineFnRunner;
import org.apache.beam.runners.core.GlobalCombineFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Collector;

public abstract class AbstractFlinkCombineRunner<K, InputT, AccumT, OutputT, W extends BoundedWindow> {
    public abstract void combine(FlinkCombiner<K, InputT, AccumT, OutputT> var1, WindowingStrategy<Object, W> var2, SideInputReader var3, PipelineOptions var4, Iterable<WindowedValue<KV<K, InputT>>> var5, Collector<WindowedValue<KV<K, OutputT>>> var6) throws Exception;

    public static class FinalFlinkCombiner<K, AccumT, OutputT>
    implements FlinkCombiner<K, AccumT, AccumT, OutputT> {
        private final GlobalCombineFnRunner<?, AccumT, OutputT> combineFnRunner;

        public FinalFlinkCombiner(CombineFnBase.GlobalCombineFn<?, AccumT, OutputT> combineFn) {
            this.combineFnRunner = GlobalCombineFnRunners.create(combineFn);
        }

        @Override
        public AccumT firstInput(K key, AccumT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return value;
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, AccumT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return (AccumT)this.combineFnRunner.mergeAccumulators((Iterable)ImmutableList.of(accumulator, value), options, sideInputReader, windows);
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return (OutputT)this.combineFnRunner.extractOutput(accumulator, options, sideInputReader, windows);
        }
    }

    public static class PartialFlinkCombiner<K, InputT, AccumT>
    implements FlinkCombiner<K, InputT, AccumT, AccumT> {
        private final GlobalCombineFnRunner<InputT, AccumT, ?> combineFnRunner;

        public PartialFlinkCombiner(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn) {
            this.combineFnRunner = GlobalCombineFnRunners.create(combineFn);
        }

        @Override
        public AccumT firstInput(K key, InputT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            Object accumulator = this.combineFnRunner.createAccumulator(options, sideInputReader, windows);
            return (AccumT)this.combineFnRunner.addInput(accumulator, value, options, sideInputReader, windows);
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return (AccumT)this.combineFnRunner.addInput(accumulator, value, options, sideInputReader, windows);
        }

        @Override
        public AccumT extractOutput(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return accumulator;
        }
    }

    public static class CompleteFlinkCombiner<K, InputT, AccumT, OutputT>
    implements FlinkCombiner<K, InputT, AccumT, OutputT> {
        private final GlobalCombineFnRunner<InputT, AccumT, OutputT> combineFnRunner;

        public CompleteFlinkCombiner(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFnRunner = GlobalCombineFnRunners.create(combineFn);
        }

        @Override
        public AccumT firstInput(K key, InputT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            Object accumulator = this.combineFnRunner.createAccumulator(options, sideInputReader, windows);
            return (AccumT)this.combineFnRunner.addInput(accumulator, value, options, sideInputReader, windows);
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT value, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return (AccumT)this.combineFnRunner.addInput(accumulator, value, options, sideInputReader, windows);
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return (OutputT)this.combineFnRunner.extractOutput(accumulator, options, sideInputReader, windows);
        }
    }

    public static interface FlinkCombiner<K, InputT, AccumT, OutputT> {
        public AccumT firstInput(K var1, InputT var2, PipelineOptions var3, SideInputReader var4, Collection<? extends BoundedWindow> var5);

        public AccumT addInput(K var1, AccumT var2, InputT var3, PipelineOptions var4, SideInputReader var5, Collection<? extends BoundedWindow> var6);

        public OutputT extractOutput(K var1, AccumT var2, PipelineOptions var3, SideInputReader var4, Collection<? extends BoundedWindow> var5);
    }
}

