/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContext;
import org.apache.beam.runners.flink.translation.functions.ReferenceCountingFlinkExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.control.DefaultJobBundleFactory;
import org.apache.beam.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class FlinkDefaultExecutableStageContext
implements FlinkExecutableStageContext,
AutoCloseable {
    private final JobBundleFactory jobBundleFactory;

    private static FlinkDefaultExecutableStageContext create(JobInfo jobInfo) {
        DefaultJobBundleFactory jobBundleFactory = DefaultJobBundleFactory.create((JobInfo)jobInfo);
        return new FlinkDefaultExecutableStageContext((JobBundleFactory)jobBundleFactory);
    }

    private FlinkDefaultExecutableStageContext(JobBundleFactory jobBundleFactory) {
        this.jobBundleFactory = jobBundleFactory;
    }

    @Override
    public StageBundleFactory getStageBundleFactory(ExecutableStage executableStage) {
        return this.jobBundleFactory.forStage(executableStage);
    }

    @Override
    public void close() throws Exception {
        this.jobBundleFactory.close();
    }

    static enum MultiInstanceFactory implements FlinkExecutableStageContext.Factory
    {
        MULTI_INSTANCE;

        private static final ConcurrentMap<String, JobFactoryState> jobFactories;

        @Override
        public FlinkExecutableStageContext get(JobInfo jobInfo) {
            JobFactoryState state = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> {
                PortablePipelineOptions portableOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
                return new JobFactoryState(((Long)MoreObjects.firstNonNull((Object)portableOptions.getSdkWorkerParallelism(), (Object)1L)).intValue());
            });
            return state.getFactory().get(jobInfo);
        }

        static {
            jobFactories = new ConcurrentHashMap<String, JobFactoryState>();
        }
    }

    private static class JobFactoryState {
        private int index = 0;
        private final List<ReferenceCountingFlinkExecutableStageContextFactory> factories = new ArrayList<ReferenceCountingFlinkExecutableStageContextFactory>();
        private final int maxFactories;

        private JobFactoryState(int maxFactories) {
            Preconditions.checkArgument((maxFactories >= 0 ? 1 : 0) != 0, (Object)"sdk_worker_parallelism must be >= 0");
            this.maxFactories = maxFactories == 0 ? Math.max(Runtime.getRuntime().availableProcessors() - 1, 1) : maxFactories;
        }

        private synchronized FlinkExecutableStageContext.Factory getFactory() {
            ReferenceCountingFlinkExecutableStageContextFactory factory;
            if (this.factories.size() < this.maxFactories) {
                factory = ReferenceCountingFlinkExecutableStageContextFactory.create(x$0 -> FlinkDefaultExecutableStageContext.create(x$0));
                this.factories.add(factory);
            } else {
                factory = this.factories.get(this.index);
            }
            this.index = (this.index + 1) % this.maxFactories;
            return factory;
        }
    }
}

