/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

public class ImpulseSourceFunction
implements SourceFunction<WindowedValue<byte[]>> {
    private final boolean keepSourceAlive;
    private volatile boolean running;

    public ImpulseSourceFunction(boolean keepSourceAlive) {
        this.keepSourceAlive = keepSourceAlive;
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<WindowedValue<byte[]>> sourceContext) throws Exception {
        sourceContext.collect((Object)WindowedValue.valueInGlobalWindow((Object)new byte[0]));
        if (this.keepSourceAlive) {
            Object waitLock = new Object();
            while (this.running) {
                try {
                    Object object = waitLock;
                    synchronized (object) {
                        waitLock.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    if (this.running) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void cancel() {
        this.running = false;
    }
}

